/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.MedicationUsageCategory;

public class MedicationUsageCategoryEnumFactory
implements EnumFactory<MedicationUsageCategory> {
    @Override
    public MedicationUsageCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return MedicationUsageCategory.INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return MedicationUsageCategory.OUTPATIENT;
        }
        if ("community".equals(codeString)) {
            return MedicationUsageCategory.COMMUNITY;
        }
        if ("patientspecified".equals(codeString)) {
            return MedicationUsageCategory.PATIENTSPECIFIED;
        }
        throw new IllegalArgumentException("Unknown MedicationUsageCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MedicationUsageCategory code) {
        if (code == MedicationUsageCategory.INPATIENT) {
            return "inpatient";
        }
        if (code == MedicationUsageCategory.OUTPATIENT) {
            return "outpatient";
        }
        if (code == MedicationUsageCategory.COMMUNITY) {
            return "community";
        }
        if (code == MedicationUsageCategory.PATIENTSPECIFIED) {
            return "patientspecified";
        }
        return "?";
    }

    @Override
    public String toSystem(MedicationUsageCategory code) {
        return code.getSystem();
    }
}

