/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationIngredientstrength {
    QS,
    TRACE,
    NULL;


    public static MedicationIngredientstrength fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("qs".equals(codeString)) {
            return QS;
        }
        if ("trace".equals(codeString)) {
            return TRACE;
        }
        throw new FHIRException("Unknown MedicationIngredientstrength code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case QS: {
                return "qs";
            }
            case TRACE: {
                return "trace";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/CodeSystem/medication-ingredientstrength";
    }

    public String getDefinition() {
        switch (this) {
            case QS: {
                return "As much as is sufficient.";
            }
            case TRACE: {
                return "Very small amount.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case QS: {
                return "QS";
            }
            case TRACE: {
                return "Trace";
            }
        }
        return "?";
    }
}

