/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MapInputMode {
    SOURCE,
    TARGET,
    NULL;


    public static MapInputMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("source".equals(codeString)) {
            return SOURCE;
        }
        if ("target".equals(codeString)) {
            return TARGET;
        }
        throw new FHIRException("Unknown MapInputMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SOURCE: {
                return "source";
            }
            case TARGET: {
                return "target";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/map-input-mode";
    }

    public String getDefinition() {
        switch (this) {
            case SOURCE: {
                return "Names an input instance used a source for mapping.";
            }
            case TARGET: {
                return "Names an instance that is being populated.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SOURCE: {
                return "Source Instance";
            }
            case TARGET: {
                return "Target Instance";
            }
        }
        return "?";
    }
}

