/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LinkageType {
    SOURCE,
    ALTERNATE,
    HISTORICAL,
    NULL;


    public static LinkageType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("source".equals(codeString)) {
            return SOURCE;
        }
        if ("alternate".equals(codeString)) {
            return ALTERNATE;
        }
        if ("historical".equals(codeString)) {
            return HISTORICAL;
        }
        throw new FHIRException("Unknown LinkageType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SOURCE: {
                return "source";
            }
            case ALTERNATE: {
                return "alternate";
            }
            case HISTORICAL: {
                return "historical";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/linkage-type";
    }

    public String getDefinition() {
        switch (this) {
            case SOURCE: {
                return "The resource represents the \"source of truth\" (from the perspective of this Linkage resource) for the underlying event/condition/etc.";
            }
            case ALTERNATE: {
                return "The resource represents an alternative view of the underlying event/condition/etc.  The resource may still be actively maintained, even though it is not considered to be the source of truth.";
            }
            case HISTORICAL: {
                return "The resource represents an obsolete record of the underlying event/condition/etc.  It is not expected to be actively maintained.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SOURCE: {
                return "Source of Truth";
            }
            case ALTERNATE: {
                return "Alternate Record";
            }
            case HISTORICAL: {
                return "Historical/Obsolete Record";
            }
        }
        return "?";
    }
}

