/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.DefinitionUse;

public class DefinitionUseEnumFactory
implements EnumFactory<DefinitionUse> {
    @Override
    public DefinitionUse fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fhir-structure".equals(codeString)) {
            return DefinitionUse.FHIRSTRUCTURE;
        }
        if ("custom-resource".equals(codeString)) {
            return DefinitionUse.CUSTOMRESOURCE;
        }
        if ("dam".equals(codeString)) {
            return DefinitionUse.DAM;
        }
        if ("wire-format".equals(codeString)) {
            return DefinitionUse.WIREFORMAT;
        }
        if ("archetype".equals(codeString)) {
            return DefinitionUse.ARCHETYPE;
        }
        if ("template".equals(codeString)) {
            return DefinitionUse.TEMPLATE;
        }
        throw new IllegalArgumentException("Unknown DefinitionUse code '" + codeString + "'");
    }

    @Override
    public String toCode(DefinitionUse code) {
        if (code == DefinitionUse.FHIRSTRUCTURE) {
            return "fhir-structure";
        }
        if (code == DefinitionUse.CUSTOMRESOURCE) {
            return "custom-resource";
        }
        if (code == DefinitionUse.DAM) {
            return "dam";
        }
        if (code == DefinitionUse.WIREFORMAT) {
            return "wire-format";
        }
        if (code == DefinitionUse.ARCHETYPE) {
            return "archetype";
        }
        if (code == DefinitionUse.TEMPLATE) {
            return "template";
        }
        return "?";
    }

    @Override
    public String toSystem(DefinitionUse code) {
        return code.getSystem();
    }
}

