/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CoverageeligibilityresponseExAuthSupport {
    LABORDER,
    LABREPORT,
    DIAGNOSTICIMAGEORDER,
    DIAGNOSTICIMAGEREPORT,
    PROFESSIONALREPORT,
    ACCIDENTREPORT,
    MODEL,
    PICTURE,
    NULL;


    public static CoverageeligibilityresponseExAuthSupport fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("laborder".equals(codeString)) {
            return LABORDER;
        }
        if ("labreport".equals(codeString)) {
            return LABREPORT;
        }
        if ("diagnosticimageorder".equals(codeString)) {
            return DIAGNOSTICIMAGEORDER;
        }
        if ("diagnosticimagereport".equals(codeString)) {
            return DIAGNOSTICIMAGEREPORT;
        }
        if ("professionalreport".equals(codeString)) {
            return PROFESSIONALREPORT;
        }
        if ("accidentreport".equals(codeString)) {
            return ACCIDENTREPORT;
        }
        if ("model".equals(codeString)) {
            return MODEL;
        }
        if ("picture".equals(codeString)) {
            return PICTURE;
        }
        throw new FHIRException("Unknown CoverageeligibilityresponseExAuthSupport code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LABORDER: {
                return "laborder";
            }
            case LABREPORT: {
                return "labreport";
            }
            case DIAGNOSTICIMAGEORDER: {
                return "diagnosticimageorder";
            }
            case DIAGNOSTICIMAGEREPORT: {
                return "diagnosticimagereport";
            }
            case PROFESSIONALREPORT: {
                return "professionalreport";
            }
            case ACCIDENTREPORT: {
                return "accidentreport";
            }
            case MODEL: {
                return "model";
            }
            case PICTURE: {
                return "picture";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/coverageeligibilityresponse-ex-auth-support";
    }

    public String getDefinition() {
        switch (this) {
            case LABORDER: {
                return "A request or authorization for laboratory diagnostic tests.";
            }
            case LABREPORT: {
                return "A report on laboratory diagnostic test(s).";
            }
            case DIAGNOSTICIMAGEORDER: {
                return "A request or authorization for diagnostic imaging.";
            }
            case DIAGNOSTICIMAGEREPORT: {
                return "A report on diagnostic image(s).";
            }
            case PROFESSIONALREPORT: {
                return "A report from a licensed professional regarding the siutation, condition or proposed treatment.";
            }
            case ACCIDENTREPORT: {
                return "A formal accident report as would be filed with police or a simlar official body.";
            }
            case MODEL: {
                return "A physical model of the affected area.";
            }
            case PICTURE: {
                return "A photograph of the affected area.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LABORDER: {
                return "Lab Order";
            }
            case LABREPORT: {
                return "Lab Report";
            }
            case DIAGNOSTICIMAGEORDER: {
                return "Diagnostic Image Order";
            }
            case DIAGNOSTICIMAGEREPORT: {
                return "Diagnostic Image Report";
            }
            case PROFESSIONALREPORT: {
                return "Professional Report";
            }
            case ACCIDENTREPORT: {
                return "Accident Report";
            }
            case MODEL: {
                return "Model";
            }
            case PICTURE: {
                return "Picture";
            }
        }
        return "?";
    }
}

