/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CoverageCopayType {
    GPVISIT,
    SPVISIT,
    EMERGENCY,
    INPTHOSP,
    TELEVISIT,
    URGENTCARE,
    COPAYPCT,
    COPAY,
    DEDUCTIBLE,
    MAXOUTOFPOCKET,
    NULL;


    public static CoverageCopayType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("gpvisit".equals(codeString)) {
            return GPVISIT;
        }
        if ("spvisit".equals(codeString)) {
            return SPVISIT;
        }
        if ("emergency".equals(codeString)) {
            return EMERGENCY;
        }
        if ("inpthosp".equals(codeString)) {
            return INPTHOSP;
        }
        if ("televisit".equals(codeString)) {
            return TELEVISIT;
        }
        if ("urgentcare".equals(codeString)) {
            return URGENTCARE;
        }
        if ("copaypct".equals(codeString)) {
            return COPAYPCT;
        }
        if ("copay".equals(codeString)) {
            return COPAY;
        }
        if ("deductible".equals(codeString)) {
            return DEDUCTIBLE;
        }
        if ("maxoutofpocket".equals(codeString)) {
            return MAXOUTOFPOCKET;
        }
        throw new FHIRException("Unknown CoverageCopayType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GPVISIT: {
                return "gpvisit";
            }
            case SPVISIT: {
                return "spvisit";
            }
            case EMERGENCY: {
                return "emergency";
            }
            case INPTHOSP: {
                return "inpthosp";
            }
            case TELEVISIT: {
                return "televisit";
            }
            case URGENTCARE: {
                return "urgentcare";
            }
            case COPAYPCT: {
                return "copaypct";
            }
            case COPAY: {
                return "copay";
            }
            case DEDUCTIBLE: {
                return "deductible";
            }
            case MAXOUTOFPOCKET: {
                return "maxoutofpocket";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/coverage-copay-type";
    }

    public String getDefinition() {
        switch (this) {
            case GPVISIT: {
                return "An office visit for a general practitioner of a discipline.";
            }
            case SPVISIT: {
                return "An office visit for a specialist practitioner of a discipline";
            }
            case EMERGENCY: {
                return "An episode in an emergency department.";
            }
            case INPTHOSP: {
                return "An episode of an Inpatient hospital stay.";
            }
            case TELEVISIT: {
                return "A visit held where the patient is remote relative to the practitioner, e.g. by phone, computer or video conference.";
            }
            case URGENTCARE: {
                return "A visit to an urgent care facility - typically a community care clinic.";
            }
            case COPAYPCT: {
                return "A standard percentage applied to all classes or service or product not otherwise specified.";
            }
            case COPAY: {
                return "A standard fixed currency amount applied to all classes or service or product not otherwise specified.";
            }
            case DEDUCTIBLE: {
                return "The accumulated amount of patient payment before the coverage begins to pay for services.";
            }
            case MAXOUTOFPOCKET: {
                return "The maximum amout of payment for services which a patient, or family, is expected to incur - typically annually.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GPVISIT: {
                return "GP Office Visit";
            }
            case SPVISIT: {
                return "Specialist Office Visit";
            }
            case EMERGENCY: {
                return "Emergency";
            }
            case INPTHOSP: {
                return "Inpatient Hospital";
            }
            case TELEVISIT: {
                return "Tele-visit";
            }
            case URGENTCARE: {
                return "Urgent Care";
            }
            case COPAYPCT: {
                return "Copay Percentage";
            }
            case COPAY: {
                return "Copay Amount";
            }
            case DEDUCTIBLE: {
                return "Deductible";
            }
            case MAXOUTOFPOCKET: {
                return "Maximum out of pocket";
            }
        }
        return "?";
    }
}

