/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ConsentPolicy;

public class ConsentPolicyEnumFactory
implements EnumFactory<ConsentPolicy> {
    @Override
    public ConsentPolicy fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("cric".equals(codeString)) {
            return ConsentPolicy.CRIC;
        }
        if ("illinois-minor-procedure".equals(codeString)) {
            return ConsentPolicy.ILLINOISMINORPROCEDURE;
        }
        if ("hipaa-auth".equals(codeString)) {
            return ConsentPolicy.HIPAAAUTH;
        }
        if ("hipaa-npp".equals(codeString)) {
            return ConsentPolicy.HIPAANPP;
        }
        if ("hipaa-restrictions".equals(codeString)) {
            return ConsentPolicy.HIPAARESTRICTIONS;
        }
        if ("hipaa-research".equals(codeString)) {
            return ConsentPolicy.HIPAARESEARCH;
        }
        if ("hipaa-self-pay".equals(codeString)) {
            return ConsentPolicy.HIPAASELFPAY;
        }
        if ("mdhhs-5515".equals(codeString)) {
            return ConsentPolicy.MDHHS5515;
        }
        if ("nyssipp".equals(codeString)) {
            return ConsentPolicy.NYSSIPP;
        }
        if ("va-10-0484".equals(codeString)) {
            return ConsentPolicy.VA100484;
        }
        if ("va-10-0485".equals(codeString)) {
            return ConsentPolicy.VA100485;
        }
        if ("va-10-5345".equals(codeString)) {
            return ConsentPolicy.VA105345;
        }
        if ("va-10-5345a".equals(codeString)) {
            return ConsentPolicy.VA105345A;
        }
        if ("va-10-5345a-mhv".equals(codeString)) {
            return ConsentPolicy.VA105345AMHV;
        }
        if ("va-10-10116".equals(codeString)) {
            return ConsentPolicy.VA1010116;
        }
        if ("va-21-4142".equals(codeString)) {
            return ConsentPolicy.VA214142;
        }
        if ("ssa-827".equals(codeString)) {
            return ConsentPolicy.SSA827;
        }
        if ("dch-3927".equals(codeString)) {
            return ConsentPolicy.DCH3927;
        }
        if ("squaxin".equals(codeString)) {
            return ConsentPolicy.SQUAXIN;
        }
        if ("nl-lsp".equals(codeString)) {
            return ConsentPolicy.NLLSP;
        }
        if ("at-elga".equals(codeString)) {
            return ConsentPolicy.ATELGA;
        }
        if ("nih-hipaa".equals(codeString)) {
            return ConsentPolicy.NIHHIPAA;
        }
        if ("nci".equals(codeString)) {
            return ConsentPolicy.NCI;
        }
        if ("nih-grdr".equals(codeString)) {
            return ConsentPolicy.NIHGRDR;
        }
        if ("nih-527".equals(codeString)) {
            return ConsentPolicy.NIH527;
        }
        if ("ga4gh".equals(codeString)) {
            return ConsentPolicy.GA4GH;
        }
        throw new IllegalArgumentException("Unknown ConsentPolicy code '" + codeString + "'");
    }

    @Override
    public String toCode(ConsentPolicy code) {
        if (code == ConsentPolicy.CRIC) {
            return "cric";
        }
        if (code == ConsentPolicy.ILLINOISMINORPROCEDURE) {
            return "illinois-minor-procedure";
        }
        if (code == ConsentPolicy.HIPAAAUTH) {
            return "hipaa-auth";
        }
        if (code == ConsentPolicy.HIPAANPP) {
            return "hipaa-npp";
        }
        if (code == ConsentPolicy.HIPAARESTRICTIONS) {
            return "hipaa-restrictions";
        }
        if (code == ConsentPolicy.HIPAARESEARCH) {
            return "hipaa-research";
        }
        if (code == ConsentPolicy.HIPAASELFPAY) {
            return "hipaa-self-pay";
        }
        if (code == ConsentPolicy.MDHHS5515) {
            return "mdhhs-5515";
        }
        if (code == ConsentPolicy.NYSSIPP) {
            return "nyssipp";
        }
        if (code == ConsentPolicy.VA100484) {
            return "va-10-0484";
        }
        if (code == ConsentPolicy.VA100485) {
            return "va-10-0485";
        }
        if (code == ConsentPolicy.VA105345) {
            return "va-10-5345";
        }
        if (code == ConsentPolicy.VA105345A) {
            return "va-10-5345a";
        }
        if (code == ConsentPolicy.VA105345AMHV) {
            return "va-10-5345a-mhv";
        }
        if (code == ConsentPolicy.VA1010116) {
            return "va-10-10116";
        }
        if (code == ConsentPolicy.VA214142) {
            return "va-21-4142";
        }
        if (code == ConsentPolicy.SSA827) {
            return "ssa-827";
        }
        if (code == ConsentPolicy.DCH3927) {
            return "dch-3927";
        }
        if (code == ConsentPolicy.SQUAXIN) {
            return "squaxin";
        }
        if (code == ConsentPolicy.NLLSP) {
            return "nl-lsp";
        }
        if (code == ConsentPolicy.ATELGA) {
            return "at-elga";
        }
        if (code == ConsentPolicy.NIHHIPAA) {
            return "nih-hipaa";
        }
        if (code == ConsentPolicy.NCI) {
            return "nci";
        }
        if (code == ConsentPolicy.NIHGRDR) {
            return "nih-grdr";
        }
        if (code == ConsentPolicy.NIH527) {
            return "nih-527";
        }
        if (code == ConsentPolicy.GA4GH) {
            return "ga4gh";
        }
        return "?";
    }

    @Override
    public String toSystem(ConsentPolicy code) {
        return code.getSystem();
    }
}

