/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConditionQuestionnairePurpose {
    PREADMIT,
    DIFFDIAGNOSIS,
    OUTCOME,
    NULL;


    public static ConditionQuestionnairePurpose fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("preadmit".equals(codeString)) {
            return PREADMIT;
        }
        if ("diff-diagnosis".equals(codeString)) {
            return DIFFDIAGNOSIS;
        }
        if ("outcome".equals(codeString)) {
            return OUTCOME;
        }
        throw new FHIRException("Unknown ConditionQuestionnairePurpose code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PREADMIT: {
                return "preadmit";
            }
            case DIFFDIAGNOSIS: {
                return "diff-diagnosis";
            }
            case OUTCOME: {
                return "outcome";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/condition-questionnaire-purpose";
    }

    public String getDefinition() {
        switch (this) {
            case PREADMIT: {
                return "A pre-admit questionnaire.";
            }
            case DIFFDIAGNOSIS: {
                return "A questionnaire that helps with diferential diagnosis.";
            }
            case OUTCOME: {
                return "A questionnaire to check on outcomes for the patient.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PREADMIT: {
                return "Pre-admit";
            }
            case DIFFDIAGNOSIS: {
                return "Diff Diagnosis";
            }
            case OUTCOME: {
                return "Outcome";
            }
        }
        return "?";
    }
}

