/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConditionPreconditionType {
    SENSITIVE,
    SPECIFIC,
    NULL;


    public static ConditionPreconditionType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("sensitive".equals(codeString)) {
            return SENSITIVE;
        }
        if ("specific".equals(codeString)) {
            return SPECIFIC;
        }
        throw new FHIRException("Unknown ConditionPreconditionType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SENSITIVE: {
                return "sensitive";
            }
            case SPECIFIC: {
                return "specific";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/condition-precondition-type";
    }

    public String getDefinition() {
        switch (this) {
            case SENSITIVE: {
                return "The observation is very sensitive for the condition, but may also indicate other conditions.";
            }
            case SPECIFIC: {
                return "The observation is very specific for this condition, but not particularly sensitive.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SENSITIVE: {
                return "Sensitive";
            }
            case SPECIFIC: {
                return "Specific";
            }
        }
        return "?";
    }
}

