/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConceptMapRelationship {
    RELATEDTO,
    EQUIVALENT,
    BROADER,
    NARROWER,
    NOTRELATEDTO,
    NULL;


    public static ConceptMapRelationship fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("related-to".equals(codeString)) {
            return RELATEDTO;
        }
        if ("equivalent".equals(codeString)) {
            return EQUIVALENT;
        }
        if ("broader".equals(codeString)) {
            return BROADER;
        }
        if ("narrower".equals(codeString)) {
            return NARROWER;
        }
        if ("not-related-to".equals(codeString)) {
            return NOTRELATEDTO;
        }
        throw new FHIRException("Unknown ConceptMapRelationship code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RELATEDTO: {
                return "related-to";
            }
            case EQUIVALENT: {
                return "equivalent";
            }
            case BROADER: {
                return "broader";
            }
            case NARROWER: {
                return "narrower";
            }
            case NOTRELATEDTO: {
                return "not-related-to";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/concept-map-relationship";
    }

    public String getDefinition() {
        switch (this) {
            case RELATEDTO: {
                return "The concepts are related to each other, but the exact relationship is not known.";
            }
            case EQUIVALENT: {
                return "The definitions of the concepts mean the same thing.";
            }
            case BROADER: {
                return "The target concept is broader in meaning than the source concept.";
            }
            case NARROWER: {
                return "The target concept is narrower in meaning than the source concept.";
            }
            case NOTRELATEDTO: {
                return "This is an explicit assertion that the target concept is not related to the source concept.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RELATEDTO: {
                return "Related To";
            }
            case EQUIVALENT: {
                return "Equivalent";
            }
            case BROADER: {
                return "Broader";
            }
            case NARROWER: {
                return "Narrower";
            }
            case NOTRELATEDTO: {
                return "Not Related To";
            }
        }
        return "?";
    }
}

