/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogType {
    MEDICATION,
    DEVICE,
    PROTOCOL,
    NULL;


    public static CatalogType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("medication".equals(codeString)) {
            return MEDICATION;
        }
        if ("device".equals(codeString)) {
            return DEVICE;
        }
        if ("protocol".equals(codeString)) {
            return PROTOCOL;
        }
        throw new FHIRException("Unknown CatalogType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MEDICATION: {
                return "medication";
            }
            case DEVICE: {
                return "device";
            }
            case PROTOCOL: {
                return "protocol";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/catalogType";
    }

    public String getDefinition() {
        switch (this) {
            case MEDICATION: {
                return "Medication Catalog.";
            }
            case DEVICE: {
                return "Device Catalog.";
            }
            case PROTOCOL: {
                return "Protocol List.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MEDICATION: {
                return "Medication Catalog";
            }
            case DEVICE: {
                return "Device Catalog";
            }
            case PROTOCOL: {
                return "Protocol List";
            }
        }
        return "?";
    }
}

