/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionParticipantType {
    PATIENT,
    PRACTITIONER,
    RELATEDPERSON,
    DEVICE,
    NULL;


    public static ActionParticipantType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        if ("practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("related-person".equals(codeString)) {
            return RELATEDPERSON;
        }
        if ("device".equals(codeString)) {
            return DEVICE;
        }
        throw new FHIRException("Unknown ActionParticipantType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PATIENT: {
                return "patient";
            }
            case PRACTITIONER: {
                return "practitioner";
            }
            case RELATEDPERSON: {
                return "related-person";
            }
            case DEVICE: {
                return "device";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-participant-type";
    }

    public String getDefinition() {
        switch (this) {
            case PATIENT: {
                return "The participant is the patient under evaluation.";
            }
            case PRACTITIONER: {
                return "The participant is a practitioner involved in the patient's care.";
            }
            case RELATEDPERSON: {
                return "The participant is a person related to the patient.";
            }
            case DEVICE: {
                return "The participant is a system or device used in the care of the patient.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PATIENT: {
                return "Patient";
            }
            case PRACTITIONER: {
                return "Practitioner";
            }
            case RELATEDPERSON: {
                return "Related Person";
            }
            case DEVICE: {
                return "Device";
            }
        }
        return "?";
    }
}

