/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Type;

@DatatypeDef(name="Ratio")
public class Ratio
extends Type
implements ICompositeType {
    @Child(name="numerator", type={Quantity.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Numerator value", formalDefinition="The value of the numerator.")
    protected Quantity numerator;
    @Child(name="denominator", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Denominator value", formalDefinition="The value of the denominator.")
    protected Quantity denominator;
    private static final long serialVersionUID = 479922563L;

    public Quantity getNumerator() {
        if (this.numerator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ratio.numerator");
            }
            if (Configuration.doAutoCreate()) {
                this.numerator = new Quantity();
            }
        }
        return this.numerator;
    }

    public boolean hasNumerator() {
        return this.numerator != null && !this.numerator.isEmpty();
    }

    public Ratio setNumerator(Quantity value) {
        this.numerator = value;
        return this;
    }

    public Quantity getDenominator() {
        if (this.denominator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ratio.denominator");
            }
            if (Configuration.doAutoCreate()) {
                this.denominator = new Quantity();
            }
        }
        return this.denominator;
    }

    public boolean hasDenominator() {
        return this.denominator != null && !this.denominator.isEmpty();
    }

    public Ratio setDenominator(Quantity value) {
        this.denominator = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("numerator", "Quantity", "The value of the numerator.", 0, 1, this.numerator));
        children.add(new Property("denominator", "Quantity", "The value of the denominator.", 0, 1, this.denominator));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1747334793: {
                return new Property("numerator", "Quantity", "The value of the numerator.", 0, 1, this.numerator);
            }
            case -1983274394: {
                return new Property("denominator", "Quantity", "The value of the denominator.", 0, 1, this.denominator);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                Base[] baseArray;
                if (this.numerator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.numerator;
                }
                return baseArray;
            }
            case -1983274394: {
                Base[] baseArray;
                if (this.denominator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.denominator;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                this.numerator = this.castToQuantity(value);
                return value;
            }
            case -1983274394: {
                this.denominator = this.castToQuantity(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("numerator")) {
            this.numerator = this.castToQuantity(value);
        } else if (name.equals("denominator")) {
            this.denominator = this.castToQuantity(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                return this.getNumerator();
            }
            case -1983274394: {
                return this.getDenominator();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                return new String[]{"Quantity"};
            }
            case -1983274394: {
                return new String[]{"Quantity"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("numerator")) {
            this.numerator = new Quantity();
            return this.numerator;
        }
        if (name.equals("denominator")) {
            this.denominator = new Quantity();
            return this.denominator;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Ratio";
    }

    @Override
    public Ratio copy() {
        Ratio dst = new Ratio();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Ratio dst) {
        super.copyValues(dst);
        dst.numerator = this.numerator == null ? null : this.numerator.copy();
        dst.denominator = this.denominator == null ? null : this.denominator.copy();
    }

    @Override
    protected Ratio typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Ratio)) {
            return false;
        }
        Ratio o = (Ratio)other_;
        return Ratio.compareDeep(this.numerator, o.numerator, true) && Ratio.compareDeep(this.denominator, o.denominator, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Ratio)) {
            return false;
        }
        Ratio o = (Ratio)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.numerator, this.denominator});
    }
}

