/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Type;

@ResourceDef(name="NutritionIntake", profile="http://hl7.org/fhir/StructureDefinition/NutritionIntake")
public class NutritionIntake
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifiers associated with this Nutrition Intake that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={NutritionOrder.class, CarePlan.class, ServiceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfils plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this event.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={NutritionIntake.class, Procedure.class, Observation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | completed | entered-in-error | intended | stopped | on-hold | unknown | not-taken", formalDefinition="A code representing the patient or other source's judgment about the state of the intake that this assertion is about.  Generally, this will be active or completed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/nutrition-intake-status")
    protected Enumeration<NutritionIntakeStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current state of the NutritionIntake.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-status-codes")
    protected List<CodeableConcept> statusReason;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of nutrition intake setting/reporting", formalDefinition="Indicates where the food or fluid was  consumed or prescribed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/nutrition-intake-category")
    protected List<CodeableConcept> category;
    @Child(name="consumedItem", type={}, order=6, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What food or fluid product or item was consumed", formalDefinition="What food or fluid product or item was consumed.")
    protected List<NutritionIntakeConsumedItemComponent> consumedItem;
    @Child(name="ingredientLabel", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Total nutrient for the whole meal, product, serving", formalDefinition="Total nutrient amounts for the whole meal, product, serving, etc.")
    protected List<NutritionIntakeIngredientLabelComponent> ingredientLabel;
    @Child(name="subject", type={Patient.class, Group.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is/was consuming the food or fluid", formalDefinition="The person, animal or group who is/was consuming the food or fluid.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter associated with NutritionIntake", formalDefinition="The encounter that establishes the context for this NutritionIntake.")
    protected Reference encounter;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date/time or interval when the food or fluid is/was consumed", formalDefinition="The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.")
    protected Type effective;
    @Child(name="dateAsserted", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the consumption was asserted?", formalDefinition="The date when the Nutrition Intake was asserted by the information source.")
    protected DateTimeType dateAsserted;
    @Child(name="informationSource", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Organization.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Person or organization that provided the information about the consumption of this food or fluid", formalDefinition="The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.")
    protected Reference informationSource;
    @Child(name="derivedFrom", type={Reference.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional supporting information", formalDefinition="Allows linking the NutritionIntake to the underlying NutritionOrder, or to other information, such as AllergyIntolerance, that supports or is used to derive the NutritionIntake.")
    protected List<Reference> derivedFrom;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for why the food or fluid is /was consumed", formalDefinition="A reason for why the food or fluid is /was consumed.")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class, DiagnosticReport.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition or observation that supports why the food or fluid is /was consumed", formalDefinition="Condition or observation that supports why the food or fluid is /was consumed.")
    protected List<Reference> reasonReference;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Further information about the consumption", formalDefinition="Provides extra information about the Nutrition Intake that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 1482407460L;
    @SearchParamDefinition(name="identifier", path="NutritionIntake.identifier", description="Return statements with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="effective", path="NutritionIntake.effective", description="Date when patient was taking (or not taking) the medication", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="nutrition", path="NutritionIntake.consumedItem.nutritionProduct", description="Return statements of this medication reference", type="token")
    public static final String SP_NUTRITION = "nutrition";
    public static final TokenClientParam NUTRITION = new TokenClientParam("nutrition");
    @SearchParamDefinition(name="subject", path="NutritionIntake.subject", description="The identity of a patient, animal or group to list statements for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("NutritionIntake:subject").toLocked();
    @SearchParamDefinition(name="patient", path="NutritionIntake.subject.where(resolve() is Patient)", description="Returns statements for a specific patient.", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("NutritionIntake:patient").toLocked();
    @SearchParamDefinition(name="part-of", path="NutritionIntake.partOf", description="Returns statements that are part of another event.", type="reference", target={NutritionIntake.class, Observation.class, Procedure.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("NutritionIntake:part-of").toLocked();
    @SearchParamDefinition(name="source", path="NutritionIntake.informationSource", description="Who or where the information in the statement came from", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("NutritionIntake:source").toLocked();
    @SearchParamDefinition(name="encounter", path="NutritionIntake.encounter", description="Returns statements for a specific encounter", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("NutritionIntake:encounter").toLocked();
    @SearchParamDefinition(name="category", path="NutritionIntake.category", description="Returns statements of this category of NutritionIntake", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="NutritionIntake.status", description="Return statements that match the given status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public NutritionIntake() {
    }

    public NutritionIntake(Enumeration<NutritionIntakeStatus> status, Reference subject) {
        this.status = status;
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public NutritionIntake setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public NutritionIntake addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public NutritionIntake setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public NutritionIntake addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public NutritionIntake setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public NutritionIntake addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<NutritionIntakeStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<NutritionIntakeStatus>(new NutritionIntakeStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public NutritionIntake setStatusElement(Enumeration<NutritionIntakeStatus> value) {
        this.status = value;
        return this;
    }

    public NutritionIntakeStatus getStatus() {
        return this.status == null ? null : (NutritionIntakeStatus)((Object)this.status.getValue());
    }

    public NutritionIntake setStatus(NutritionIntakeStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<NutritionIntakeStatus>(new NutritionIntakeStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getStatusReason() {
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        return this.statusReason;
    }

    public NutritionIntake setStatusReason(List<CodeableConcept> theStatusReason) {
        this.statusReason = theStatusReason;
        return this;
    }

    public boolean hasStatusReason() {
        if (this.statusReason == null) {
            return false;
        }
        for (CodeableConcept item : this.statusReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStatusReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return t;
    }

    public NutritionIntake addStatusReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return this;
    }

    public CodeableConcept getStatusReasonFirstRep() {
        if (this.getStatusReason().isEmpty()) {
            this.addStatusReason();
        }
        return this.getStatusReason().get(0);
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public NutritionIntake setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public NutritionIntake addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<NutritionIntakeConsumedItemComponent> getConsumedItem() {
        if (this.consumedItem == null) {
            this.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
        }
        return this.consumedItem;
    }

    public NutritionIntake setConsumedItem(List<NutritionIntakeConsumedItemComponent> theConsumedItem) {
        this.consumedItem = theConsumedItem;
        return this;
    }

    public boolean hasConsumedItem() {
        if (this.consumedItem == null) {
            return false;
        }
        for (NutritionIntakeConsumedItemComponent item : this.consumedItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionIntakeConsumedItemComponent addConsumedItem() {
        NutritionIntakeConsumedItemComponent t = new NutritionIntakeConsumedItemComponent();
        if (this.consumedItem == null) {
            this.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
        }
        this.consumedItem.add(t);
        return t;
    }

    public NutritionIntake addConsumedItem(NutritionIntakeConsumedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.consumedItem == null) {
            this.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
        }
        this.consumedItem.add(t);
        return this;
    }

    public NutritionIntakeConsumedItemComponent getConsumedItemFirstRep() {
        if (this.getConsumedItem().isEmpty()) {
            this.addConsumedItem();
        }
        return this.getConsumedItem().get(0);
    }

    public List<NutritionIntakeIngredientLabelComponent> getIngredientLabel() {
        if (this.ingredientLabel == null) {
            this.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
        }
        return this.ingredientLabel;
    }

    public NutritionIntake setIngredientLabel(List<NutritionIntakeIngredientLabelComponent> theIngredientLabel) {
        this.ingredientLabel = theIngredientLabel;
        return this;
    }

    public boolean hasIngredientLabel() {
        if (this.ingredientLabel == null) {
            return false;
        }
        for (NutritionIntakeIngredientLabelComponent item : this.ingredientLabel) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionIntakeIngredientLabelComponent addIngredientLabel() {
        NutritionIntakeIngredientLabelComponent t = new NutritionIntakeIngredientLabelComponent();
        if (this.ingredientLabel == null) {
            this.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
        }
        this.ingredientLabel.add(t);
        return t;
    }

    public NutritionIntake addIngredientLabel(NutritionIntakeIngredientLabelComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredientLabel == null) {
            this.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
        }
        this.ingredientLabel.add(t);
        return this;
    }

    public NutritionIntakeIngredientLabelComponent getIngredientLabelFirstRep() {
        if (this.getIngredientLabel().isEmpty()) {
            this.addIngredientLabel();
        }
        return this.getIngredientLabel().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public NutritionIntake setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public NutritionIntake setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public NutritionIntake setEffective(Type value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for NutritionIntake.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public DateTimeType getDateAssertedElement() {
        if (this.dateAsserted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.dateAsserted");
            }
            if (Configuration.doAutoCreate()) {
                this.dateAsserted = new DateTimeType();
            }
        }
        return this.dateAsserted;
    }

    public boolean hasDateAssertedElement() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public boolean hasDateAsserted() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public NutritionIntake setDateAssertedElement(DateTimeType value) {
        this.dateAsserted = value;
        return this;
    }

    public Date getDateAsserted() {
        return this.dateAsserted == null ? null : (Date)this.dateAsserted.getValue();
    }

    public NutritionIntake setDateAsserted(Date value) {
        if (value == null) {
            this.dateAsserted = null;
        } else {
            if (this.dateAsserted == null) {
                this.dateAsserted = new DateTimeType();
            }
            this.dateAsserted.setValue(value);
        }
        return this;
    }

    public Reference getInformationSource() {
        if (this.informationSource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionIntake.informationSource");
            }
            if (Configuration.doAutoCreate()) {
                this.informationSource = new Reference();
            }
        }
        return this.informationSource;
    }

    public boolean hasInformationSource() {
        return this.informationSource != null && !this.informationSource.isEmpty();
    }

    public NutritionIntake setInformationSource(Reference value) {
        this.informationSource = value;
        return this;
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public NutritionIntake setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public NutritionIntake addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public NutritionIntake setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public NutritionIntake addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public NutritionIntake setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public NutritionIntake addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public NutritionIntake setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public NutritionIntake addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Nutrition Intake that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(NutritionOrder|CarePlan|ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(NutritionIntake|Procedure|Observation)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "A code representing the patient or other source's judgment about the state of the intake that this assertion is about.  Generally, this will be active or completed.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the NutritionIntake.", 0, Integer.MAX_VALUE, this.statusReason));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Indicates where the food or fluid was  consumed or prescribed.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("consumedItem", "", "What food or fluid product or item was consumed.", 0, Integer.MAX_VALUE, this.consumedItem));
        children.add(new Property("ingredientLabel", "", "Total nutrient amounts for the whole meal, product, serving, etc.", 0, Integer.MAX_VALUE, this.ingredientLabel));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was consuming the food or fluid.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this NutritionIntake.", 0, 1, this.encounter));
        children.add(new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.effective));
        children.add(new Property("dateAsserted", "dateTime", "The date when the Nutrition Intake was asserted by the information source.", 0, 1, this.dateAsserted));
        children.add(new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.", 0, 1, this.informationSource));
        children.add(new Property("derivedFrom", "Reference(Any)", "Allows linking the NutritionIntake to the underlying NutritionOrder, or to other information, such as AllergyIntolerance, that supports or is used to derive the NutritionIntake.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("reasonCode", "CodeableConcept", "A reason for why the food or fluid is /was consumed.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport)", "Condition or observation that supports why the food or fluid is /was consumed.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("note", "Annotation", "Provides extra information about the Nutrition Intake that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Nutrition Intake that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(NutritionOrder|CarePlan|ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(NutritionIntake|Procedure|Observation)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "A code representing the patient or other source's judgment about the state of the intake that this assertion is about.  Generally, this will be active or completed.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the NutritionIntake.", 0, Integer.MAX_VALUE, this.statusReason);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Indicates where the food or fluid was  consumed or prescribed.", 0, Integer.MAX_VALUE, this.category);
            }
            case -854114533: {
                return new Property("consumedItem", "", "What food or fluid product or item was consumed.", 0, Integer.MAX_VALUE, this.consumedItem);
            }
            case -936536157: {
                return new Property("ingredientLabel", "", "Total nutrient amounts for the whole meal, product, serving, etc.", 0, Integer.MAX_VALUE, this.ingredientLabel);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was consuming the food or fluid.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this NutritionIntake.", 0, 1, this.encounter);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient is/was consuming the food or fluid.", 0, 1, this.effective);
            }
            case -1980855245: {
                return new Property("dateAsserted", "dateTime", "The date when the Nutrition Intake was asserted by the information source.", 0, 1, this.dateAsserted);
            }
            case -2123220889: {
                return new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "The person or organization that provided the information about the consumption of this food or fluid. Note: Use derivedFrom when a NutritionIntake is derived from other resources.", 0, 1, this.informationSource);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(Any)", "Allows linking the NutritionIntake to the underlying NutritionOrder, or to other information, such as AllergyIntolerance, that supports or is used to derive the NutritionIntake.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "A reason for why the food or fluid is /was consumed.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport)", "Condition or observation that supports why the food or fluid is /was consumed.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides extra information about the Nutrition Intake that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -854114533: {
                return this.consumedItem == null ? new Base[]{} : this.consumedItem.toArray(new Base[this.consumedItem.size()]);
            }
            case -936536157: {
                return this.ingredientLabel == null ? new Base[]{} : this.ingredientLabel.toArray(new Base[this.ingredientLabel.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.encounter;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.effective;
                }
                return baseArray;
            }
            case -1980855245: {
                Base[] baseArray;
                if (this.dateAsserted == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.dateAsserted;
                }
                return baseArray;
            }
            case -2123220889: {
                Base[] baseArray;
                if (this.informationSource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.informationSource;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new NutritionIntakeStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.getStatusReason().add(this.castToCodeableConcept(value));
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case -854114533: {
                this.getConsumedItem().add((NutritionIntakeConsumedItemComponent)((Object)value));
                return value;
            }
            case -936536157: {
                this.getIngredientLabel().add((NutritionIntakeIngredientLabelComponent)((Object)value));
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = this.castToType(value);
                return value;
            }
            case -1980855245: {
                this.dateAsserted = this.castToDateTime(value);
                return value;
            }
            case -2123220889: {
                this.informationSource = this.castToReference(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(this.castToReference(value));
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new NutritionIntakeStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.getStatusReason().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals("consumedItem")) {
            this.getConsumedItem().add((NutritionIntakeConsumedItemComponent)((Object)value));
        } else if (name.equals("ingredientLabel")) {
            this.getIngredientLabel().add((NutritionIntakeIngredientLabelComponent)((Object)value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = this.castToType(value);
        } else if (name.equals("dateAsserted")) {
            this.dateAsserted = this.castToDateTime(value);
        } else if (name.equals("informationSource")) {
            this.informationSource = this.castToReference(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(this.castToReference(value));
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.addStatusReason();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -854114533: {
                return this.addConsumedItem();
            }
            case -936536157: {
                return this.addIngredientLabel();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1980855245: {
                return this.getDateAssertedElement();
            }
            case -2123220889: {
                return this.getInformationSource();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -854114533: {
                return new String[0];
            }
            case -936536157: {
                return new String[0];
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case -1980855245: {
                return new String[]{"dateTime"};
            }
            case -2123220889: {
                return new String[]{"Reference"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionIntake.status");
        }
        if (name.equals("statusReason")) {
            return this.addStatusReason();
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals("consumedItem")) {
            return this.addConsumedItem();
        }
        if (name.equals("ingredientLabel")) {
            return this.addIngredientLabel();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals("dateAsserted")) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionIntake.dateAsserted");
        }
        if (name.equals("informationSource")) {
            this.informationSource = new Reference();
            return this.informationSource;
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "NutritionIntake";
    }

    @Override
    public NutritionIntake copy() {
        NutritionIntake dst = new NutritionIntake();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(NutritionIntake dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        Enumeration<NutritionIntakeStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusReason != null) {
            dst.statusReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.statusReason) {
                dst.statusReason.add(codeableConcept.copy());
            }
        }
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        if (this.consumedItem != null) {
            dst.consumedItem = new ArrayList<NutritionIntakeConsumedItemComponent>();
            for (NutritionIntakeConsumedItemComponent nutritionIntakeConsumedItemComponent : this.consumedItem) {
                dst.consumedItem.add(nutritionIntakeConsumedItemComponent.copy());
            }
        }
        if (this.ingredientLabel != null) {
            dst.ingredientLabel = new ArrayList<NutritionIntakeIngredientLabelComponent>();
            for (NutritionIntakeIngredientLabelComponent nutritionIntakeIngredientLabelComponent : this.ingredientLabel) {
                dst.ingredientLabel.add(nutritionIntakeIngredientLabelComponent.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        dst.dateAsserted = this.dateAsserted == null ? null : this.dateAsserted.copy();
        Reference reference = dst.informationSource = this.informationSource == null ? null : this.informationSource.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference2 : this.derivedFrom) {
                dst.derivedFrom.add(reference2.copy());
            }
        }
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference3 : this.reasonReference) {
                dst.reasonReference.add(reference3.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected NutritionIntake typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionIntake)) {
            return false;
        }
        NutritionIntake o = (NutritionIntake)other_;
        return NutritionIntake.compareDeep(this.identifier, o.identifier, true) && NutritionIntake.compareDeep(this.basedOn, o.basedOn, true) && NutritionIntake.compareDeep(this.partOf, o.partOf, true) && NutritionIntake.compareDeep(this.status, o.status, true) && NutritionIntake.compareDeep(this.statusReason, o.statusReason, true) && NutritionIntake.compareDeep(this.category, o.category, true) && NutritionIntake.compareDeep(this.consumedItem, o.consumedItem, true) && NutritionIntake.compareDeep(this.ingredientLabel, o.ingredientLabel, true) && NutritionIntake.compareDeep(this.subject, o.subject, true) && NutritionIntake.compareDeep(this.encounter, o.encounter, true) && NutritionIntake.compareDeep(this.effective, o.effective, true) && NutritionIntake.compareDeep(this.dateAsserted, o.dateAsserted, true) && NutritionIntake.compareDeep(this.informationSource, o.informationSource, true) && NutritionIntake.compareDeep(this.derivedFrom, o.derivedFrom, true) && NutritionIntake.compareDeep(this.reasonCode, o.reasonCode, true) && NutritionIntake.compareDeep(this.reasonReference, o.reasonReference, true) && NutritionIntake.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionIntake)) {
            return false;
        }
        NutritionIntake o = (NutritionIntake)other_;
        return NutritionIntake.compareValues(this.status, o.status, true) && NutritionIntake.compareValues(this.dateAsserted, o.dateAsserted, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.status, this.statusReason, this.category, this.consumedItem, this.ingredientLabel, this.subject, this.encounter, this.effective, this.dateAsserted, this.informationSource, this.derivedFrom, this.reasonCode, this.reasonReference, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.NutritionIntake;
    }

    @Block
    public static class NutritionIntakeIngredientLabelComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="nutrient", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total nutrient consumed", formalDefinition="Total nutrient consumed. This could be a macronutrient (protein, fat, carbohydrate), or a vitamin and mineral.")
        protected CodeableConcept nutrient;
        @Child(name="amount", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total amount of nutrient consumed", formalDefinition="Total amount of nutrient consumed.")
        protected Quantity amount;
        private static final long serialVersionUID = -1026365827L;

        public NutritionIntakeIngredientLabelComponent() {
        }

        public NutritionIntakeIngredientLabelComponent(CodeableConcept nutrient, Quantity amount) {
            this.nutrient = nutrient;
            this.amount = amount;
        }

        public CodeableConcept getNutrient() {
            if (this.nutrient == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeIngredientLabelComponent.nutrient");
                }
                if (Configuration.doAutoCreate()) {
                    this.nutrient = new CodeableConcept();
                }
            }
            return this.nutrient;
        }

        public boolean hasNutrient() {
            return this.nutrient != null && !this.nutrient.isEmpty();
        }

        public NutritionIntakeIngredientLabelComponent setNutrient(CodeableConcept value) {
            this.nutrient = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeIngredientLabelComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public NutritionIntakeIngredientLabelComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("nutrient", "CodeableConcept", "Total nutrient consumed. This could be a macronutrient (protein, fat, carbohydrate), or a vitamin and mineral.", 0, 1, this.nutrient));
            children.add(new Property("amount", "SimpleQuantity", "Total amount of nutrient consumed.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1671151641: {
                    return new Property("nutrient", "CodeableConcept", "Total nutrient consumed. This could be a macronutrient (protein, fat, carbohydrate), or a vitamin and mineral.", 0, 1, this.nutrient);
                }
                case -1413853096: {
                    return new Property("amount", "SimpleQuantity", "Total amount of nutrient consumed.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    Base[] baseArray;
                    if (this.nutrient == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.nutrient;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    this.nutrient = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("nutrient")) {
                this.nutrient = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    return this.getNutrient();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1671151641: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"SimpleQuantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("nutrient")) {
                this.nutrient = new CodeableConcept();
                return this.nutrient;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionIntakeIngredientLabelComponent copy() {
            NutritionIntakeIngredientLabelComponent dst = new NutritionIntakeIngredientLabelComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionIntakeIngredientLabelComponent dst) {
            super.copyValues(dst);
            dst.nutrient = this.nutrient == null ? null : this.nutrient.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeIngredientLabelComponent)) {
                return false;
            }
            NutritionIntakeIngredientLabelComponent o = (NutritionIntakeIngredientLabelComponent)other_;
            return NutritionIntakeIngredientLabelComponent.compareDeep(this.nutrient, o.nutrient, true) && NutritionIntakeIngredientLabelComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeIngredientLabelComponent)) {
                return false;
            }
            NutritionIntakeIngredientLabelComponent o = (NutritionIntakeIngredientLabelComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.nutrient, this.amount});
        }

        @Override
        public String fhirType() {
            return "NutritionIntake.ingredientLabel";
        }
    }

    @Block
    public static class NutritionIntakeConsumedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of food or fluid product", formalDefinition="Indicates what a category of item that was consumed: eg., food, fluid, enteral, etc.")
        protected CodeableConcept type;
        @Child(name="nutritionProduct", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code that identifies the food or fluid product that was consumed", formalDefinition="Identifies the food or fluid product that was consumed. This is potentially a link to a resource representing the details of the food product (TBD) or a simple attribute carrying a code that identifies the food from a known list of foods.")
        protected CodeableConcept nutritionProduct;
        @Child(name="schedule", type={Timing.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of consumption", formalDefinition="Scheduled frequency of consumption.")
        protected Timing schedule;
        @Child(name="amount", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantity of the specified food", formalDefinition="Quantity of the specified food.")
        protected Quantity amount;
        @Child(name="rate", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rate at which enteral feeding was administered", formalDefinition="Rate at which enteral feeding was administered.")
        protected Quantity rate;
        @Child(name="notConsumed", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Flag to indicate if the food or fluid item was refused or otherwise not consumed", formalDefinition="Indicator when a patient is in a setting where it is helpful to know if food was not consumed, such as it was refused, held (as in tube feedings), or otherwise not provided. If a consumption is being recorded from an app, such as MyFitnessPal, this indicator will likely not be used.")
        protected BooleanType notConsumed;
        @Child(name="notConsumedReason", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason food or fluid was not consumed", formalDefinition="Document the reason the food or fluid was not consumed, such as refused, held, etc.")
        protected CodeableConcept notConsumedReason;
        private static final long serialVersionUID = -608839799L;

        public NutritionIntakeConsumedItemComponent() {
        }

        public NutritionIntakeConsumedItemComponent(CodeableConcept type, CodeableConcept nutritionProduct) {
            this.type = type;
            this.nutritionProduct = nutritionProduct;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getNutritionProduct() {
            if (this.nutritionProduct == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.nutritionProduct");
                }
                if (Configuration.doAutoCreate()) {
                    this.nutritionProduct = new CodeableConcept();
                }
            }
            return this.nutritionProduct;
        }

        public boolean hasNutritionProduct() {
            return this.nutritionProduct != null && !this.nutritionProduct.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setNutritionProduct(CodeableConcept value) {
            this.nutritionProduct = value;
            return this;
        }

        public Timing getSchedule() {
            if (this.schedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.schedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.schedule = new Timing();
                }
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            return this.schedule != null && !this.schedule.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setSchedule(Timing value) {
            this.schedule = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        public Quantity getRate() {
            if (this.rate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.rate");
                }
                if (Configuration.doAutoCreate()) {
                    this.rate = new Quantity();
                }
            }
            return this.rate;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setRate(Quantity value) {
            this.rate = value;
            return this;
        }

        public BooleanType getNotConsumedElement() {
            if (this.notConsumed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.notConsumed");
                }
                if (Configuration.doAutoCreate()) {
                    this.notConsumed = new BooleanType();
                }
            }
            return this.notConsumed;
        }

        public boolean hasNotConsumedElement() {
            return this.notConsumed != null && !this.notConsumed.isEmpty();
        }

        public boolean hasNotConsumed() {
            return this.notConsumed != null && !this.notConsumed.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setNotConsumedElement(BooleanType value) {
            this.notConsumed = value;
            return this;
        }

        public boolean getNotConsumed() {
            return this.notConsumed == null || this.notConsumed.isEmpty() ? false : (Boolean)this.notConsumed.getValue();
        }

        public NutritionIntakeConsumedItemComponent setNotConsumed(boolean value) {
            if (this.notConsumed == null) {
                this.notConsumed = new BooleanType();
            }
            this.notConsumed.setValue((Object)value);
            return this;
        }

        public CodeableConcept getNotConsumedReason() {
            if (this.notConsumedReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionIntakeConsumedItemComponent.notConsumedReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.notConsumedReason = new CodeableConcept();
                }
            }
            return this.notConsumedReason;
        }

        public boolean hasNotConsumedReason() {
            return this.notConsumedReason != null && !this.notConsumedReason.isEmpty();
        }

        public NutritionIntakeConsumedItemComponent setNotConsumedReason(CodeableConcept value) {
            this.notConsumedReason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Indicates what a category of item that was consumed: eg., food, fluid, enteral, etc.", 0, 1, this.type));
            children.add(new Property("nutritionProduct", "CodeableConcept", "Identifies the food or fluid product that was consumed. This is potentially a link to a resource representing the details of the food product (TBD) or a simple attribute carrying a code that identifies the food from a known list of foods.", 0, 1, this.nutritionProduct));
            children.add(new Property("schedule", "Timing", "Scheduled frequency of consumption.", 0, 1, this.schedule));
            children.add(new Property("amount", "SimpleQuantity", "Quantity of the specified food.", 0, 1, this.amount));
            children.add(new Property("rate", "SimpleQuantity", "Rate at which enteral feeding was administered.", 0, 1, this.rate));
            children.add(new Property("notConsumed", "boolean", "Indicator when a patient is in a setting where it is helpful to know if food was not consumed, such as it was refused, held (as in tube feedings), or otherwise not provided. If a consumption is being recorded from an app, such as MyFitnessPal, this indicator will likely not be used.", 0, 1, this.notConsumed));
            children.add(new Property("notConsumedReason", "CodeableConcept", "Document the reason the food or fluid was not consumed, such as refused, held, etc.", 0, 1, this.notConsumedReason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Indicates what a category of item that was consumed: eg., food, fluid, enteral, etc.", 0, 1, this.type);
                }
                case -1684132297: {
                    return new Property("nutritionProduct", "CodeableConcept", "Identifies the food or fluid product that was consumed. This is potentially a link to a resource representing the details of the food product (TBD) or a simple attribute carrying a code that identifies the food from a known list of foods.", 0, 1, this.nutritionProduct);
                }
                case -697920873: {
                    return new Property("schedule", "Timing", "Scheduled frequency of consumption.", 0, 1, this.schedule);
                }
                case -1413853096: {
                    return new Property("amount", "SimpleQuantity", "Quantity of the specified food.", 0, 1, this.amount);
                }
                case 3493088: {
                    return new Property("rate", "SimpleQuantity", "Rate at which enteral feeding was administered.", 0, 1, this.rate);
                }
                case -148762661: {
                    return new Property("notConsumed", "boolean", "Indicator when a patient is in a setting where it is helpful to know if food was not consumed, such as it was refused, held (as in tube feedings), or otherwise not provided. If a consumption is being recorded from an app, such as MyFitnessPal, this indicator will likely not be used.", 0, 1, this.notConsumed);
                }
                case -440795649: {
                    return new Property("notConsumedReason", "CodeableConcept", "Document the reason the food or fluid was not consumed, such as refused, held, etc.", 0, 1, this.notConsumedReason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1684132297: {
                    Base[] baseArray;
                    if (this.nutritionProduct == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.nutritionProduct;
                    }
                    return baseArray;
                }
                case -697920873: {
                    Base[] baseArray;
                    if (this.schedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.schedule;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.rate;
                    }
                    return baseArray;
                }
                case -148762661: {
                    Base[] baseArray;
                    if (this.notConsumed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.notConsumed;
                    }
                    return baseArray;
                }
                case -440795649: {
                    Base[] baseArray;
                    if (this.notConsumedReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.notConsumedReason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1684132297: {
                    this.nutritionProduct = this.castToCodeableConcept(value);
                    return value;
                }
                case -697920873: {
                    this.schedule = this.castToTiming(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToQuantity(value);
                    return value;
                }
                case 3493088: {
                    this.rate = this.castToQuantity(value);
                    return value;
                }
                case -148762661: {
                    this.notConsumed = this.castToBoolean(value);
                    return value;
                }
                case -440795649: {
                    this.notConsumedReason = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("nutritionProduct")) {
                this.nutritionProduct = this.castToCodeableConcept(value);
            } else if (name.equals("schedule")) {
                this.schedule = this.castToTiming(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToQuantity(value);
            } else if (name.equals("rate")) {
                this.rate = this.castToQuantity(value);
            } else if (name.equals("notConsumed")) {
                this.notConsumed = this.castToBoolean(value);
            } else if (name.equals("notConsumedReason")) {
                this.notConsumedReason = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1684132297: {
                    return this.getNutritionProduct();
                }
                case -697920873: {
                    return this.getSchedule();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 3493088: {
                    return this.getRate();
                }
                case -148762661: {
                    return this.getNotConsumedElement();
                }
                case -440795649: {
                    return this.getNotConsumedReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1684132297: {
                    return new String[]{"CodeableConcept"};
                }
                case -697920873: {
                    return new String[]{"Timing"};
                }
                case -1413853096: {
                    return new String[]{"SimpleQuantity"};
                }
                case 3493088: {
                    return new String[]{"SimpleQuantity"};
                }
                case -148762661: {
                    return new String[]{"boolean"};
                }
                case -440795649: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("nutritionProduct")) {
                this.nutritionProduct = new CodeableConcept();
                return this.nutritionProduct;
            }
            if (name.equals("schedule")) {
                this.schedule = new Timing();
                return this.schedule;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("rate")) {
                this.rate = new Quantity();
                return this.rate;
            }
            if (name.equals("notConsumed")) {
                throw new FHIRException("Cannot call addChild on a primitive type NutritionIntake.notConsumed");
            }
            if (name.equals("notConsumedReason")) {
                this.notConsumedReason = new CodeableConcept();
                return this.notConsumedReason;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionIntakeConsumedItemComponent copy() {
            NutritionIntakeConsumedItemComponent dst = new NutritionIntakeConsumedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionIntakeConsumedItemComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.nutritionProduct = this.nutritionProduct == null ? null : this.nutritionProduct.copy();
            dst.schedule = this.schedule == null ? null : this.schedule.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            dst.notConsumed = this.notConsumed == null ? null : this.notConsumed.copy();
            dst.notConsumedReason = this.notConsumedReason == null ? null : this.notConsumedReason.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeConsumedItemComponent)) {
                return false;
            }
            NutritionIntakeConsumedItemComponent o = (NutritionIntakeConsumedItemComponent)other_;
            return NutritionIntakeConsumedItemComponent.compareDeep(this.type, o.type, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.nutritionProduct, o.nutritionProduct, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.schedule, o.schedule, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.amount, o.amount, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.rate, o.rate, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.notConsumed, o.notConsumed, true) && NutritionIntakeConsumedItemComponent.compareDeep(this.notConsumedReason, o.notConsumedReason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionIntakeConsumedItemComponent)) {
                return false;
            }
            NutritionIntakeConsumedItemComponent o = (NutritionIntakeConsumedItemComponent)other_;
            return NutritionIntakeConsumedItemComponent.compareValues(this.notConsumed, o.notConsumed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.nutritionProduct, this.schedule, this.amount, this.rate, this.notConsumed, this.notConsumedReason});
        }

        @Override
        public String fhirType() {
            return "NutritionIntake.consumedItem";
        }
    }

    public static class NutritionIntakeStatusEnumFactory
    implements EnumFactory<NutritionIntakeStatus> {
        @Override
        public NutritionIntakeStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return NutritionIntakeStatus.ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return NutritionIntakeStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return NutritionIntakeStatus.ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return NutritionIntakeStatus.INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return NutritionIntakeStatus.STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return NutritionIntakeStatus.ONHOLD;
            }
            if ("unknown".equals(codeString)) {
                return NutritionIntakeStatus.UNKNOWN;
            }
            if ("not-taken".equals(codeString)) {
                return NutritionIntakeStatus.NOTTAKEN;
            }
            throw new IllegalArgumentException("Unknown NutritionIntakeStatus code '" + codeString + "'");
        }

        public Enumeration<NutritionIntakeStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<NutritionIntakeStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.ACTIVE);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.ENTEREDINERROR);
            }
            if ("intended".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.INTENDED);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.STOPPED);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.ONHOLD);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.UNKNOWN);
            }
            if ("not-taken".equals(codeString)) {
                return new Enumeration<NutritionIntakeStatus>(this, NutritionIntakeStatus.NOTTAKEN);
            }
            throw new FHIRException("Unknown NutritionIntakeStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(NutritionIntakeStatus code) {
            if (code == NutritionIntakeStatus.ACTIVE) {
                return "active";
            }
            if (code == NutritionIntakeStatus.COMPLETED) {
                return "completed";
            }
            if (code == NutritionIntakeStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == NutritionIntakeStatus.INTENDED) {
                return "intended";
            }
            if (code == NutritionIntakeStatus.STOPPED) {
                return "stopped";
            }
            if (code == NutritionIntakeStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == NutritionIntakeStatus.UNKNOWN) {
                return "unknown";
            }
            if (code == NutritionIntakeStatus.NOTTAKEN) {
                return "not-taken";
            }
            return "?";
        }

        @Override
        public String toSystem(NutritionIntakeStatus code) {
            return code.getSystem();
        }
    }

    public static enum NutritionIntakeStatus {
        ACTIVE,
        COMPLETED,
        ENTEREDINERROR,
        INTENDED,
        STOPPED,
        ONHOLD,
        UNKNOWN,
        NOTTAKEN,
        NULL;


        public static NutritionIntakeStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if ("not-taken".equals(codeString)) {
                return NOTTAKEN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown NutritionIntakeStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INTENDED: {
                    return "intended";
                }
                case STOPPED: {
                    return "stopped";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NOTTAKEN: {
                    return "not-taken";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
                case INTENDED: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
                case NOTTAKEN: {
                    return "http://hl7.org/fhir/CodeSystem/nutrition-intake-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The nutrition is still being taken.";
                }
                case COMPLETED: {
                    return "The nutrition is no longer being taken.";
                }
                case ENTEREDINERROR: {
                    return "Some of the actions that are implied by the nutrition usage may have occurred.  For example, the patient may have taken some of the nutrition.  Clinical decision support systems should take this status into account.";
                }
                case INTENDED: {
                    return "The nutrition may be taken at some time in the future.";
                }
                case STOPPED: {
                    return "Actions implied by the usage have been permanently halted, before all of them occurred. This should not be used if the statement was entered in error.";
                }
                case ONHOLD: {
                    return "Actions implied by the usage have been temporarily halted, but are expected to continue later. May also be called 'suspended'.";
                }
                case UNKNOWN: {
                    return "The state of the nutrition use is not currently known.";
                }
                case NOTTAKEN: {
                    return "The nutrition was not consumed by the patient";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INTENDED: {
                    return "Intended";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NOTTAKEN: {
                    return "Not Taken";
                }
            }
            return "?";
        }
    }
}

