/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ChargeItemDefinition", profile="http://hl7.org/fhir/StructureDefinition/ChargeItemDefinition")
@ChildOrder(names={"url", "identifier", "version", "title", "derivedFromUri", "partOf", "replaces", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "copyright", "approvalDate", "lastReviewDate", "effectivePeriod", "code", "instance", "applicability", "propertyGroup"})
public class ChargeItemDefinition
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the charge item definition", formalDefinition="A formal identifier that is used to identify this charge item definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="derivedFromUri", type={UriType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Underlying externally-defined charge item definition", formalDefinition="The URL pointing to an externally-defined charge item definition that is adhered to in whole or in part by this definition.")
    protected List<UriType> derivedFromUri;
    @Child(name="partOf", type={CanonicalType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A larger definition of which this particular definition is a component or step", formalDefinition="A larger definition of which this particular definition is a component or step.")
    protected List<CanonicalType> partOf;
    @Child(name="replaces", type={CanonicalType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Completed or terminated request(s) whose function is taken by this new request", formalDefinition="As new versions of a protocol or guideline are defined, allows identification of what versions are replaced by a new instance.")
    protected List<CanonicalType> replaces;
    @Child(name="copyright", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the charge item definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the charge item definition.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the charge item definition was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the charge item definition was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the charge item definition is expected to be used", formalDefinition="The period during which the charge item definition content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="code", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Billing codes or product types this definition applies to", formalDefinition="The defined billing details in this resource pertain to the given billing code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/chargeitem-billingcodes")
    protected CodeableConcept code;
    @Child(name="instance", type={Medication.class, Substance.class, Device.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instances this definition applies to", formalDefinition="The defined billing details in this resource pertain to the given product instance(s).")
    protected List<Reference> instance;
    @Child(name="applicability", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Whether or not the billing code is applicable", formalDefinition="Expressions that describe applicability criteria for the billing code.")
    protected List<ChargeItemDefinitionApplicabilityComponent> applicability;
    @Child(name="propertyGroup", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Group of properties which are applicable under the same conditions", formalDefinition="Group of properties which are applicable under the same conditions. If no applicability rules are established for the group, then all properties always apply.")
    protected List<ChargeItemDefinitionPropertyGroupComponent> propertyGroup;
    private static final long serialVersionUID = -699176936L;
    @SearchParamDefinition(name="date", path="ChargeItemDefinition.date", description="The charge item definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ChargeItemDefinition.identifier", description="External identifier for the charge item definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="context-type-value", path="ChargeItemDefinition.useContext", description="A use context type and value assigned to the charge item definition", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="ChargeItemDefinition.jurisdiction", description="Intended jurisdiction for the charge item definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="ChargeItemDefinition.description", description="The description of the charge item definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="ChargeItemDefinition.useContext.code", description="A type of use context assigned to the charge item definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="title", path="ChargeItemDefinition.title", description="The human-friendly name of the charge item definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="ChargeItemDefinition.version", description="The business version of the charge item definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ChargeItemDefinition.url", description="The uri that identifies the charge item definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(ChargeItemDefinition.useContext.value as Quantity) | (ChargeItemDefinition.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the charge item definition", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="effective", path="ChargeItemDefinition.effectivePeriod", description="The time during which the charge item definition is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="context", path="(ChargeItemDefinition.useContext.value as CodeableConcept)", description="A use context assigned to the charge item definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="ChargeItemDefinition.publisher", description="Name of the publisher of the charge item definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="context-type-quantity", path="ChargeItemDefinition.useContext", description="A use context type and quantity- or range-based value assigned to the charge item definition", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="ChargeItemDefinition.status", description="The current status of the charge item definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ChargeItemDefinition() {
    }

    public ChargeItemDefinition(UriType url, Enumeration<Enumerations.PublicationStatus> status) {
        this.url = url;
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ChargeItemDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ChargeItemDefinition setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ChargeItemDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ChargeItemDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ChargeItemDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ChargeItemDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ChargeItemDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ChargeItemDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<UriType> getDerivedFromUri() {
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        return this.derivedFromUri;
    }

    public ChargeItemDefinition setDerivedFromUri(List<UriType> theDerivedFromUri) {
        this.derivedFromUri = theDerivedFromUri;
        return this;
    }

    public boolean hasDerivedFromUri() {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType item : this.derivedFromUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDerivedFromUriElement() {
        UriType t = new UriType();
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return t;
    }

    public ChargeItemDefinition addDerivedFromUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return this;
    }

    public boolean hasDerivedFromUri(String value) {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType v : this.derivedFromUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<CanonicalType>();
        }
        return this.partOf;
    }

    public ChargeItemDefinition setPartOf(List<CanonicalType> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (CanonicalType item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addPartOfElement() {
        CanonicalType t = new CanonicalType();
        if (this.partOf == null) {
            this.partOf = new ArrayList<CanonicalType>();
        }
        this.partOf.add(t);
        return t;
    }

    public ChargeItemDefinition addPartOf(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.partOf == null) {
            this.partOf = new ArrayList<CanonicalType>();
        }
        this.partOf.add(t);
        return this;
    }

    public boolean hasPartOf(String value) {
        if (this.partOf == null) {
            return false;
        }
        for (CanonicalType v : this.partOf) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        return this.replaces;
    }

    public ChargeItemDefinition setReplaces(List<CanonicalType> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (CanonicalType item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addReplacesElement() {
        CanonicalType t = new CanonicalType();
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        this.replaces.add(t);
        return t;
    }

    public ChargeItemDefinition addReplaces(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.replaces == null) {
            this.replaces = new ArrayList<CanonicalType>();
        }
        this.replaces.add(t);
        return this;
    }

    public boolean hasReplaces(String value) {
        if (this.replaces == null) {
            return false;
        }
        for (CanonicalType v : this.replaces) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ChargeItemDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ChargeItemDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ChargeItemDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ChargeItemDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ChargeItemDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ChargeItemDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ChargeItemDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ChargeItemDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ChargeItemDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ChargeItemDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ChargeItemDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ChargeItemDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ChargeItemDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ChargeItemDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ChargeItemDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ChargeItemDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ChargeItemDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ChargeItemDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public ChargeItemDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public ChargeItemDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public ChargeItemDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public ChargeItemDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public ChargeItemDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItemDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ChargeItemDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<Reference> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<Reference>();
        }
        return this.instance;
    }

    public ChargeItemDefinition setInstance(List<Reference> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (Reference item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInstance() {
        Reference t = new Reference();
        if (this.instance == null) {
            this.instance = new ArrayList<Reference>();
        }
        this.instance.add(t);
        return t;
    }

    public ChargeItemDefinition addInstance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<Reference>();
        }
        this.instance.add(t);
        return this;
    }

    public Reference getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public List<ChargeItemDefinitionApplicabilityComponent> getApplicability() {
        if (this.applicability == null) {
            this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
        }
        return this.applicability;
    }

    public ChargeItemDefinition setApplicability(List<ChargeItemDefinitionApplicabilityComponent> theApplicability) {
        this.applicability = theApplicability;
        return this;
    }

    public boolean hasApplicability() {
        if (this.applicability == null) {
            return false;
        }
        for (ChargeItemDefinitionApplicabilityComponent item : this.applicability) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChargeItemDefinitionApplicabilityComponent addApplicability() {
        ChargeItemDefinitionApplicabilityComponent t = new ChargeItemDefinitionApplicabilityComponent();
        if (this.applicability == null) {
            this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
        }
        this.applicability.add(t);
        return t;
    }

    public ChargeItemDefinition addApplicability(ChargeItemDefinitionApplicabilityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.applicability == null) {
            this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
        }
        this.applicability.add(t);
        return this;
    }

    public ChargeItemDefinitionApplicabilityComponent getApplicabilityFirstRep() {
        if (this.getApplicability().isEmpty()) {
            this.addApplicability();
        }
        return this.getApplicability().get(0);
    }

    public List<ChargeItemDefinitionPropertyGroupComponent> getPropertyGroup() {
        if (this.propertyGroup == null) {
            this.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
        }
        return this.propertyGroup;
    }

    public ChargeItemDefinition setPropertyGroup(List<ChargeItemDefinitionPropertyGroupComponent> thePropertyGroup) {
        this.propertyGroup = thePropertyGroup;
        return this;
    }

    public boolean hasPropertyGroup() {
        if (this.propertyGroup == null) {
            return false;
        }
        for (ChargeItemDefinitionPropertyGroupComponent item : this.propertyGroup) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChargeItemDefinitionPropertyGroupComponent addPropertyGroup() {
        ChargeItemDefinitionPropertyGroupComponent t = new ChargeItemDefinitionPropertyGroupComponent();
        if (this.propertyGroup == null) {
            this.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
        }
        this.propertyGroup.add(t);
        return t;
    }

    public ChargeItemDefinition addPropertyGroup(ChargeItemDefinitionPropertyGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.propertyGroup == null) {
            this.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
        }
        this.propertyGroup.add(t);
        return this;
    }

    public ChargeItemDefinitionPropertyGroupComponent getPropertyGroupFirstRep() {
        if (this.getPropertyGroup().isEmpty()) {
            this.addPropertyGroup();
        }
        return this.getPropertyGroup().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this charge item definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this charge item definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the charge item definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this charge item definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the charge item definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the charge item definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the charge item definition.", 0, 1, this.title));
        children.add(new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined charge item definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri));
        children.add(new Property("partOf", "canonical(ChargeItemDefinition)", "A larger definition of which this particular definition is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property("replaces", "canonical(ChargeItemDefinition)", "As new versions of a protocol or guideline are defined, allows identification of what versions are replaced by a new instance.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property(SP_STATUS, "code", "The current state of the ChargeItemDefinition.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this charge item definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the charge item definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the charge item definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the charge item definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the charge item definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate charge item definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the charge item definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the charge item definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the charge item definition.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the charge item definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("code", "CodeableConcept", "The defined billing details in this resource pertain to the given billing code.", 0, 1, this.code));
        children.add(new Property("instance", "Reference(Medication|Substance|Device)", "The defined billing details in this resource pertain to the given product instance(s).", 0, Integer.MAX_VALUE, this.instance));
        children.add(new Property("applicability", "", "Expressions that describe applicability criteria for the billing code.", 0, Integer.MAX_VALUE, this.applicability));
        children.add(new Property("propertyGroup", "", "Group of properties which are applicable under the same conditions. If no applicability rules are established for the group, then all properties always apply.", 0, Integer.MAX_VALUE, this.propertyGroup));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this charge item definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this charge item definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the charge item definition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this charge item definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the charge item definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the charge item definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the charge item definition.", 0, 1, this.title);
            }
            case -1076333435: {
                return new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined charge item definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri);
            }
            case -995410646: {
                return new Property("partOf", "canonical(ChargeItemDefinition)", "A larger definition of which this particular definition is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -430332865: {
                return new Property("replaces", "canonical(ChargeItemDefinition)", "As new versions of a protocol or guideline are defined, allows identification of what versions are replaced by a new instance.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the ChargeItemDefinition.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this charge item definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the charge item definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the charge item definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the charge item definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the charge item definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate charge item definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the charge item definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the charge item definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the charge item definition.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the charge item definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "The defined billing details in this resource pertain to the given billing code.", 0, 1, this.code);
            }
            case 555127957: {
                return new Property("instance", "Reference(Medication|Substance|Device)", "The defined billing details in this resource pertain to the given product instance(s).", 0, Integer.MAX_VALUE, this.instance);
            }
            case -1526770491: {
                return new Property("applicability", "", "Expressions that describe applicability criteria for the billing code.", 0, Integer.MAX_VALUE, this.applicability);
            }
            case -1041594966: {
                return new Property("propertyGroup", "", "Group of properties which are applicable under the same conditions. If no applicability rules are established for the group, then all properties always apply.", 0, Integer.MAX_VALUE, this.propertyGroup);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case -1076333435: {
                return this.derivedFromUri == null ? new Base[]{} : this.derivedFromUri.toArray(new Base[this.derivedFromUri.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.code;
                }
                return baseArray;
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
            case -1526770491: {
                return this.applicability == null ? new Base[]{} : this.applicability.toArray(new Base[this.applicability.size()]);
            }
            case -1041594966: {
                return this.propertyGroup == null ? new Base[]{} : this.propertyGroup.toArray(new Base[this.propertyGroup.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -1076333435: {
                this.getDerivedFromUri().add(this.castToUri(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToCanonical(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(this.castToCanonical(value));
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case 555127957: {
                this.getInstance().add(this.castToReference(value));
                return value;
            }
            case -1526770491: {
                this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)((Object)value));
                return value;
            }
            case -1041594966: {
                this.getPropertyGroup().add((ChargeItemDefinitionPropertyGroupComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("derivedFromUri")) {
            this.getDerivedFromUri().add(this.castToUri(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToCanonical(value));
        } else if (name.equals("replaces")) {
            this.getReplaces().add(this.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("instance")) {
            this.getInstance().add(this.castToReference(value));
        } else if (name.equals("applicability")) {
            this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)((Object)value));
        } else if (name.equals("propertyGroup")) {
            this.getPropertyGroup().add((ChargeItemDefinitionPropertyGroupComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -1076333435: {
                return this.addDerivedFromUriElement();
            }
            case -995410646: {
                return this.addPartOfElement();
            }
            case -430332865: {
                return this.addReplacesElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 3059181: {
                return this.getCode();
            }
            case 555127957: {
                return this.addInstance();
            }
            case -1526770491: {
                return this.addApplicability();
            }
            case -1041594966: {
                return this.addPropertyGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -1076333435: {
                return new String[]{"uri"};
            }
            case -995410646: {
                return new String[]{"canonical"};
            }
            case -430332865: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 555127957: {
                return new String[]{"Reference"};
            }
            case -1526770491: {
                return new String[0];
            }
            case -1041594966: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.version");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.title");
        }
        if (name.equals("derivedFromUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.derivedFromUri");
        }
        if (name.equals("partOf")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.partOf");
        }
        if (name.equals("replaces")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.replaces");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("applicability")) {
            return this.addApplicability();
        }
        if (name.equals("propertyGroup")) {
            return this.addPropertyGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ChargeItemDefinition";
    }

    @Override
    public ChargeItemDefinition copy() {
        ChargeItemDefinition dst = new ChargeItemDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ChargeItemDefinition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFromUri != null) {
            dst.derivedFromUri = new ArrayList<UriType>();
            for (UriType uriType2 : this.derivedFromUri) {
                dst.derivedFromUri.add(uriType2.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.partOf) {
                dst.partOf.add(canonicalType.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.replaces) {
                dst.replaces.add(canonicalType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
        if (this.instance != null) {
            dst.instance = new ArrayList<Reference>();
            for (Reference reference : this.instance) {
                dst.instance.add(reference.copy());
            }
        }
        if (this.applicability != null) {
            dst.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            for (ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : this.applicability) {
                dst.applicability.add(chargeItemDefinitionApplicabilityComponent.copy());
            }
        }
        if (this.propertyGroup != null) {
            dst.propertyGroup = new ArrayList<ChargeItemDefinitionPropertyGroupComponent>();
            for (ChargeItemDefinitionPropertyGroupComponent chargeItemDefinitionPropertyGroupComponent : this.propertyGroup) {
                dst.propertyGroup.add(chargeItemDefinitionPropertyGroupComponent.copy());
            }
        }
    }

    protected ChargeItemDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItemDefinition)) {
            return false;
        }
        ChargeItemDefinition o = (ChargeItemDefinition)other_;
        return ChargeItemDefinition.compareDeep(this.identifier, o.identifier, true) && ChargeItemDefinition.compareDeep(this.derivedFromUri, o.derivedFromUri, true) && ChargeItemDefinition.compareDeep(this.partOf, o.partOf, true) && ChargeItemDefinition.compareDeep(this.replaces, o.replaces, true) && ChargeItemDefinition.compareDeep(this.copyright, o.copyright, true) && ChargeItemDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && ChargeItemDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ChargeItemDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ChargeItemDefinition.compareDeep(this.code, o.code, true) && ChargeItemDefinition.compareDeep(this.instance, o.instance, true) && ChargeItemDefinition.compareDeep(this.applicability, o.applicability, true) && ChargeItemDefinition.compareDeep(this.propertyGroup, o.propertyGroup, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItemDefinition)) {
            return false;
        }
        ChargeItemDefinition o = (ChargeItemDefinition)other_;
        return ChargeItemDefinition.compareValues(this.derivedFromUri, o.derivedFromUri, true) && ChargeItemDefinition.compareValues(this.copyright, o.copyright, true) && ChargeItemDefinition.compareValues(this.approvalDate, o.approvalDate, true) && ChargeItemDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.derivedFromUri, this.partOf, this.replaces, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.code, this.instance, this.applicability, this.propertyGroup});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ChargeItemDefinition;
    }

    @Block
    public static class ChargeItemDefinitionPropertyGroupPriceComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="base | surcharge | deduction | discount | tax | informational", formalDefinition="This code identifies the type of the component.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/invoice-priceComponentType")
        protected Enumeration<ChargeItemDefinitionPriceComponentType> type;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code identifying the specific component", formalDefinition="A code that identifies the component. Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.")
        protected CodeableConcept code;
        @Child(name="factor", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Factor used for calculating this component", formalDefinition="The factor that has been applied on the base price for calculating this component.")
        protected DecimalType factor;
        @Child(name="amount", type={Money.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount associated with this component", formalDefinition="The amount calculated for this component.")
        protected Money amount;
        private static final long serialVersionUID = -841451335L;

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent() {
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent(Enumeration<ChargeItemDefinitionPriceComponentType> type) {
            this.type = type;
        }

        public Enumeration<ChargeItemDefinitionPriceComponentType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionPropertyGroupPriceComponentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ChargeItemDefinitionPriceComponentType>(new ChargeItemDefinitionPriceComponentTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setTypeElement(Enumeration<ChargeItemDefinitionPriceComponentType> value) {
            this.type = value;
            return this;
        }

        public ChargeItemDefinitionPriceComponentType getType() {
            return this.type == null ? null : (ChargeItemDefinitionPriceComponentType)((Object)this.type.getValue());
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setType(ChargeItemDefinitionPriceComponentType value) {
            if (this.type == null) {
                this.type = new Enumeration<ChargeItemDefinitionPriceComponentType>(new ChargeItemDefinitionPriceComponentTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionPropertyGroupPriceComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionPropertyGroupPriceComponentComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionPropertyGroupPriceComponentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "This code identifies the type of the component.", 0, 1, this.type));
            children.add(new Property("code", "CodeableConcept", "A code that identifies the component. Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.", 0, 1, this.code));
            children.add(new Property("factor", "decimal", "The factor that has been applied on the base price for calculating this component.", 0, 1, this.factor));
            children.add(new Property("amount", "Money", "The amount calculated for this component.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "This code identifies the type of the component.", 0, 1, this.type);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that identifies the component. Codes may be used to differentiate between kinds of taxes, surcharges, discounts etc.", 0, 1, this.code);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "The factor that has been applied on the base price for calculating this component.", 0, 1, this.factor);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "The amount calculated for this component.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.factor;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ChargeItemDefinitionPriceComponentTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ChargeItemDefinitionPriceComponentTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.type");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.factor");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public ChargeItemDefinitionPropertyGroupPriceComponentComponent copy() {
            ChargeItemDefinitionPropertyGroupPriceComponentComponent dst = new ChargeItemDefinitionPropertyGroupPriceComponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ChargeItemDefinitionPropertyGroupPriceComponentComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionPropertyGroupPriceComponentComponent)) {
                return false;
            }
            ChargeItemDefinitionPropertyGroupPriceComponentComponent o = (ChargeItemDefinitionPropertyGroupPriceComponentComponent)other_;
            return ChargeItemDefinitionPropertyGroupPriceComponentComponent.compareDeep(this.type, o.type, true) && ChargeItemDefinitionPropertyGroupPriceComponentComponent.compareDeep(this.code, o.code, true) && ChargeItemDefinitionPropertyGroupPriceComponentComponent.compareDeep(this.factor, o.factor, true) && ChargeItemDefinitionPropertyGroupPriceComponentComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionPropertyGroupPriceComponentComponent)) {
                return false;
            }
            ChargeItemDefinitionPropertyGroupPriceComponentComponent o = (ChargeItemDefinitionPropertyGroupPriceComponentComponent)other_;
            return ChargeItemDefinitionPropertyGroupPriceComponentComponent.compareValues(this.type, o.type, true) && ChargeItemDefinitionPropertyGroupPriceComponentComponent.compareValues(this.factor, o.factor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.code, this.factor, this.amount});
        }

        @Override
        public String fhirType() {
            return "ChargeItemDefinition.propertyGroup.priceComponent";
        }
    }

    @Block
    public static class ChargeItemDefinitionPropertyGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="applicability", type={ChargeItemDefinitionApplicabilityComponent.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Conditions under which the priceComponent is applicable", formalDefinition="Expressions that describe applicability criteria for the priceComponent.")
        protected List<ChargeItemDefinitionApplicabilityComponent> applicability;
        @Child(name="priceComponent", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Components of total line item price", formalDefinition="The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.")
        protected List<ChargeItemDefinitionPropertyGroupPriceComponentComponent> priceComponent;
        private static final long serialVersionUID = 1723436176L;

        public List<ChargeItemDefinitionApplicabilityComponent> getApplicability() {
            if (this.applicability == null) {
                this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            }
            return this.applicability;
        }

        public ChargeItemDefinitionPropertyGroupComponent setApplicability(List<ChargeItemDefinitionApplicabilityComponent> theApplicability) {
            this.applicability = theApplicability;
            return this;
        }

        public boolean hasApplicability() {
            if (this.applicability == null) {
                return false;
            }
            for (ChargeItemDefinitionApplicabilityComponent item : this.applicability) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ChargeItemDefinitionApplicabilityComponent addApplicability() {
            ChargeItemDefinitionApplicabilityComponent t = new ChargeItemDefinitionApplicabilityComponent();
            if (this.applicability == null) {
                this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            }
            this.applicability.add(t);
            return t;
        }

        public ChargeItemDefinitionPropertyGroupComponent addApplicability(ChargeItemDefinitionApplicabilityComponent t) {
            if (t == null) {
                return this;
            }
            if (this.applicability == null) {
                this.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
            }
            this.applicability.add(t);
            return this;
        }

        public ChargeItemDefinitionApplicabilityComponent getApplicabilityFirstRep() {
            if (this.getApplicability().isEmpty()) {
                this.addApplicability();
            }
            return this.getApplicability().get(0);
        }

        public List<ChargeItemDefinitionPropertyGroupPriceComponentComponent> getPriceComponent() {
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<ChargeItemDefinitionPropertyGroupPriceComponentComponent>();
            }
            return this.priceComponent;
        }

        public ChargeItemDefinitionPropertyGroupComponent setPriceComponent(List<ChargeItemDefinitionPropertyGroupPriceComponentComponent> thePriceComponent) {
            this.priceComponent = thePriceComponent;
            return this;
        }

        public boolean hasPriceComponent() {
            if (this.priceComponent == null) {
                return false;
            }
            for (ChargeItemDefinitionPropertyGroupPriceComponentComponent item : this.priceComponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent addPriceComponent() {
            ChargeItemDefinitionPropertyGroupPriceComponentComponent t = new ChargeItemDefinitionPropertyGroupPriceComponentComponent();
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<ChargeItemDefinitionPropertyGroupPriceComponentComponent>();
            }
            this.priceComponent.add(t);
            return t;
        }

        public ChargeItemDefinitionPropertyGroupComponent addPriceComponent(ChargeItemDefinitionPropertyGroupPriceComponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<ChargeItemDefinitionPropertyGroupPriceComponentComponent>();
            }
            this.priceComponent.add(t);
            return this;
        }

        public ChargeItemDefinitionPropertyGroupPriceComponentComponent getPriceComponentFirstRep() {
            if (this.getPriceComponent().isEmpty()) {
                this.addPriceComponent();
            }
            return this.getPriceComponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("applicability", "@ChargeItemDefinition.applicability", "Expressions that describe applicability criteria for the priceComponent.", 0, Integer.MAX_VALUE, this.applicability));
            children.add(new Property("priceComponent", "", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1526770491: {
                    return new Property("applicability", "@ChargeItemDefinition.applicability", "Expressions that describe applicability criteria for the priceComponent.", 0, Integer.MAX_VALUE, this.applicability);
                }
                case 1219095988: {
                    return new Property("priceComponent", "", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    return this.applicability == null ? new Base[]{} : this.applicability.toArray(new Base[this.applicability.size()]);
                }
                case 1219095988: {
                    return this.priceComponent == null ? new Base[]{} : this.priceComponent.toArray(new Base[this.priceComponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)value);
                    return value;
                }
                case 1219095988: {
                    this.getPriceComponent().add((ChargeItemDefinitionPropertyGroupPriceComponentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("applicability")) {
                this.getApplicability().add((ChargeItemDefinitionApplicabilityComponent)value);
            } else if (name.equals("priceComponent")) {
                this.getPriceComponent().add((ChargeItemDefinitionPropertyGroupPriceComponentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    return this.addApplicability();
                }
                case 1219095988: {
                    return this.addPriceComponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1526770491: {
                    return new String[]{"@ChargeItemDefinition.applicability"};
                }
                case 1219095988: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("applicability")) {
                return this.addApplicability();
            }
            if (name.equals("priceComponent")) {
                return this.addPriceComponent();
            }
            return super.addChild(name);
        }

        @Override
        public ChargeItemDefinitionPropertyGroupComponent copy() {
            ChargeItemDefinitionPropertyGroupComponent dst = new ChargeItemDefinitionPropertyGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ChargeItemDefinitionPropertyGroupComponent dst) {
            super.copyValues(dst);
            if (this.applicability != null) {
                dst.applicability = new ArrayList<ChargeItemDefinitionApplicabilityComponent>();
                for (ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : this.applicability) {
                    dst.applicability.add(chargeItemDefinitionApplicabilityComponent.copy());
                }
            }
            if (this.priceComponent != null) {
                dst.priceComponent = new ArrayList<ChargeItemDefinitionPropertyGroupPriceComponentComponent>();
                for (ChargeItemDefinitionPropertyGroupPriceComponentComponent chargeItemDefinitionPropertyGroupPriceComponentComponent : this.priceComponent) {
                    dst.priceComponent.add(chargeItemDefinitionPropertyGroupPriceComponentComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionPropertyGroupComponent)) {
                return false;
            }
            ChargeItemDefinitionPropertyGroupComponent o = (ChargeItemDefinitionPropertyGroupComponent)other_;
            return ChargeItemDefinitionPropertyGroupComponent.compareDeep(this.applicability, o.applicability, true) && ChargeItemDefinitionPropertyGroupComponent.compareDeep(this.priceComponent, o.priceComponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionPropertyGroupComponent)) {
                return false;
            }
            ChargeItemDefinitionPropertyGroupComponent o = (ChargeItemDefinitionPropertyGroupComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.applicability, this.priceComponent});
        }

        @Override
        public String fhirType() {
            return "ChargeItemDefinition.propertyGroup";
        }
    }

    @Block
    public static class ChargeItemDefinitionApplicabilityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the condition", formalDefinition="A brief, natural language description of the condition that effectively communicates the intended semantics.")
        protected StringType description;
        @Child(name="language", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language of the expression", formalDefinition="The media type of the language for the expression, e.g. \"text/cql\" for Clinical Query Language expressions or \"text/fhirpath\" for FHIRPath expressions.")
        protected StringType language;
        @Child(name="expression", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether the condition is satisfied. When using FHIRPath expressions, the %context environment variable must be replaced at runtime with the ChargeItem resource to which this definition is applied.")
        protected StringType expression;
        private static final long serialVersionUID = 1354288281L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionApplicabilityComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ChargeItemDefinitionApplicabilityComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ChargeItemDefinitionApplicabilityComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionApplicabilityComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new StringType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ChargeItemDefinitionApplicabilityComponent setLanguageElement(StringType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ChargeItemDefinitionApplicabilityComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new StringType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemDefinitionApplicabilityComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public ChargeItemDefinitionApplicabilityComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public ChargeItemDefinitionApplicabilityComponent setExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ChargeItemDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description));
            children.add(new Property("language", "string", "The media type of the language for the expression, e.g. \"text/cql\" for Clinical Query Language expressions or \"text/fhirpath\" for FHIRPath expressions.", 0, 1, this.language));
            children.add(new Property("expression", "string", "An expression that returns true or false, indicating whether the condition is satisfied. When using FHIRPath expressions, the %context environment variable must be replaced at runtime with the ChargeItem resource to which this definition is applied.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(ChargeItemDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description);
                }
                case -1613589672: {
                    return new Property("language", "string", "The media type of the language for the expression, e.g. \"text/cql\" for Clinical Query Language expressions or \"text/fhirpath\" for FHIRPath expressions.", 0, 1, this.language);
                }
                case -1795452264: {
                    return new Property("expression", "string", "An expression that returns true or false, indicating whether the condition is satisfied. When using FHIRPath expressions, the %context environment variable must be replaced at runtime with the ChargeItem resource to which this definition is applied.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ChargeItemDefinition.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ChargeItemDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.description");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.language");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type ChargeItemDefinition.expression");
            }
            return super.addChild(name);
        }

        @Override
        public ChargeItemDefinitionApplicabilityComponent copy() {
            ChargeItemDefinitionApplicabilityComponent dst = new ChargeItemDefinitionApplicabilityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ChargeItemDefinitionApplicabilityComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionApplicabilityComponent)) {
                return false;
            }
            ChargeItemDefinitionApplicabilityComponent o = (ChargeItemDefinitionApplicabilityComponent)other_;
            return ChargeItemDefinitionApplicabilityComponent.compareDeep(this.description, o.description, true) && ChargeItemDefinitionApplicabilityComponent.compareDeep(this.language, o.language, true) && ChargeItemDefinitionApplicabilityComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemDefinitionApplicabilityComponent)) {
                return false;
            }
            ChargeItemDefinitionApplicabilityComponent o = (ChargeItemDefinitionApplicabilityComponent)other_;
            return ChargeItemDefinitionApplicabilityComponent.compareValues(this.description, o.description, true) && ChargeItemDefinitionApplicabilityComponent.compareValues(this.language, o.language, true) && ChargeItemDefinitionApplicabilityComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.language, this.expression});
        }

        @Override
        public String fhirType() {
            return "ChargeItemDefinition.applicability";
        }
    }

    public static class ChargeItemDefinitionPriceComponentTypeEnumFactory
    implements EnumFactory<ChargeItemDefinitionPriceComponentType> {
        @Override
        public ChargeItemDefinitionPriceComponentType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("base".equals(codeString)) {
                return ChargeItemDefinitionPriceComponentType.BASE;
            }
            if ("surcharge".equals(codeString)) {
                return ChargeItemDefinitionPriceComponentType.SURCHARGE;
            }
            if ("deduction".equals(codeString)) {
                return ChargeItemDefinitionPriceComponentType.DEDUCTION;
            }
            if ("discount".equals(codeString)) {
                return ChargeItemDefinitionPriceComponentType.DISCOUNT;
            }
            if ("tax".equals(codeString)) {
                return ChargeItemDefinitionPriceComponentType.TAX;
            }
            if ("informational".equals(codeString)) {
                return ChargeItemDefinitionPriceComponentType.INFORMATIONAL;
            }
            throw new IllegalArgumentException("Unknown ChargeItemDefinitionPriceComponentType code '" + codeString + "'");
        }

        public Enumeration<ChargeItemDefinitionPriceComponentType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ChargeItemDefinitionPriceComponentType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("base".equals(codeString)) {
                return new Enumeration<ChargeItemDefinitionPriceComponentType>(this, ChargeItemDefinitionPriceComponentType.BASE);
            }
            if ("surcharge".equals(codeString)) {
                return new Enumeration<ChargeItemDefinitionPriceComponentType>(this, ChargeItemDefinitionPriceComponentType.SURCHARGE);
            }
            if ("deduction".equals(codeString)) {
                return new Enumeration<ChargeItemDefinitionPriceComponentType>(this, ChargeItemDefinitionPriceComponentType.DEDUCTION);
            }
            if ("discount".equals(codeString)) {
                return new Enumeration<ChargeItemDefinitionPriceComponentType>(this, ChargeItemDefinitionPriceComponentType.DISCOUNT);
            }
            if ("tax".equals(codeString)) {
                return new Enumeration<ChargeItemDefinitionPriceComponentType>(this, ChargeItemDefinitionPriceComponentType.TAX);
            }
            if ("informational".equals(codeString)) {
                return new Enumeration<ChargeItemDefinitionPriceComponentType>(this, ChargeItemDefinitionPriceComponentType.INFORMATIONAL);
            }
            throw new FHIRException("Unknown ChargeItemDefinitionPriceComponentType code '" + codeString + "'");
        }

        @Override
        public String toCode(ChargeItemDefinitionPriceComponentType code) {
            if (code == ChargeItemDefinitionPriceComponentType.BASE) {
                return "base";
            }
            if (code == ChargeItemDefinitionPriceComponentType.SURCHARGE) {
                return "surcharge";
            }
            if (code == ChargeItemDefinitionPriceComponentType.DEDUCTION) {
                return "deduction";
            }
            if (code == ChargeItemDefinitionPriceComponentType.DISCOUNT) {
                return "discount";
            }
            if (code == ChargeItemDefinitionPriceComponentType.TAX) {
                return "tax";
            }
            if (code == ChargeItemDefinitionPriceComponentType.INFORMATIONAL) {
                return "informational";
            }
            return "?";
        }

        @Override
        public String toSystem(ChargeItemDefinitionPriceComponentType code) {
            return code.getSystem();
        }
    }

    public static enum ChargeItemDefinitionPriceComponentType {
        BASE,
        SURCHARGE,
        DEDUCTION,
        DISCOUNT,
        TAX,
        INFORMATIONAL,
        NULL;


        public static ChargeItemDefinitionPriceComponentType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("base".equals(codeString)) {
                return BASE;
            }
            if ("surcharge".equals(codeString)) {
                return SURCHARGE;
            }
            if ("deduction".equals(codeString)) {
                return DEDUCTION;
            }
            if ("discount".equals(codeString)) {
                return DISCOUNT;
            }
            if ("tax".equals(codeString)) {
                return TAX;
            }
            if ("informational".equals(codeString)) {
                return INFORMATIONAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ChargeItemDefinitionPriceComponentType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BASE: {
                    return "base";
                }
                case SURCHARGE: {
                    return "surcharge";
                }
                case DEDUCTION: {
                    return "deduction";
                }
                case DISCOUNT: {
                    return "discount";
                }
                case TAX: {
                    return "tax";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BASE: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case SURCHARGE: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case DEDUCTION: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case DISCOUNT: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case TAX: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
                case INFORMATIONAL: {
                    return "http://hl7.org/fhir/invoice-priceComponentType";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BASE: {
                    return "the amount is the base price used for calculating the total price before applying surcharges, discount or taxes.";
                }
                case SURCHARGE: {
                    return "the amount is a surcharge applied on the base price.";
                }
                case DEDUCTION: {
                    return "the amount is a deduction applied on the base price.";
                }
                case DISCOUNT: {
                    return "the amount is a discount applied on the base price.";
                }
                case TAX: {
                    return "the amount is the tax component of the total price.";
                }
                case INFORMATIONAL: {
                    return "the amount is of informational character, it has not been applied in the calculation of the total price.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BASE: {
                    return "base price";
                }
                case SURCHARGE: {
                    return "surcharge";
                }
                case DEDUCTION: {
                    return "deduction";
                }
                case DISCOUNT: {
                    return "discount";
                }
                case TAX: {
                    return "tax";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
            }
            return "?";
        }
    }
}

