/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.ICoding;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OrderedDistribution;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Population;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.ProdCharacteristic;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.SimpleQuantity;
import org.hl7.fhir.r5.model.Statistic;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubstanceAmount;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.XhtmlType;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public abstract class Base
implements Serializable,
IBase,
IElement {
    private Map<String, Object> userData;
    private List<String> formatCommentsPre;
    private List<String> formatCommentsPost;

    public Object getUserData(String name) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(name);
    }

    public void setUserData(String name, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public void clearUserData(String name) {
        if (this.userData != null) {
            this.userData.remove(name);
        }
    }

    public void setUserDataINN(String name, Object value) {
        if (value == null) {
            return;
        }
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public boolean hasUserData(String name) {
        if (this.userData == null) {
            return false;
        }
        return this.userData.containsKey(name);
    }

    public String getUserString(String name) {
        Object ud = this.getUserData(name);
        if (ud == null) {
            return null;
        }
        if (ud instanceof String) {
            return (String)ud;
        }
        return ud.toString();
    }

    public int getUserInt(String name) {
        if (!this.hasUserData(name)) {
            return 0;
        }
        return (Integer)this.getUserData(name);
    }

    public boolean hasFormatComment() {
        return this.formatCommentsPre != null && !this.formatCommentsPre.isEmpty() || this.formatCommentsPost != null && !this.formatCommentsPost.isEmpty();
    }

    public List<String> getFormatCommentsPre() {
        if (this.formatCommentsPre == null) {
            this.formatCommentsPre = new ArrayList<String>();
        }
        return this.formatCommentsPre;
    }

    public List<String> getFormatCommentsPost() {
        if (this.formatCommentsPost == null) {
            this.formatCommentsPost = new ArrayList<String>();
        }
        return this.formatCommentsPost;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isBooleanPrimitive() {
        return false;
    }

    public boolean hasPrimitiveValue() {
        return this.isPrimitive();
    }

    public String primitiveValue() {
        return null;
    }

    public boolean isDateTime() {
        return false;
    }

    public BaseDateTimeType dateTimeValue() {
        return null;
    }

    public abstract String fhirType();

    public boolean hasType(String ... name) {
        String t = this.fhirType();
        for (String n : name) {
            if (!n.equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    protected abstract void listChildren(List<Property> var1);

    public Base setProperty(String name, Base value) throws FHIRException {
        throw new FHIRException("Attempt to set unknown property " + name);
    }

    public Base addChild(String name) throws FHIRException {
        throw new FHIRException("Attempt to add child with unknown name " + name);
    }

    public List<Property> children() {
        ArrayList<Property> result = new ArrayList<Property>();
        this.listChildren(result);
        return result;
    }

    public Property getChildByName(String name) {
        ArrayList<Property> children = new ArrayList<Property>();
        this.listChildren(children);
        for (Property c : children) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public List<Base> listChildrenByName(String name) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base b : this.listChildrenByName(name, true)) {
            if (b == null) continue;
            result.add(b);
        }
        return result;
    }

    public Base[] listChildrenByName(String name, boolean checkValid) throws FHIRException {
        if (name.equals("*")) {
            ArrayList<Property> children = new ArrayList<Property>();
            this.listChildren(children);
            ArrayList<Base> result = new ArrayList<Base>();
            for (Property c : children) {
                result.addAll(c.getValues());
            }
            return result.toArray(new Base[result.size()]);
        }
        return this.getProperty(name.hashCode(), name, checkValid);
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean equalsDeep(Base other) {
        return other != null;
    }

    public boolean equalsShallow(Base other) {
        return other != null;
    }

    public static boolean compareDeep(String s1, String s2, boolean allowNull) {
        if (allowNull) {
            boolean noRight;
            boolean noLeft = s1 == null || Utilities.noString((String)s1);
            boolean bl = noRight = s2 == null || Utilities.noString((String)s2);
            if (noLeft && noRight) {
                return true;
            }
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean compareDeep(List<? extends Base> e1, List<? extends Base> e2, boolean allowNull) {
        if (Base.noList(e1) && Base.noList(e2) && allowNull) {
            return true;
        }
        if (Base.noList(e1) || Base.noList(e2)) {
            return false;
        }
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i = 0; i < e1.size(); ++i) {
            if (Base.compareDeep(e1.get(i), e2.get(i), allowNull)) continue;
            return false;
        }
        return true;
    }

    private static boolean noList(List<? extends Base> list) {
        return list == null || list.isEmpty();
    }

    public static boolean compareDeep(Base e1, Base e2, boolean allowNull) {
        if (allowNull) {
            boolean noRight;
            boolean noLeft = e1 == null || e1.isEmpty();
            boolean bl = noRight = e2 == null || e2.isEmpty();
            if (noLeft && noRight) {
                return true;
            }
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e2.isMetadataBased() && !e1.isMetadataBased()) {
            return e2.equalsDeep(e1);
        }
        return e1.equalsDeep(e2);
    }

    public static boolean compareDeep(XhtmlNode div1, XhtmlNode div2, boolean allowNull) {
        if (div1 == null && div2 == null && allowNull) {
            return true;
        }
        if (div1 == null || div2 == null) {
            return false;
        }
        return div1.equalsDeep(div2);
    }

    public static boolean compareValues(List<? extends PrimitiveType> e1, List<? extends PrimitiveType> e2, boolean allowNull) {
        if (e1 == null && e2 == null && allowNull) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i = 0; i < e1.size(); ++i) {
            if (Base.compareValues(e1.get(i), e2.get(i), allowNull)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareValues(PrimitiveType e1, PrimitiveType e2, boolean allowNull) {
        boolean noRight;
        boolean noLeft = e1 == null || e1.isEmpty();
        boolean bl = noRight = e2 == null || e2.isEmpty();
        if (noLeft && noRight && allowNull) {
            return true;
        }
        if (noLeft != noRight) {
            return false;
        }
        return e1.equalsShallow(e2);
    }

    public Type castToType(Base b) throws FHIRException {
        if (b instanceof Type) {
            return (Type)b;
        }
        if (b.isMetadataBased()) {
            return ((Element)b).asType();
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Reference");
    }

    public BooleanType castToBoolean(Base b) throws FHIRException {
        if (b instanceof BooleanType) {
            return (BooleanType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Boolean");
    }

    public IntegerType castToInteger(Base b) throws FHIRException {
        if (b instanceof IntegerType) {
            return (IntegerType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Integer");
    }

    public DecimalType castToDecimal(Base b) throws FHIRException {
        if (b instanceof DecimalType) {
            return (DecimalType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new DecimalType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Decimal");
    }

    public Base64BinaryType castToBase64Binary(Base b) throws FHIRException {
        if (b instanceof Base64BinaryType) {
            return (Base64BinaryType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Base64Binary");
    }

    public InstantType castToInstant(Base b) throws FHIRException {
        if (b instanceof InstantType) {
            return (InstantType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Instant");
    }

    public StringType castToString(Base b) throws FHIRException {
        if (b instanceof StringType) {
            return (StringType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new StringType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a String");
    }

    public UriType castToUri(Base b) throws FHIRException {
        if (b instanceof UriType) {
            return (UriType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new UriType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Uri");
    }

    public UrlType castToUrl(Base b) throws FHIRException {
        if (b instanceof UrlType) {
            return (UrlType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new UrlType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Uri");
    }

    public CanonicalType castToCanonical(Base b) throws FHIRException {
        if (b instanceof CanonicalType) {
            return (CanonicalType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new CanonicalType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Uri");
    }

    public DateType castToDate(Base b) throws FHIRException {
        if (b instanceof DateType) {
            return (DateType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new DateType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Date");
    }

    public DateTimeType castToDateTime(Base b) throws FHIRException {
        if (b instanceof DateTimeType) {
            return (DateTimeType)b;
        }
        if (b.fhirType().equals("dateTime")) {
            return new DateTimeType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a DateTime");
    }

    public TimeType castToTime(Base b) throws FHIRException {
        if (b instanceof TimeType) {
            return (TimeType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Time");
    }

    public CodeType castToCode(Base b) throws FHIRException {
        if (b instanceof CodeType) {
            return (CodeType)b;
        }
        if (b.isPrimitive()) {
            return new CodeType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Code");
    }

    public OidType castToOid(Base b) throws FHIRException {
        if (b instanceof OidType) {
            return (OidType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Oid");
    }

    public IdType castToId(Base b) throws FHIRException {
        if (b instanceof IdType) {
            return (IdType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Id");
    }

    public UnsignedIntType castToUnsignedInt(Base b) throws FHIRException {
        if (b instanceof UnsignedIntType) {
            return (UnsignedIntType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a UnsignedInt");
    }

    public PositiveIntType castToPositiveInt(Base b) throws FHIRException {
        if (b instanceof PositiveIntType) {
            return (PositiveIntType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a PositiveInt");
    }

    public MarkdownType castToMarkdown(Base b) throws FHIRException {
        if (b instanceof MarkdownType) {
            return (MarkdownType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new MarkdownType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Markdown");
    }

    public Annotation castToAnnotation(Base b) throws FHIRException {
        if (b instanceof Annotation) {
            return (Annotation)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Annotation");
    }

    public Dosage castToDosage(Base b) throws FHIRException {
        if (b instanceof Dosage) {
            return (Dosage)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an DosageInstruction");
    }

    public Attachment castToAttachment(Base b) throws FHIRException {
        if (b instanceof Attachment) {
            return (Attachment)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Attachment");
    }

    public Identifier castToIdentifier(Base b) throws FHIRException {
        if (b instanceof Identifier) {
            return (Identifier)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Identifier");
    }

    public CodeableConcept castToCodeableConcept(Base b) throws FHIRException {
        if (b instanceof CodeableConcept) {
            return (CodeableConcept)b;
        }
        if (b instanceof Element) {
            return ObjectConverter.readAsCodeableConcept((Element)b);
        }
        if (b instanceof CodeType) {
            CodeableConcept cc = new CodeableConcept();
            cc.addCoding().setCode(((CodeType)b).asStringValue());
            return cc;
        }
        if (b instanceof StringType) {
            CodeableConcept cc = new CodeableConcept();
            cc.addCoding().setCode(((StringType)b).asStringValue());
            return cc;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a CodeableConcept");
    }

    public Population castToPopulation(Base b) throws FHIRException {
        if (b instanceof Population) {
            return (Population)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Population");
    }

    public Coding castToCoding(Base b) throws FHIRException {
        if (b instanceof Coding) {
            return (Coding)b;
        }
        if (b instanceof Element) {
            ICoding c = ((Element)b).getAsICoding();
            if (c == null) {
                throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Coding");
            }
            return new Coding().setCode(c.getCode()).setSystem(c.getSystem()).setVersion(c.getVersion()).setDisplay(c.getDisplay());
        }
        if (b instanceof ICoding) {
            ICoding c = (ICoding)((Object)b);
            return new Coding().setCode(c.getCode()).setSystem(c.getSystem()).setVersion(c.getVersion()).setDisplay(c.getDisplay());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Coding");
    }

    public Quantity castToQuantity(Base b) throws FHIRException {
        if (b instanceof Quantity) {
            return (Quantity)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Quantity");
    }

    public Money castToMoney(Base b) throws FHIRException {
        if (b instanceof Money) {
            return (Money)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Money");
    }

    public Duration castToDuration(Base b) throws FHIRException {
        if (b instanceof Duration) {
            return (Duration)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Duration");
    }

    public SimpleQuantity castToSimpleQuantity(Base b) throws FHIRException {
        if (b instanceof SimpleQuantity) {
            return (SimpleQuantity)b;
        }
        if (b instanceof Quantity) {
            Quantity q = (Quantity)b;
            SimpleQuantity sq = new SimpleQuantity();
            sq.setValueElement(q.getValueElement());
            sq.setComparatorElement(q.getComparatorElement());
            sq.setUnitElement(q.getUnitElement());
            sq.setSystemElement(q.getSystemElement());
            sq.setCodeElement(q.getCodeElement());
            return sq;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an SimpleQuantity");
    }

    public Range castToRange(Base b) throws FHIRException {
        if (b instanceof Range) {
            return (Range)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Range");
    }

    public Period castToPeriod(Base b) throws FHIRException {
        if (b instanceof Period) {
            return (Period)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Period");
    }

    public Ratio castToRatio(Base b) throws FHIRException {
        if (b instanceof Ratio) {
            return (Ratio)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Ratio");
    }

    public SampledData castToSampledData(Base b) throws FHIRException {
        if (b instanceof SampledData) {
            return (SampledData)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a SampledData");
    }

    public Signature castToSignature(Base b) throws FHIRException {
        if (b instanceof Signature) {
            return (Signature)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Signature");
    }

    public HumanName castToHumanName(Base b) throws FHIRException {
        if (b instanceof HumanName) {
            return (HumanName)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a HumanName");
    }

    public Address castToAddress(Base b) throws FHIRException {
        if (b instanceof Address) {
            return (Address)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Address");
    }

    public ContactDetail castToContactDetail(Base b) throws FHIRException {
        if (b instanceof ContactDetail) {
            return (ContactDetail)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ContactDetail");
    }

    public Contributor castToContributor(Base b) throws FHIRException {
        if (b instanceof Contributor) {
            return (Contributor)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Contributor");
    }

    public UsageContext castToUsageContext(Base b) throws FHIRException {
        if (b instanceof UsageContext) {
            return (UsageContext)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a UsageContext");
    }

    public RelatedArtifact castToRelatedArtifact(Base b) throws FHIRException {
        if (b instanceof RelatedArtifact) {
            return (RelatedArtifact)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a RelatedArtifact");
    }

    public ContactPoint castToContactPoint(Base b) throws FHIRException {
        if (b instanceof ContactPoint) {
            return (ContactPoint)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ContactPoint");
    }

    public Timing castToTiming(Base b) throws FHIRException {
        if (b instanceof Timing) {
            return (Timing)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Timing");
    }

    public Reference castToReference(Base b) throws FHIRException {
        if (b instanceof Reference) {
            return (Reference)b;
        }
        if (b.isPrimitive() && Utilities.isURL((String)b.primitiveValue())) {
            return new Reference().setReference(b.primitiveValue());
        }
        if (b instanceof Element && b.fhirType().equals("Reference")) {
            Element e = (Element)b;
            return new Reference().setReference(e.getChildValue("reference")).setDisplay(e.getChildValue("display"));
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Reference");
    }

    public Meta castToMeta(Base b) throws FHIRException {
        if (b instanceof Meta) {
            return (Meta)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Meta");
    }

    public MarketingStatus castToMarketingStatus(Base b) throws FHIRException {
        if (b instanceof MarketingStatus) {
            return (MarketingStatus)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a MarketingStatus");
    }

    public Statistic castToStatistic(Base b) throws FHIRException {
        if (b instanceof Statistic) {
            return (Statistic)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Statistic");
    }

    public OrderedDistribution castToOrderedDistribution(Base b) throws FHIRException {
        if (b instanceof OrderedDistribution) {
            return (OrderedDistribution)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a OrderedDistribution");
    }

    public ProductShelfLife castToProductShelfLife(Base b) throws FHIRException {
        if (b instanceof ProductShelfLife) {
            return (ProductShelfLife)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ProductShelfLife");
    }

    public ProdCharacteristic castToProdCharacteristic(Base b) throws FHIRException {
        if (b instanceof ProdCharacteristic) {
            return (ProdCharacteristic)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ProdCharacteristic");
    }

    public SubstanceAmount castToSubstanceAmount(Base b) throws FHIRException {
        if (b instanceof SubstanceAmount) {
            return (SubstanceAmount)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a SubstanceAmount");
    }

    public Extension castToExtension(Base b) throws FHIRException {
        if (b instanceof Extension) {
            return (Extension)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Extension");
    }

    public Resource castToResource(Base b) throws FHIRException {
        if (b instanceof Resource) {
            return (Resource)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Resource");
    }

    public Narrative castToNarrative(Base b) throws FHIRException {
        if (b instanceof Narrative) {
            return (Narrative)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Narrative");
    }

    public ElementDefinition castToElementDefinition(Base b) throws FHIRException {
        if (b instanceof ElementDefinition) {
            return (ElementDefinition)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ElementDefinition");
    }

    public DataRequirement castToDataRequirement(Base b) throws FHIRException {
        if (b instanceof DataRequirement) {
            return (DataRequirement)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a DataRequirement");
    }

    public Expression castToExpression(Base b) throws FHIRException {
        if (b instanceof Expression) {
            return (Expression)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Expression");
    }

    public ParameterDefinition castToParameterDefinition(Base b) throws FHIRException {
        if (b instanceof ParameterDefinition) {
            return (ParameterDefinition)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ParameterDefinition");
    }

    public TriggerDefinition castToTriggerDefinition(Base b) throws FHIRException {
        if (b instanceof TriggerDefinition) {
            return (TriggerDefinition)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a TriggerDefinition");
    }

    public XhtmlNode castToXhtml(Base b) throws FHIRException {
        if (b instanceof Element) {
            return ((Element)b).getXhtml();
        }
        if (b instanceof XhtmlType) {
            return ((XhtmlType)b).getValue();
        }
        if (b instanceof StringType) {
            try {
                return new XhtmlParser().parseFragment(((StringType)b).asStringValue());
            }
            catch (IOException e) {
                throw new FHIRException((Throwable)e);
            }
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to XHtml");
    }

    public String castToXhtmlString(Base b) throws FHIRException {
        if (b instanceof Element) {
            return ((Element)b).getValue();
        }
        if (b instanceof XhtmlType) {
            try {
                return new XhtmlComposer(true).compose(((XhtmlType)b).getValue());
            }
            catch (IOException e) {
                return null;
            }
        }
        if (b instanceof StringType) {
            return ((StringType)b).asStringValue();
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to XHtml string");
    }

    protected boolean isMetadataBased() {
        return false;
    }

    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if (checkValid) {
            throw new FHIRException("Attempt to read invalid property '" + name + "' on type " + this.fhirType());
        }
        return null;
    }

    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        throw new FHIRException("Attempt to write to invalid property '" + name + "' on type " + this.fhirType());
    }

    public Base makeProperty(int hash, String name) throws FHIRException {
        throw new FHIRException("Attempt to make an invalid property '" + name + "' on type " + this.fhirType());
    }

    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        throw new FHIRException("Attempt to get types for an invalid property '" + name + "' on type " + this.fhirType());
    }

    public static boolean equals(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    public boolean isResource() {
        return false;
    }

    public abstract String getIdBase();

    public abstract void setIdBase(String var1);

    public Property getNamedProperty(String _name) throws FHIRException {
        return this.getNamedProperty(_name.hashCode(), _name, false);
    }

    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        if (_checkValid) {
            throw new FHIRException("Attempt to read invalid property '" + _name + "' on type " + this.fhirType());
        }
        return null;
    }
}

