/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Account", profile="http://hl7.org/fhir/StructureDefinition/Account")
public class Account
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Account number", formalDefinition="Unique identifier used to reference the account.  Might or might not be intended for human use (e.g. credit card number).")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error | on-hold | unknown", formalDefinition="Indicates whether the account is presently used/usable or not.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-status")
    protected Enumeration<AccountStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. patient, expense, depreciation", formalDefinition="Categorizes the account for reporting and searching purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-type")
    protected CodeableConcept type;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable label", formalDefinition="Name used for the account when displaying it to humans in reports, etc.")
    protected StringType name;
    @Child(name="subject", type={Patient.class, Device.class, Practitioner.class, PractitionerRole.class, Location.class, HealthcareService.class, Organization.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The entity that caused the expenses", formalDefinition="Identifies the entity which incurs the expenses. While the immediate recipients of services or goods might be entities related to the subject, the expenses were ultimately incurred by the subject of the Account.")
    protected List<Reference> subject;
    @Child(name="servicePeriod", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Transaction window", formalDefinition="The date range of services associated with this account.")
    protected Period servicePeriod;
    @Child(name="coverage", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account", formalDefinition="The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account.")
    protected List<CoverageComponent> coverage;
    @Child(name="owner", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Entity managing the Account", formalDefinition="Indicates the service area, hospital, department, etc. with responsibility for managing the Account.")
    protected Reference owner;
    @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Explanation of purpose/use", formalDefinition="Provides additional information about what the account tracks and how it is used.")
    protected StringType description;
    @Child(name="guarantor", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The parties ultimately responsible for balancing the Account", formalDefinition="The parties responsible for balancing the account if other payment options fall short.")
    protected List<GuarantorComponent> guarantor;
    @Child(name="partOf", type={Account.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to a parent Account", formalDefinition="Reference to a parent Account.")
    protected Reference partOf;
    private static final long serialVersionUID = 1572782679L;
    @SearchParamDefinition(name="owner", path="Account.owner", description="Entity managing the Account", type="reference", target={Organization.class})
    public static final String SP_OWNER = "owner";
    public static final ReferenceClientParam OWNER = new ReferenceClientParam("owner");
    public static final Include INCLUDE_OWNER = new Include("Account:owner").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier", description="Account number", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="period", path="Account.servicePeriod", description="Transaction window", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="subject", path="Account.subject", description="The entity that caused the expenses", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner")}, target={Device.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Account:subject").toLocked();
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient)", description="The entity that caused the expenses", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Account:patient").toLocked();
    @SearchParamDefinition(name="name", path="Account.name", description="Human-readable label", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="type", path="Account.type", description="E.g. patient, expense, depreciation", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="status", path="Account.status", description="active | inactive | entered-in-error | on-hold | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Account() {
    }

    public Account(Enumeration<AccountStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Account setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Account addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<AccountStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AccountStatus>(new AccountStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Account setStatusElement(Enumeration<AccountStatus> value) {
        this.status = value;
        return this;
    }

    public AccountStatus getStatus() {
        return this.status == null ? null : (AccountStatus)((Object)this.status.getValue());
    }

    public Account setStatus(AccountStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<AccountStatus>(new AccountStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Account setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Account setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Account setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public Account setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public Account addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public Period getServicePeriod() {
        if (this.servicePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.servicePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.servicePeriod = new Period();
            }
        }
        return this.servicePeriod;
    }

    public boolean hasServicePeriod() {
        return this.servicePeriod != null && !this.servicePeriod.isEmpty();
    }

    public Account setServicePeriod(Period value) {
        this.servicePeriod = value;
        return this;
    }

    public List<CoverageComponent> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        return this.coverage;
    }

    public Account setCoverage(List<CoverageComponent> theCoverage) {
        this.coverage = theCoverage;
        return this;
    }

    public boolean hasCoverage() {
        if (this.coverage == null) {
            return false;
        }
        for (CoverageComponent item : this.coverage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CoverageComponent addCoverage() {
        CoverageComponent t = new CoverageComponent();
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return t;
    }

    public Account addCoverage(CoverageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return this;
    }

    public CoverageComponent getCoverageFirstRep() {
        if (this.getCoverage().isEmpty()) {
            this.addCoverage();
        }
        return this.getCoverage().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Account setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Account setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Account setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<GuarantorComponent> getGuarantor() {
        if (this.guarantor == null) {
            this.guarantor = new ArrayList<GuarantorComponent>();
        }
        return this.guarantor;
    }

    public Account setGuarantor(List<GuarantorComponent> theGuarantor) {
        this.guarantor = theGuarantor;
        return this;
    }

    public boolean hasGuarantor() {
        if (this.guarantor == null) {
            return false;
        }
        for (GuarantorComponent item : this.guarantor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GuarantorComponent addGuarantor() {
        GuarantorComponent t = new GuarantorComponent();
        if (this.guarantor == null) {
            this.guarantor = new ArrayList<GuarantorComponent>();
        }
        this.guarantor.add(t);
        return t;
    }

    public Account addGuarantor(GuarantorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.guarantor == null) {
            this.guarantor = new ArrayList<GuarantorComponent>();
        }
        this.guarantor.add(t);
        return this;
    }

    public GuarantorComponent getGuarantorFirstRep() {
        if (this.getGuarantor().isEmpty()) {
            this.addGuarantor();
        }
        return this.getGuarantor().get(0);
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Account setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier used to reference the account.  Might or might not be intended for human use (e.g. credit card number).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates whether the account is presently used/usable or not.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Categorizes the account for reporting and searching purposes.", 0, 1, this.type));
        children.add(new Property(SP_NAME, "string", "Name used for the account when displaying it to humans in reports, etc.", 0, 1, this.name));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Device|Practitioner|PractitionerRole|Location|HealthcareService|Organization)", "Identifies the entity which incurs the expenses. While the immediate recipients of services or goods might be entities related to the subject, the expenses were ultimately incurred by the subject of the Account.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("servicePeriod", "Period", "The date range of services associated with this account.", 0, 1, this.servicePeriod));
        children.add(new Property("coverage", "", "The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account.", 0, Integer.MAX_VALUE, this.coverage));
        children.add(new Property(SP_OWNER, "Reference(Organization)", "Indicates the service area, hospital, department, etc. with responsibility for managing the Account.", 0, 1, this.owner));
        children.add(new Property("description", "string", "Provides additional information about what the account tracks and how it is used.", 0, 1, this.description));
        children.add(new Property("guarantor", "", "The parties responsible for balancing the account if other payment options fall short.", 0, Integer.MAX_VALUE, this.guarantor));
        children.add(new Property("partOf", "Reference(Account)", "Reference to a parent Account.", 0, 1, this.partOf));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier used to reference the account.  Might or might not be intended for human use (e.g. credit card number).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates whether the account is presently used/usable or not.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Categorizes the account for reporting and searching purposes.", 0, 1, this.type);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Name used for the account when displaying it to humans in reports, etc.", 0, 1, this.name);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Device|Practitioner|PractitionerRole|Location|HealthcareService|Organization)", "Identifies the entity which incurs the expenses. While the immediate recipients of services or goods might be entities related to the subject, the expenses were ultimately incurred by the subject of the Account.", 0, Integer.MAX_VALUE, this.subject);
            }
            case 2129104086: {
                return new Property("servicePeriod", "Period", "The date range of services associated with this account.", 0, 1, this.servicePeriod);
            }
            case -351767064: {
                return new Property("coverage", "", "The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account.", 0, Integer.MAX_VALUE, this.coverage);
            }
            case 106164915: {
                return new Property(SP_OWNER, "Reference(Organization)", "Indicates the service area, hospital, department, etc. with responsibility for managing the Account.", 0, 1, this.owner);
            }
            case -1724546052: {
                return new Property("description", "string", "Provides additional information about what the account tracks and how it is used.", 0, 1, this.description);
            }
            case -188629045: {
                return new Property("guarantor", "", "The parties responsible for balancing the account if other payment options fall short.", 0, Integer.MAX_VALUE, this.guarantor);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Account)", "Reference to a parent Account.", 0, 1, this.partOf);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 2129104086: {
                Base[] baseArray;
                if (this.servicePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.servicePeriod;
                }
                return baseArray;
            }
            case -351767064: {
                return this.coverage == null ? new Base[]{} : this.coverage.toArray(new Base[this.coverage.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.owner;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case -188629045: {
                return this.guarantor == null ? new Base[]{} : this.guarantor.toArray(new Base[this.guarantor.size()]);
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.partOf;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new AccountStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case 2129104086: {
                this.servicePeriod = this.castToPeriod(value);
                return value;
            }
            case -351767064: {
                this.getCoverage().add((CoverageComponent)((Object)value));
                return value;
            }
            case 106164915: {
                this.owner = this.castToReference(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -188629045: {
                this.getGuarantor().add((GuarantorComponent)((Object)value));
                return value;
            }
            case -995410646: {
                this.partOf = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new AccountStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("servicePeriod")) {
            this.servicePeriod = this.castToPeriod(value);
        } else if (name.equals("coverage")) {
            this.getCoverage().add((CoverageComponent)((Object)value));
        } else if (name.equals(SP_OWNER)) {
            this.owner = this.castToReference(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("guarantor")) {
            this.getGuarantor().add((GuarantorComponent)((Object)value));
        } else if (name.equals("partOf")) {
            this.partOf = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case 2129104086: {
                return this.getServicePeriod();
            }
            case -351767064: {
                return this.addCoverage();
            }
            case 106164915: {
                return this.getOwner();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -188629045: {
                return this.addGuarantor();
            }
            case -995410646: {
                return this.getPartOf();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 2129104086: {
                return new String[]{"Period"};
            }
            case -351767064: {
                return new String[0];
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -188629045: {
                return new String[0];
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Account.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Account.name");
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("servicePeriod")) {
            this.servicePeriod = new Period();
            return this.servicePeriod;
        }
        if (name.equals("coverage")) {
            return this.addCoverage();
        }
        if (name.equals(SP_OWNER)) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Account.description");
        }
        if (name.equals("guarantor")) {
            return this.addGuarantor();
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Account";
    }

    @Override
    public Account copy() {
        Account dst = new Account();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Account dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        Period period = dst.servicePeriod = this.servicePeriod == null ? null : this.servicePeriod.copy();
        if (this.coverage != null) {
            dst.coverage = new ArrayList<CoverageComponent>();
            for (CoverageComponent coverageComponent : this.coverage) {
                dst.coverage.add(coverageComponent.copy());
            }
        }
        dst.owner = this.owner == null ? null : this.owner.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.guarantor != null) {
            dst.guarantor = new ArrayList<GuarantorComponent>();
            for (GuarantorComponent guarantorComponent : this.guarantor) {
                dst.guarantor.add(guarantorComponent.copy());
            }
        }
        dst.partOf = this.partOf == null ? null : this.partOf.copy();
    }

    protected Account typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Account)) {
            return false;
        }
        Account o = (Account)other_;
        return Account.compareDeep(this.identifier, o.identifier, true) && Account.compareDeep(this.status, o.status, true) && Account.compareDeep(this.type, o.type, true) && Account.compareDeep(this.name, o.name, true) && Account.compareDeep(this.subject, o.subject, true) && Account.compareDeep(this.servicePeriod, o.servicePeriod, true) && Account.compareDeep(this.coverage, o.coverage, true) && Account.compareDeep(this.owner, o.owner, true) && Account.compareDeep(this.description, o.description, true) && Account.compareDeep(this.guarantor, o.guarantor, true) && Account.compareDeep(this.partOf, o.partOf, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Account)) {
            return false;
        }
        Account o = (Account)other_;
        return Account.compareValues(this.status, o.status, true) && Account.compareValues(this.name, o.name, true) && Account.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.name, this.subject, this.servicePeriod, this.coverage, this.owner, this.description, this.guarantor, this.partOf});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Account;
    }

    @Block
    public static class GuarantorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="party", type={Patient.class, RelatedPerson.class, Organization.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Responsible entity", formalDefinition="The entity who is responsible.")
        protected Reference party;
        @Child(name="onHold", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Credit or other hold applied", formalDefinition="A guarantor may be placed on credit hold or otherwise have their role temporarily suspended.")
        protected BooleanType onHold;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Guarantee account during", formalDefinition="The timeframe during which the guarantor accepts responsibility for the account.")
        protected Period period;
        private static final long serialVersionUID = -523056773L;

        public GuarantorComponent() {
        }

        public GuarantorComponent(Reference party) {
            this.party = party;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuarantorComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public GuarantorComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public BooleanType getOnHoldElement() {
            if (this.onHold == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuarantorComponent.onHold");
                }
                if (Configuration.doAutoCreate()) {
                    this.onHold = new BooleanType();
                }
            }
            return this.onHold;
        }

        public boolean hasOnHoldElement() {
            return this.onHold != null && !this.onHold.isEmpty();
        }

        public boolean hasOnHold() {
            return this.onHold != null && !this.onHold.isEmpty();
        }

        public GuarantorComponent setOnHoldElement(BooleanType value) {
            this.onHold = value;
            return this;
        }

        public boolean getOnHold() {
            return this.onHold == null || this.onHold.isEmpty() ? false : (Boolean)this.onHold.getValue();
        }

        public GuarantorComponent setOnHold(boolean value) {
            if (this.onHold == null) {
                this.onHold = new BooleanType();
            }
            this.onHold.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuarantorComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public GuarantorComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("party", "Reference(Patient|RelatedPerson|Organization)", "The entity who is responsible.", 0, 1, this.party));
            children.add(new Property("onHold", "boolean", "A guarantor may be placed on credit hold or otherwise have their role temporarily suspended.", 0, 1, this.onHold));
            children.add(new Property(Account.SP_PERIOD, "Period", "The timeframe during which the guarantor accepts responsibility for the account.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106437350: {
                    return new Property("party", "Reference(Patient|RelatedPerson|Organization)", "The entity who is responsible.", 0, 1, this.party);
                }
                case -1013289154: {
                    return new Property("onHold", "boolean", "A guarantor may be placed on credit hold or otherwise have their role temporarily suspended.", 0, 1, this.onHold);
                }
                case -991726143: {
                    return new Property(Account.SP_PERIOD, "Period", "The timeframe during which the guarantor accepts responsibility for the account.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.party;
                    }
                    return baseArray;
                }
                case -1013289154: {
                    Base[] baseArray;
                    if (this.onHold == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onHold;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    this.party = this.castToReference(value);
                    return value;
                }
                case -1013289154: {
                    this.onHold = this.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else if (name.equals("onHold")) {
                this.onHold = this.castToBoolean(value);
            } else if (name.equals(Account.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    return this.getParty();
                }
                case -1013289154: {
                    return this.getOnHoldElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    return new String[]{"Reference"};
                }
                case -1013289154: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            if (name.equals("onHold")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.onHold");
            }
            if (name.equals(Account.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public GuarantorComponent copy() {
            GuarantorComponent dst = new GuarantorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GuarantorComponent dst) {
            super.copyValues(dst);
            dst.party = this.party == null ? null : this.party.copy();
            dst.onHold = this.onHold == null ? null : this.onHold.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GuarantorComponent)) {
                return false;
            }
            GuarantorComponent o = (GuarantorComponent)other_;
            return GuarantorComponent.compareDeep(this.party, o.party, true) && GuarantorComponent.compareDeep(this.onHold, o.onHold, true) && GuarantorComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GuarantorComponent)) {
                return false;
            }
            GuarantorComponent o = (GuarantorComponent)other_;
            return GuarantorComponent.compareValues(this.onHold, o.onHold, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.party, this.onHold, this.period});
        }

        @Override
        public String fhirType() {
            return "Account.guarantor";
        }
    }

    @Block
    public static class CoverageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="coverage", type={Coverage.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The party(s), such as insurances, that may contribute to the payment of this account", formalDefinition="The party(s) that contribute to payment (or part of) of the charges applied to this account (including self-pay).\n\nA coverage may only be responsible for specific types of charges, and the sequence of the coverages in the account could be important when processing billing.")
        protected Reference coverage;
        @Child(name="priority", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The priority of the coverage in the context of this account", formalDefinition="The priority of the coverage in the context of this account.")
        protected PositiveIntType priority;
        private static final long serialVersionUID = 1695665065L;

        public CoverageComponent() {
        }

        public CoverageComponent(Reference coverage) {
            this.coverage = coverage;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public CoverageComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public PositiveIntType getPriorityElement() {
            if (this.priority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.priority");
                }
                if (Configuration.doAutoCreate()) {
                    this.priority = new PositiveIntType();
                }
            }
            return this.priority;
        }

        public boolean hasPriorityElement() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public boolean hasPriority() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public CoverageComponent setPriorityElement(PositiveIntType value) {
            this.priority = value;
            return this;
        }

        public int getPriority() {
            return this.priority == null || this.priority.isEmpty() ? 0 : (Integer)this.priority.getValue();
        }

        public CoverageComponent setPriority(int value) {
            if (this.priority == null) {
                this.priority = new PositiveIntType();
            }
            this.priority.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("coverage", "Reference(Coverage)", "The party(s) that contribute to payment (or part of) of the charges applied to this account (including self-pay).\n\nA coverage may only be responsible for specific types of charges, and the sequence of the coverages in the account could be important when processing billing.", 0, 1, this.coverage));
            children.add(new Property("priority", "positiveInt", "The priority of the coverage in the context of this account.", 0, 1, this.priority));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "The party(s) that contribute to payment (or part of) of the charges applied to this account (including self-pay).\n\nA coverage may only be responsible for specific types of charges, and the sequence of the coverages in the account could be important when processing billing.", 0, 1, this.coverage);
                }
                case -1165461084: {
                    return new Property("priority", "positiveInt", "The priority of the coverage in the context of this account.", 0, 1, this.priority);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.coverage;
                    }
                    return baseArray;
                }
                case -1165461084: {
                    Base[] baseArray;
                    if (this.priority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.priority;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
                case -1165461084: {
                    this.priority = this.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("priority")) {
                this.priority = this.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return this.getCoverage();
                }
                case -1165461084: {
                    return this.getPriorityElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case -1165461084: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("priority")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.priority");
            }
            return super.addChild(name);
        }

        @Override
        public CoverageComponent copy() {
            CoverageComponent dst = new CoverageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CoverageComponent dst) {
            super.copyValues(dst);
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.priority = this.priority == null ? null : this.priority.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other_;
            return CoverageComponent.compareDeep(this.coverage, o.coverage, true) && CoverageComponent.compareDeep(this.priority, o.priority, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other_;
            return CoverageComponent.compareValues(this.priority, o.priority, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.coverage, this.priority});
        }

        @Override
        public String fhirType() {
            return "Account.coverage";
        }
    }

    public static class AccountStatusEnumFactory
    implements EnumFactory<AccountStatus> {
        @Override
        public AccountStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return AccountStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return AccountStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return AccountStatus.ENTEREDINERROR;
            }
            if ("on-hold".equals(codeString)) {
                return AccountStatus.ONHOLD;
            }
            if ("unknown".equals(codeString)) {
                return AccountStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown AccountStatus code '" + codeString + "'");
        }

        public Enumeration<AccountStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AccountStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.ENTEREDINERROR);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.ONHOLD);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown AccountStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AccountStatus code) {
            if (code == AccountStatus.ACTIVE) {
                return "active";
            }
            if (code == AccountStatus.INACTIVE) {
                return "inactive";
            }
            if (code == AccountStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == AccountStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == AccountStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(AccountStatus code) {
            return code.getSystem();
        }
    }

    public static enum AccountStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        ONHOLD,
        UNKNOWN,
        NULL;


        public static AccountStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AccountStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/account-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/account-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/account-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/account-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/account-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "This account is active and may be used.";
                }
                case INACTIVE: {
                    return "This account is inactive and should not be used to track financial information.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case ONHOLD: {
                    return "This account is on hold.";
                }
                case UNKNOWN: {
                    return "The account status is unknown.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

