/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class TerminologyCache {
    public static final boolean TRANSIENT = false;
    public static final boolean PERMANENT = true;
    private static final String NAME_FOR_NO_SYSTEM = "all-systems";
    private static final String ENTRY_MARKER = "-------------------------------------------------------------------------------------";
    private static final String BREAK = "####";
    private Object lock;
    private String folder;
    private Map<String, NamedCache> caches = new HashMap<String, NamedCache>();

    public TerminologyCache(Object lock, String folder) throws FileNotFoundException, IOException, FHIRException {
        this.lock = lock;
        this.folder = folder;
        if (folder != null) {
            this.load();
        }
    }

    public CacheToken generateValidationToken(TerminologyServiceOptions options, Coding code, ValueSet vs) {
        CacheToken ct = new CacheToken();
        if (code.hasSystem()) {
            ct.name = this.getNameForSystem(code.getSystem());
        } else {
            ct.name = NAME_FOR_NO_SYSTEM;
        }
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        ValueSet vsc = this.getVSEssense(vs);
        try {
            ct.request = "{\"code\" : " + json.composeString(code, "code") + ", \"valueSet\" :" + (vsc == null ? "null" : json.composeString(vsc)) + (options == null ? "" : ", " + options.toJson()) + "}";
        }
        catch (IOException e) {
            throw new Error(e);
        }
        ct.key = String.valueOf(this.hashNWS(ct.request));
        return ct;
    }

    public CacheToken generateValidationToken(TerminologyServiceOptions options, CodeableConcept code, ValueSet vs) {
        CacheToken ct = new CacheToken();
        for (Coding c : code.getCoding()) {
            if (!c.hasSystem()) continue;
            ct.setName(this.getNameForSystem(c.getSystem()));
        }
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        ValueSet vsc = this.getVSEssense(vs);
        try {
            ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"valueSet\" :" + json.composeString(vsc) + (options == null ? "" : ", " + options.toJson()) + "}";
        }
        catch (IOException e) {
            throw new Error(e);
        }
        ct.key = String.valueOf(this.hashNWS(ct.request));
        return ct;
    }

    public ValueSet getVSEssense(ValueSet vs) {
        if (vs == null) {
            return null;
        }
        ValueSet vsc = new ValueSet();
        vsc.setCompose(vs.getCompose());
        if (vs.hasExpansion()) {
            vsc.getExpansion().getParameter().addAll(vs.getExpansion().getParameter());
            vsc.getExpansion().getContains().addAll(vs.getExpansion().getContains());
        }
        return vsc;
    }

    public CacheToken generateExpandToken(ValueSet vs, boolean heirarchical) {
        CacheToken ct = new CacheToken();
        ValueSet vsc = this.getVSEssense(vs);
        for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getInclude()) {
            if (!conceptSetComponent.hasSystem()) continue;
            ct.setName(this.getNameForSystem(conceptSetComponent.getSystem()));
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getExclude()) {
            if (!conceptSetComponent.hasSystem()) continue;
            ct.setName(this.getNameForSystem(conceptSetComponent.getSystem()));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : vs.getExpansion().getContains()) {
            if (!valueSetExpansionContainsComponent.hasSystem()) continue;
            ct.setName(this.getNameForSystem(valueSetExpansionContainsComponent.getSystem()));
        }
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.PRETTY);
        try {
            ct.request = "{\"hierarchical\" : " + (heirarchical ? "true" : "false") + ", \"valueSet\" :" + json.composeString(vsc) + "}\r\n";
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        ct.key = String.valueOf(this.hashNWS(ct.request));
        return ct;
    }

    private String getNameForSystem(String system) {
        if (system.equals("http://snomed.info/sct")) {
            return "snomed";
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return "rxnorm";
        }
        if (system.equals("http://loinc.org")) {
            return "loinc";
        }
        if (system.equals("http://unitsofmeasure.org")) {
            return "ucum";
        }
        if (system.startsWith("http://hl7.org/fhir/sid/")) {
            return system.substring(24).replace("/", "");
        }
        if (system.startsWith("urn:iso:std:iso:")) {
            return "iso" + system.substring(16).replace(":", "");
        }
        if (system.startsWith("http://terminology.hl7.org/CodeSystem/")) {
            return system.substring(38).replace("/", "");
        }
        if (system.startsWith("http://hl7.org/fhir/")) {
            return system.substring(20).replace("/", "");
        }
        if (system.equals("urn:ietf:bcp:47")) {
            return "lang";
        }
        if (system.equals("urn:ietf:bcp:13")) {
            return "mimetypes";
        }
        if (system.equals("urn:iso:std:iso:11073:10101")) {
            return "11073";
        }
        if (system.equals("http://dicom.nema.org/resources/ontology/DCM")) {
            return "dicom";
        }
        return system.replace("/", "_").replace(":", "_");
    }

    public NamedCache getNamedCache(CacheToken cacheToken) {
        NamedCache nc = this.caches.get(cacheToken.name);
        if (nc == null) {
            nc = new NamedCache();
            nc.name = cacheToken.name;
            this.caches.put(nc.name, nc);
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSetExpander.ValueSetExpansionOutcome getExpansion(CacheToken cacheToken) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = (CacheEntry)nc.map.get(cacheToken.key);
            if (e == null) {
                return null;
            }
            return e.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheExpansion(CacheToken cacheToken, ValueSetExpander.ValueSetExpansionOutcome res, boolean persistent) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = new CacheEntry();
            e.request = cacheToken.request;
            e.persistent = persistent;
            e.e = res;
            this.store(cacheToken, persistent, nc, e);
        }
    }

    public void store(CacheToken cacheToken, boolean persistent, NamedCache nc, CacheEntry e) {
        boolean n = nc.map.containsKey(cacheToken.key);
        nc.map.put(cacheToken.key, e);
        if (persistent) {
            if (n) {
                for (int i = nc.list.size() - 1; i >= 0; --i) {
                    if (!((CacheEntry)nc.list.get(i)).request.equals(e.request)) continue;
                    nc.list.remove(i);
                }
            }
            nc.list.add(e);
            this.save(nc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkerContext.ValidationResult getValidation(CacheToken cacheToken) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = (CacheEntry)nc.map.get(cacheToken.key);
            if (e == null) {
                return null;
            }
            return e.v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheValidation(CacheToken cacheToken, IWorkerContext.ValidationResult res, boolean persistent) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = new CacheEntry();
            e.request = cacheToken.request;
            e.persistent = persistent;
            e.v = res;
            this.store(cacheToken, persistent, nc, e);
        }
    }

    public void save() {
    }

    private void save(NamedCache nc) {
        if (this.folder == null) {
            return;
        }
        try {
            OutputStreamWriter sw = new OutputStreamWriter((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.folder, nc.name + ".cache"})), "UTF-8");
            sw.write("-------------------------------------------------------------------------------------\r\n");
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            for (CacheEntry ce : nc.list) {
                sw.write(ce.request.trim());
                sw.write("####\r\n");
                if (ce.e != null) {
                    sw.write("e: {\r\n");
                    if (ce.e.getValueset() != null) {
                        sw.write("  \"valueSet\" : " + json.composeString(ce.e.getValueset()).trim() + ",\r\n");
                    }
                    sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.e.getError()).trim() + "\"\r\n}\r\n");
                } else {
                    sw.write("v: {\r\n");
                    sw.write("  \"display\" : \"" + Utilities.escapeJson((String)ce.v.getDisplay()).trim() + "\",\r\n");
                    sw.write("  \"severity\" : " + (ce.v.getSeverity() == null ? "null" : "\"" + ce.v.getSeverity().toCode().trim() + "\"") + ",\r\n");
                    sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.v.getMessage()).trim() + "\"\r\n}\r\n");
                }
                sw.write("-------------------------------------------------------------------------------------\r\n");
            }
            sw.close();
        }
        catch (Exception e) {
            System.out.println("error saving " + nc.name + ": " + e.getMessage());
        }
    }

    private void load() throws FHIRException {
        for (String fn : new File(this.folder).list()) {
            if (!fn.endsWith(".cache") || fn.equals("validation.cache")) continue;
            try {
                String title = fn.substring(0, fn.lastIndexOf("."));
                NamedCache nc = new NamedCache();
                nc.name = title;
                this.caches.put(title, nc);
                String src = TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, fn}));
                if (src.startsWith("?")) {
                    src = src.substring(1);
                }
                int i = src.indexOf(ENTRY_MARKER);
                while (i > -1) {
                    String s = src.substring(0, i);
                    src = src.substring(i + ENTRY_MARKER.length() + 1);
                    i = src.indexOf(ENTRY_MARKER);
                    if (Utilities.noString((String)s)) continue;
                    int j = s.indexOf(BREAK);
                    String q = s.substring(0, j);
                    String p = s.substring(j + BREAK.length() + 1).trim();
                    CacheEntry ce = new CacheEntry();
                    ce.persistent = true;
                    ce.request = q;
                    boolean e = p.charAt(0) == 'e';
                    p = p.substring(3);
                    JsonObject o = (JsonObject)new com.google.gson.JsonParser().parse(p);
                    String error = this.loadJS(o.get("error"));
                    if (e) {
                        if (o.has("valueSet")) {
                            ce.e = new ValueSetExpander.ValueSetExpansionOutcome((ValueSet)new JsonParser().parse(o.getAsJsonObject("valueSet")), error, ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
                        } else {
                            ce.e = new ValueSetExpander.ValueSetExpansionOutcome(error, ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
                        }
                    } else {
                        ValidationMessage.IssueSeverity severity = o.get("severity") instanceof JsonNull ? null : ValidationMessage.IssueSeverity.fromCode((String)o.get("severity").getAsString());
                        String display = this.loadJS(o.get("display"));
                        ce.v = new IWorkerContext.ValidationResult(severity, error, new CodeSystem.ConceptDefinitionComponent().setDisplay(display));
                    }
                    nc.map.put(String.valueOf(this.hashNWS(ce.request)), ce);
                    nc.list.add(ce);
                }
            }
            catch (Exception e) {
                throw new FHIRException("Error loading " + fn + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String loadJS(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (!(e instanceof JsonPrimitive)) {
            return null;
        }
        String s = e.getAsString();
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    private String hashNWS(String s) {
        return String.valueOf(s.replace("\r", "").replace("\n", "").replace(" ", "").hashCode());
    }

    public TerminologyCache copy() {
        return null;
    }

    public String summary(ValueSet vs) {
        if (vs == null) {
            return "null";
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            b.append("Include " + this.getIncSummary(cc));
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getExclude()) {
            b.append("Exclude " + this.getIncSummary(cc));
        }
        return b.toString();
    }

    private String getIncSummary(ValueSet.ConceptSetComponent cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (UriType uriType : cc.getValueSet()) {
            b.append(uriType.asStringValue());
        }
        String vsd = b.length() > 0 ? " where the codes are in the value sets (" + b.toString() + ")" : "";
        String string = cc.getSystem();
        if (cc.hasConcept()) {
            return Integer.toString(cc.getConcept().size()) + " codes from " + string + vsd;
        }
        if (cc.hasFilter()) {
            String s = "";
            for (ValueSet.ConceptSetFilterComponent f : cc.getFilter()) {
                if (!Utilities.noString((String)s)) {
                    s = s + " & ";
                }
                s = s + f.getProperty() + " " + (f.hasOp() ? f.getOp().toCode() : "?") + " " + f.getValue();
            }
            return "from " + string + " where " + s + vsd;
        }
        return "All codes from " + string + vsd;
    }

    public String summary(Coding code) {
        return code.getSystem() + "#" + code.getCode() + ": \"" + code.getDisplay() + "\"";
    }

    public String summary(CodeableConcept code) {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (Coding c : code.getCoding()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(this.summary(c));
        }
        b.append("}: \"");
        b.append(code.getText());
        b.append("\"");
        return b.toString();
    }

    private class NamedCache {
        private String name;
        private List<CacheEntry> list = new ArrayList<CacheEntry>();
        private Map<String, CacheEntry> map = new HashMap<String, CacheEntry>();

        private NamedCache() {
        }
    }

    private class CacheEntry {
        private String request;
        private boolean persistent;
        private IWorkerContext.ValidationResult v;
        private ValueSetExpander.ValueSetExpansionOutcome e;

        private CacheEntry() {
        }
    }

    public class CacheToken {
        private String name;
        private String key;
        private String request;

        public void setName(String n) {
            if (this.name == null) {
                this.name = n;
            } else if (!n.equals(this.name)) {
                this.name = TerminologyCache.NAME_FOR_NO_SYSTEM;
            }
        }
    }
}

