/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.r4.model.StructureDefinition;

public class ValidationProfileSet {
    private List<ProfileRegistration> canonical = new ArrayList<ProfileRegistration>();
    private List<StructureDefinition> definitions = new ArrayList<StructureDefinition>();

    public ValidationProfileSet(String profile, boolean isError) {
        this.canonical.add(new ProfileRegistration(profile, isError));
    }

    public ValidationProfileSet() {
    }

    public ValidationProfileSet(StructureDefinition profile) {
        this.definitions.add(profile);
        this.canonical.add(new ProfileRegistration(profile.getUrl(), true));
    }

    public ValidationProfileSet(List<String> profiles, boolean isError) {
        if (profiles != null) {
            for (String p : profiles) {
                this.canonical.add(new ProfileRegistration(p, isError));
            }
        }
    }

    public List<String> getCanonicalUrls() {
        ArrayList<String> res = new ArrayList<String>();
        for (ProfileRegistration c : this.canonical) {
            res.add(c.getProfile());
        }
        return res;
    }

    public List<StructureDefinition> getDefinitions() {
        return this.definitions;
    }

    public boolean empty() {
        return this.canonical.isEmpty() && this.definitions.isEmpty();
    }

    public List<String> getCanonicalAll() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getCanonicalUrls());
        for (StructureDefinition sd : this.definitions) {
            res.add(sd.getUrl());
        }
        return new ArrayList<String>(res);
    }

    public List<ProfileRegistration> getCanonical() {
        return this.canonical;
    }

    public StructureDefinition fetch(String effectiveProfile) {
        for (StructureDefinition sd : this.definitions) {
            if (!effectiveProfile.equals(sd.getUrl())) continue;
            return sd;
        }
        return null;
    }

    public static class ProfileRegistration {
        private String profile;
        private boolean errorOnMissing;

        public ProfileRegistration(String profile, boolean errorOnMissing) {
            this.profile = profile;
            this.errorOnMissing = errorOnMissing;
        }

        public String getProfile() {
            return this.profile;
        }

        public boolean isErrorOnMissing() {
            return this.errorOnMissing;
        }
    }
}

