/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3ProcessingMode {
    A,
    I,
    R,
    T,
    NULL;


    public static V3ProcessingMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("A".equals(codeString)) {
            return A;
        }
        if ("I".equals(codeString)) {
            return I;
        }
        if ("R".equals(codeString)) {
            return R;
        }
        if ("T".equals(codeString)) {
            return T;
        }
        throw new FHIRException("Unknown V3ProcessingMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A: {
                return "A";
            }
            case I: {
                return "I";
            }
            case R: {
                return "R";
            }
            case T: {
                return "T";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-ProcessingMode";
    }

    public String getDefinition() {
        switch (this) {
            case A: {
                return "Identifies archive mode of processing.";
            }
            case I: {
                return "Identifies initial load mode of processing.";
            }
            case R: {
                return "Identifies restore mode of processing.";
            }
            case T: {
                return "Identifies on-line mode of processing.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A: {
                return "Archive";
            }
            case I: {
                return "Initial load";
            }
            case R: {
                return "Restore from archive";
            }
            case T: {
                return "Current processing";
            }
        }
        return "?";
    }
}

