/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3CalendarType {
    GREG,
    NULL;


    public static V3CalendarType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("GREG".equals(codeString)) {
            return GREG;
        }
        throw new FHIRException("Unknown V3CalendarType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GREG: {
                return "GREG";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-CalendarType";
    }

    public String getDefinition() {
        switch (this) {
            case GREG: {
                return "The Gregorian calendar is in effect in the most countries of Christian influence since approximately 1582.  This calendar superceded the Julian calendar.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GREG: {
                return "Gregorian";
            }
        }
        return "?";
    }
}

