/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum InvoiceStatus {
    DRAFT,
    ISSUED,
    BALANCED,
    CANCELLED,
    ENTEREDINERROR,
    NULL;


    public static InvoiceStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("issued".equals(codeString)) {
            return ISSUED;
        }
        if ("balanced".equals(codeString)) {
            return BALANCED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown InvoiceStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ISSUED: {
                return "issued";
            }
            case BALANCED: {
                return "balanced";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/invoice-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "the invoice has been prepared but not yet finalized.";
            }
            case ISSUED: {
                return "the invoice has been finalized and sent to the recipient.";
            }
            case BALANCED: {
                return "the invoice has been balaced / completely paid.";
            }
            case CANCELLED: {
                return "the invoice was cancelled.";
            }
            case ENTEREDINERROR: {
                return "the invoice was determined as entered in error before it was issued.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ISSUED: {
                return "issued";
            }
            case BALANCED: {
                return "balanced";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered in error";
            }
        }
        return "?";
    }
}

