/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum InsuranceplanApplicability {
    INNETWORK,
    OUTOFNETWORK,
    OTHER,
    NULL;


    public static InsuranceplanApplicability fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-network".equals(codeString)) {
            return INNETWORK;
        }
        if ("out-of-network".equals(codeString)) {
            return OUTOFNETWORK;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown InsuranceplanApplicability code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INNETWORK: {
                return "in-network";
            }
            case OUTOFNETWORK: {
                return "out-of-network";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/applicability";
    }

    public String getDefinition() {
        switch (this) {
            case INNETWORK: {
                return "Provider is contracted with the health insurance company to provide services to plan members for specific pre-negotiated rates";
            }
            case OUTOFNETWORK: {
                return "Provider is  not contracted with the health insurance company to provide services to plan members for specific pre-negotiated rates";
            }
            case OTHER: {
                return "Other applicability";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INNETWORK: {
                return "In Network";
            }
            case OUTOFNETWORK: {
                return "Out of Network";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "?";
    }
}

