/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DeviceStatusReason {
    ONLINE,
    PAUSED,
    STANDBY,
    OFFLINE,
    NOTREADY,
    TRANSDUCDISCON,
    HWDISCON,
    OFF,
    NULL;


    public static DeviceStatusReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("online".equals(codeString)) {
            return ONLINE;
        }
        if ("paused".equals(codeString)) {
            return PAUSED;
        }
        if ("standby".equals(codeString)) {
            return STANDBY;
        }
        if ("offline".equals(codeString)) {
            return OFFLINE;
        }
        if ("not-ready".equals(codeString)) {
            return NOTREADY;
        }
        if ("transduc-discon".equals(codeString)) {
            return TRANSDUCDISCON;
        }
        if ("hw-discon".equals(codeString)) {
            return HWDISCON;
        }
        if ("off".equals(codeString)) {
            return OFF;
        }
        throw new FHIRException("Unknown DeviceStatusReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ONLINE: {
                return "online";
            }
            case PAUSED: {
                return "paused";
            }
            case STANDBY: {
                return "standby";
            }
            case OFFLINE: {
                return "offline";
            }
            case NOTREADY: {
                return "not-ready";
            }
            case TRANSDUCDISCON: {
                return "transduc-discon";
            }
            case HWDISCON: {
                return "hw-discon";
            }
            case OFF: {
                return "off";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/device-status-reason";
    }

    public String getDefinition() {
        switch (this) {
            case ONLINE: {
                return "The device is off.";
            }
            case PAUSED: {
                return "The device is paused.";
            }
            case STANDBY: {
                return "The device is ready but not actively operating.";
            }
            case OFFLINE: {
                return "The device is offline.";
            }
            case NOTREADY: {
                return "The device is not ready.";
            }
            case TRANSDUCDISCON: {
                return "The device transducer is disconnected.";
            }
            case HWDISCON: {
                return "The device hardware is disconnected.";
            }
            case OFF: {
                return "The device is off.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ONLINE: {
                return "Online";
            }
            case PAUSED: {
                return "Paused";
            }
            case STANDBY: {
                return "Standby";
            }
            case OFFLINE: {
                return "Offline";
            }
            case NOTREADY: {
                return "Not Ready";
            }
            case TRANSDUCDISCON: {
                return "Transducer Disconnected";
            }
            case HWDISCON: {
                return "Hardware Disconnected";
            }
            case OFF: {
                return "Off";
            }
        }
        return "?";
    }
}

