/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="BodyStructure", profile="http://hl7.org/fhir/StructureDefinition/BodyStructure")
public class BodyStructure
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Bodystructure identifier", formalDefinition="Identifier for this instance of the anatomical structure.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this record is in active use", formalDefinition="Whether this body site is in active use.")
    protected BooleanType active;
    @Child(name="morphology", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of Structure", formalDefinition="The kind of structure being represented by the body structure at `BodyStructure.location`.  This can define both normal and abnormal morphologies.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodystructure-code")
    protected CodeableConcept morphology;
    @Child(name="location", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Body site", formalDefinition="The anatomical location or region of the specimen, lesion, or body structure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept location;
    @Child(name="locationQualifier", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Body site modifier", formalDefinition="Qualifier to refine the anatomical location.  These include qualifiers for laterality, relative location, directionality, number, and plane.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodystructure-relative-location")
    protected List<CodeableConcept> locationQualifier;
    @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text description", formalDefinition="A summary, charactarization or explanation of the body structure.")
    protected StringType description;
    @Child(name="image", type={Attachment.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Attached images", formalDefinition="Image or images used to identify a location.")
    protected List<Attachment> image;
    @Child(name="patient", type={Patient.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this is about", formalDefinition="The person to which the body site belongs.")
    protected Reference patient;
    protected Patient patientTarget;
    private static final long serialVersionUID = 1437500387L;
    @SearchParamDefinition(name="identifier", path="BodyStructure.identifier", description="Bodystructure identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="morphology", path="BodyStructure.morphology", description="Kind of Structure", type="token")
    public static final String SP_MORPHOLOGY = "morphology";
    public static final TokenClientParam MORPHOLOGY = new TokenClientParam("morphology");
    @SearchParamDefinition(name="patient", path="BodyStructure.patient", description="Who this is about", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("BodyStructure:patient").toLocked();
    @SearchParamDefinition(name="location", path="BodyStructure.location", description="Body site", type="token")
    public static final String SP_LOCATION = "location";
    public static final TokenClientParam LOCATION = new TokenClientParam("location");

    public BodyStructure() {
    }

    public BodyStructure(Reference patient) {
        this.patient = patient;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public BodyStructure setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public BodyStructure addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public BodyStructure setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public BodyStructure setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public CodeableConcept getMorphology() {
        if (this.morphology == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.morphology");
            }
            if (Configuration.doAutoCreate()) {
                this.morphology = new CodeableConcept();
            }
        }
        return this.morphology;
    }

    public boolean hasMorphology() {
        return this.morphology != null && !this.morphology.isEmpty();
    }

    public BodyStructure setMorphology(CodeableConcept value) {
        this.morphology = value;
        return this;
    }

    public CodeableConcept getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new CodeableConcept();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public BodyStructure setLocation(CodeableConcept value) {
        this.location = value;
        return this;
    }

    public List<CodeableConcept> getLocationQualifier() {
        if (this.locationQualifier == null) {
            this.locationQualifier = new ArrayList<CodeableConcept>();
        }
        return this.locationQualifier;
    }

    public BodyStructure setLocationQualifier(List<CodeableConcept> theLocationQualifier) {
        this.locationQualifier = theLocationQualifier;
        return this;
    }

    public boolean hasLocationQualifier() {
        if (this.locationQualifier == null) {
            return false;
        }
        for (CodeableConcept item : this.locationQualifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addLocationQualifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.locationQualifier == null) {
            this.locationQualifier = new ArrayList<CodeableConcept>();
        }
        this.locationQualifier.add(t);
        return t;
    }

    public BodyStructure addLocationQualifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.locationQualifier == null) {
            this.locationQualifier = new ArrayList<CodeableConcept>();
        }
        this.locationQualifier.add(t);
        return this;
    }

    public CodeableConcept getLocationQualifierFirstRep() {
        if (this.getLocationQualifier().isEmpty()) {
            this.addLocationQualifier();
        }
        return this.getLocationQualifier().get(0);
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public BodyStructure setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public BodyStructure setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Attachment> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        return this.image;
    }

    public BodyStructure setImage(List<Attachment> theImage) {
        this.image = theImage;
        return this;
    }

    public boolean hasImage() {
        if (this.image == null) {
            return false;
        }
        for (Attachment item : this.image) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addImage() {
        Attachment t = new Attachment();
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return t;
    }

    public BodyStructure addImage(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return this;
    }

    public Attachment getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            this.addImage();
        }
        return this.getImage().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public BodyStructure setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public BodyStructure setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for this instance of the anatomical structure.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("active", "boolean", "Whether this body site is in active use.", 0, 1, this.active));
        children.add(new Property(SP_MORPHOLOGY, "CodeableConcept", "The kind of structure being represented by the body structure at `BodyStructure.location`.  This can define both normal and abnormal morphologies.", 0, 1, this.morphology));
        children.add(new Property(SP_LOCATION, "CodeableConcept", "The anatomical location or region of the specimen, lesion, or body structure.", 0, 1, this.location));
        children.add(new Property("locationQualifier", "CodeableConcept", "Qualifier to refine the anatomical location.  These include qualifiers for laterality, relative location, directionality, number, and plane.", 0, Integer.MAX_VALUE, this.locationQualifier));
        children.add(new Property("description", "string", "A summary, charactarization or explanation of the body structure.", 0, 1, this.description));
        children.add(new Property("image", "Attachment", "Image or images used to identify a location.", 0, Integer.MAX_VALUE, this.image));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The person to which the body site belongs.", 0, 1, this.patient));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for this instance of the anatomical structure.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property("active", "boolean", "Whether this body site is in active use.", 0, 1, this.active);
            }
            case 1807231644: {
                return new Property(SP_MORPHOLOGY, "CodeableConcept", "The kind of structure being represented by the body structure at `BodyStructure.location`.  This can define both normal and abnormal morphologies.", 0, 1, this.morphology);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "CodeableConcept", "The anatomical location or region of the specimen, lesion, or body structure.", 0, 1, this.location);
            }
            case 433081461: {
                return new Property("locationQualifier", "CodeableConcept", "Qualifier to refine the anatomical location.  These include qualifiers for laterality, relative location, directionality, number, and plane.", 0, Integer.MAX_VALUE, this.locationQualifier);
            }
            case -1724546052: {
                return new Property("description", "string", "A summary, charactarization or explanation of the body structure.", 0, 1, this.description);
            }
            case 100313435: {
                return new Property("image", "Attachment", "Image or images used to identify a location.", 0, Integer.MAX_VALUE, this.image);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The person to which the body site belongs.", 0, 1, this.patient);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 1807231644: {
                Base[] baseArray;
                if (this.morphology == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.morphology;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.location;
                }
                return baseArray;
            }
            case 433081461: {
                return this.locationQualifier == null ? new Base[]{} : this.locationQualifier.toArray(new Base[this.locationQualifier.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case 100313435: {
                return this.image == null ? new Base[]{} : this.image.toArray(new Base[this.image.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.patient;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case 1807231644: {
                this.morphology = this.castToCodeableConcept(value);
                return value;
            }
            case 1901043637: {
                this.location = this.castToCodeableConcept(value);
                return value;
            }
            case 433081461: {
                this.getLocationQualifier().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 100313435: {
                this.getImage().add(this.castToAttachment(value));
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("active")) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_MORPHOLOGY)) {
            this.morphology = this.castToCodeableConcept(value);
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToCodeableConcept(value);
        } else if (name.equals("locationQualifier")) {
            this.getLocationQualifier().add(this.castToCodeableConcept(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("image")) {
            this.getImage().add(this.castToAttachment(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 1807231644: {
                return this.getMorphology();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 433081461: {
                return this.addLocationQualifier();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 100313435: {
                return this.addImage();
            }
            case -791418107: {
                return this.getPatient();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 1807231644: {
                return new String[]{"CodeableConcept"};
            }
            case 1901043637: {
                return new String[]{"CodeableConcept"};
            }
            case 433081461: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 100313435: {
                return new String[]{"Attachment"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("active")) {
            throw new FHIRException("Cannot call addChild on a primitive type BodyStructure.active");
        }
        if (name.equals(SP_MORPHOLOGY)) {
            this.morphology = new CodeableConcept();
            return this.morphology;
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new CodeableConcept();
            return this.location;
        }
        if (name.equals("locationQualifier")) {
            return this.addLocationQualifier();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type BodyStructure.description");
        }
        if (name.equals("image")) {
            return this.addImage();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BodyStructure";
    }

    @Override
    public BodyStructure copy() {
        BodyStructure dst = new BodyStructure();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.morphology = this.morphology == null ? null : this.morphology.copy();
        CodeableConcept codeableConcept = dst.location = this.location == null ? null : this.location.copy();
        if (this.locationQualifier != null) {
            dst.locationQualifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.locationQualifier) {
                dst.locationQualifier.add(codeableConcept2.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.image != null) {
            dst.image = new ArrayList<Attachment>();
            for (Attachment attachment : this.image) {
                dst.image.add(attachment.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        return dst;
    }

    protected BodyStructure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof BodyStructure)) {
            return false;
        }
        BodyStructure o = (BodyStructure)other_;
        return BodyStructure.compareDeep(this.identifier, o.identifier, true) && BodyStructure.compareDeep(this.active, o.active, true) && BodyStructure.compareDeep(this.morphology, o.morphology, true) && BodyStructure.compareDeep(this.location, o.location, true) && BodyStructure.compareDeep(this.locationQualifier, o.locationQualifier, true) && BodyStructure.compareDeep(this.description, o.description, true) && BodyStructure.compareDeep(this.image, o.image, true) && BodyStructure.compareDeep(this.patient, o.patient, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof BodyStructure)) {
            return false;
        }
        BodyStructure o = (BodyStructure)other_;
        return BodyStructure.compareValues(this.active, o.active, true) && BodyStructure.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.morphology, this.location, this.locationQualifier, this.description, this.image, this.patient});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.BodyStructure;
    }
}

