/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum StructureDefinitionKind {
    PRIMITIVETYPE,
    COMPLEXTYPE,
    RESOURCE,
    LOGICAL,
    NULL;


    public static StructureDefinitionKind fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("primitive-type".equals(codeString)) {
            return PRIMITIVETYPE;
        }
        if ("complex-type".equals(codeString)) {
            return COMPLEXTYPE;
        }
        if ("resource".equals(codeString)) {
            return RESOURCE;
        }
        if ("logical".equals(codeString)) {
            return LOGICAL;
        }
        throw new FHIRException("Unknown StructureDefinitionKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIMITIVETYPE: {
                return "primitive-type";
            }
            case COMPLEXTYPE: {
                return "complex-type";
            }
            case RESOURCE: {
                return "resource";
            }
            case LOGICAL: {
                return "logical";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/structure-definition-kind";
    }

    public String getDefinition() {
        switch (this) {
            case PRIMITIVETYPE: {
                return "A primitive type that has a value and an extension. These can be used throughout Resource and extension definitions. Only the base specification can define primitive types.";
            }
            case COMPLEXTYPE: {
                return "A  complex structure that defines a set of data elements. These can be used throughout Resource and extension definitions, and in logical models.";
            }
            case RESOURCE: {
                return "A resource defined by the FHIR specification.";
            }
            case LOGICAL: {
                return "A conceptual package of data that will be mapped to resources for implementation.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIMITIVETYPE: {
                return "Primitive Data Type";
            }
            case COMPLEXTYPE: {
                return "Complex Data Type";
            }
            case RESOURCE: {
                return "Resource";
            }
            case LOGICAL: {
                return "Logical Model";
            }
        }
        return "?";
    }
}

