/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResourceAggregationMode {
    CONTAINED,
    REFERENCED,
    BUNDLED,
    NULL;


    public static ResourceAggregationMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("contained".equals(codeString)) {
            return CONTAINED;
        }
        if ("referenced".equals(codeString)) {
            return REFERENCED;
        }
        if ("bundled".equals(codeString)) {
            return BUNDLED;
        }
        throw new FHIRException("Unknown ResourceAggregationMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CONTAINED: {
                return "contained";
            }
            case REFERENCED: {
                return "referenced";
            }
            case BUNDLED: {
                return "bundled";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/resource-aggregation-mode";
    }

    public String getDefinition() {
        switch (this) {
            case CONTAINED: {
                return "The reference is a local reference to a contained resource.";
            }
            case REFERENCED: {
                return "The reference to a resource that has to be resolved externally to the resource that includes the reference.";
            }
            case BUNDLED: {
                return "The resource the reference points to will be found in the same bundle as the resource that includes the reference.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CONTAINED: {
                return "Contained";
            }
            case REFERENCED: {
                return "Referenced";
            }
            case BUNDLED: {
                return "Bundled";
            }
        }
        return "?";
    }
}

