/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RelatedClaimRelationship {
    PRIOR,
    ASSOCIATED,
    NULL;


    public static RelatedClaimRelationship fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("prior".equals(codeString)) {
            return PRIOR;
        }
        if ("associated".equals(codeString)) {
            return ASSOCIATED;
        }
        throw new FHIRException("Unknown RelatedClaimRelationship code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIOR: {
                return "prior";
            }
            case ASSOCIATED: {
                return "associated";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-relatedclaimrelationship";
    }

    public String getDefinition() {
        switch (this) {
            case PRIOR: {
                return "A prior claim instance for the same intended suite of services.";
            }
            case ASSOCIATED: {
                return "A claim for a different suite of services which is related the suite claimed here.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIOR: {
                return "Prior Claim";
            }
            case ASSOCIATED: {
                return "Associated Claim";
            }
        }
        return "?";
    }
}

