/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QuestionnaireStatus {
    DRAFT,
    PUBLISHED,
    RETIRED,
    NULL;


    public static QuestionnaireStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("published".equals(codeString)) {
            return PUBLISHED;
        }
        if ("retired".equals(codeString)) {
            return RETIRED;
        }
        throw new FHIRException("Unknown QuestionnaireStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case PUBLISHED: {
                return "published";
            }
            case RETIRED: {
                return "retired";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/questionnaire-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "This Questionnaire is not ready for official use.";
            }
            case PUBLISHED: {
                return "This Questionnaire is ready for use.";
            }
            case RETIRED: {
                return "This Questionnaire should no longer be used to gather data.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case PUBLISHED: {
                return "Published";
            }
            case RETIRED: {
                return "Retired";
            }
        }
        return "?";
    }
}

