/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PublicationStatus {
    DRAFT,
    ACTIVE,
    RETIRED,
    UNKNOWN,
    NULL;


    public static PublicationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("retired".equals(codeString)) {
            return RETIRED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown PublicationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case RETIRED: {
                return "retired";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/publication-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "This resource is still under development and is not yet considered to be ready for normal use.";
            }
            case ACTIVE: {
                return "This resource is ready for normal use.";
            }
            case RETIRED: {
                return "This resource has been withdrawn or superseded and should no longer be used.";
            }
            case UNKNOWN: {
                return "The authoring system does not know which of the status values currently applies for this resource.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case RETIRED: {
                return "Retired";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

