/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PaymentStatus {
    PAID,
    CLEARED,
    NULL;


    public static PaymentStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("paid".equals(codeString)) {
            return PAID;
        }
        if ("cleared".equals(codeString)) {
            return CLEARED;
        }
        throw new FHIRException("Unknown PaymentStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PAID: {
                return "paid";
            }
            case CLEARED: {
                return "cleared";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/paymentstatus";
    }

    public String getDefinition() {
        switch (this) {
            case PAID: {
                return "The payment has been sent physically or electronically.";
            }
            case CLEARED: {
                return "The payment has been received by the payee.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PAID: {
                return "Paid";
            }
            case CLEARED: {
                return "Cleared";
            }
        }
        return "?";
    }
}

