/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasureType {
    PROCESS,
    OUTCOME,
    STRUCTURE,
    PATIENTREPORTEDOUTCOME,
    COMPOSITE,
    NULL;


    public static MeasureType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("process".equals(codeString)) {
            return PROCESS;
        }
        if ("outcome".equals(codeString)) {
            return OUTCOME;
        }
        if ("structure".equals(codeString)) {
            return STRUCTURE;
        }
        if ("patient-reported-outcome".equals(codeString)) {
            return PATIENTREPORTEDOUTCOME;
        }
        if ("composite".equals(codeString)) {
            return COMPOSITE;
        }
        throw new FHIRException("Unknown MeasureType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROCESS: {
                return "process";
            }
            case OUTCOME: {
                return "outcome";
            }
            case STRUCTURE: {
                return "structure";
            }
            case PATIENTREPORTEDOUTCOME: {
                return "patient-reported-outcome";
            }
            case COMPOSITE: {
                return "composite";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-type";
    }

    public String getDefinition() {
        switch (this) {
            case PROCESS: {
                return "A measure which focuses on a process which leads to a certain outcome, meaning that a scientific basis exists for believing that the process, when executed well, will increase the probability of achieving a desired outcome";
            }
            case OUTCOME: {
                return "A measure that indicates the result of the performance (or non-performance) of a function or process";
            }
            case STRUCTURE: {
                return "A measure that focuses on a health care provider's capacity, systems, and processes to provide high-quality care";
            }
            case PATIENTREPORTEDOUTCOME: {
                return "A measure that focuses on patient-reported information such as patient engagement or patient experience measures";
            }
            case COMPOSITE: {
                return "A measure that combines multiple component measures in to a single quality measure";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROCESS: {
                return "Process";
            }
            case OUTCOME: {
                return "Outcome";
            }
            case STRUCTURE: {
                return "Structure";
            }
            case PATIENTREPORTEDOUTCOME: {
                return "Patient Reported Outcome";
            }
            case COMPOSITE: {
                return "Composite";
            }
        }
        return "?";
    }
}

