/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MaritalStatus {
    U,
    NULL;


    public static MaritalStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("U".equals(codeString)) {
            return U;
        }
        throw new FHIRException("Unknown MaritalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case U: {
                return "U";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/marital-status";
    }

    public String getDefinition() {
        switch (this) {
            case U: {
                return "The person is not presently married. The marital history is not known or stated.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case U: {
                return "Unmarried";
            }
        }
        return "?";
    }
}

