/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LinkageType {
    SOURCE,
    ALTERNATE,
    HISTORICAL,
    NULL;


    public static LinkageType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("source".equals(codeString)) {
            return SOURCE;
        }
        if ("alternate".equals(codeString)) {
            return ALTERNATE;
        }
        if ("historical".equals(codeString)) {
            return HISTORICAL;
        }
        throw new FHIRException("Unknown LinkageType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SOURCE: {
                return "source";
            }
            case ALTERNATE: {
                return "alternate";
            }
            case HISTORICAL: {
                return "historical";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/linkage-type";
    }

    public String getDefinition() {
        switch (this) {
            case SOURCE: {
                return "The record represents the \"source of truth\" (from the perspective of this Linkage resource) for the underlying event/condition/etc.";
            }
            case ALTERNATE: {
                return "The record represents the alternative view of the underlying event/condition/etc.  The record may still be actively maintained, even though it is not considered to be the source of truth.";
            }
            case HISTORICAL: {
                return "The record represents an obsolete record of the underlyng event/condition/etc.  It is not expected to be actively maintained.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SOURCE: {
                return "Source of truth";
            }
            case ALTERNATE: {
                return "Alternate record";
            }
            case HISTORICAL: {
                return "Historical/obsolete record";
            }
        }
        return "?";
    }
}

