/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HistoryStatus {
    PARTIAL,
    COMPLETED,
    ENTEREDINERROR,
    HEALTHUNKNOWN,
    NULL;


    public static HistoryStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("partial".equals(codeString)) {
            return PARTIAL;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("health-unknown".equals(codeString)) {
            return HEALTHUNKNOWN;
        }
        throw new FHIRException("Unknown HistoryStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PARTIAL: {
                return "partial";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case HEALTHUNKNOWN: {
                return "health-unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/history-status";
    }

    public String getDefinition() {
        switch (this) {
            case PARTIAL: {
                return "Some health information is known and captured, but not complete - see notes for details.";
            }
            case COMPLETED: {
                return "All available related health information is captured as of the date (and possibly time) when the family member history was taken.";
            }
            case ENTEREDINERROR: {
                return "This instance should not have been part of this patient's medical record.";
            }
            case HEALTHUNKNOWN: {
                return "Health information for this individual is unavailable/unknown.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PARTIAL: {
                return "Partial";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in error";
            }
            case HEALTHUNKNOWN: {
                return "Health unknown";
            }
        }
        return "?";
    }
}

