/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractSubtype {
    DISCLOSURECA,
    DISCLOSUREUS,
    NULL;


    public static ContractSubtype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("disclosure-ca".equals(codeString)) {
            return DISCLOSURECA;
        }
        if ("disclosure-us".equals(codeString)) {
            return DISCLOSUREUS;
        }
        throw new FHIRException("Unknown ContractSubtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DISCLOSURECA: {
                return "disclosure-ca";
            }
            case DISCLOSUREUS: {
                return "disclosure-us";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contractsubtypecodes";
    }

    public String getDefinition() {
        switch (this) {
            case DISCLOSURECA: {
                return "Canadian health information displosure policy.";
            }
            case DISCLOSUREUS: {
                return "United States health information displosure policy.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DISCLOSURECA: {
                return "Disclosure-CA";
            }
            case DISCLOSUREUS: {
                return "Disclosure-US";
            }
        }
        return "?";
    }
}

