/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConceptmapUnmappedMode {
    PROVIDED,
    FIXED,
    OTHERMAP,
    NULL;


    public static ConceptmapUnmappedMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("provided".equals(codeString)) {
            return PROVIDED;
        }
        if ("fixed".equals(codeString)) {
            return FIXED;
        }
        if ("other-map".equals(codeString)) {
            return OTHERMAP;
        }
        throw new FHIRException("Unknown ConceptmapUnmappedMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROVIDED: {
                return "provided";
            }
            case FIXED: {
                return "fixed";
            }
            case OTHERMAP: {
                return "other-map";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/conceptmap-unmapped-mode";
    }

    public String getDefinition() {
        switch (this) {
            case PROVIDED: {
                return "Use the code as provided in the $translate request";
            }
            case FIXED: {
                return "Use the code explicitly provided in the group.unmapped";
            }
            case OTHERMAP: {
                return "Use the map identified by the canonical URL in URL";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROVIDED: {
                return "Provided Code";
            }
            case FIXED: {
                return "Fixed Code";
            }
            case OTHERMAP: {
                return "Other Map";
            }
        }
        return "?";
    }
}

