/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimSubtype {
    ORTHO,
    EMERGENCY,
    NULL;


    public static ClaimSubtype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ortho".equals(codeString)) {
            return ORTHO;
        }
        if ("emergency".equals(codeString)) {
            return EMERGENCY;
        }
        throw new FHIRException("Unknown ClaimSubtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ORTHO: {
                return "ortho";
            }
            case EMERGENCY: {
                return "emergency";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-claimsubtype";
    }

    public String getDefinition() {
        switch (this) {
            case ORTHO: {
                return "A claim for Orthodontic Services.";
            }
            case EMERGENCY: {
                return "A claim for emergency services.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ORTHO: {
                return "Orthodontic Claim";
            }
            case EMERGENCY: {
                return "Emergency Claim";
            }
        }
        return "?";
    }
}

