/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogItemRelationType {
    PKGCONTAINS,
    PKGISCONTAINEDIN,
    CONTAINSSBST,
    COMBINESWITH,
    REQUIRES,
    NULL;


    public static CatalogItemRelationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("pkg-contains".equals(codeString)) {
            return PKGCONTAINS;
        }
        if ("pkg-is-contained-in".equals(codeString)) {
            return PKGISCONTAINEDIN;
        }
        if ("contains-sbst".equals(codeString)) {
            return CONTAINSSBST;
        }
        if ("combines-with".equals(codeString)) {
            return COMBINESWITH;
        }
        if ("requires".equals(codeString)) {
            return REQUIRES;
        }
        throw new FHIRException("Unknown CatalogItemRelationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PKGCONTAINS: {
                return "pkg-contains";
            }
            case PKGISCONTAINEDIN: {
                return "pkg-is-contained-in";
            }
            case CONTAINSSBST: {
                return "contains-sbst";
            }
            case COMBINESWITH: {
                return "combines-with";
            }
            case REQUIRES: {
                return "requires";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalog-item-relation-type";
    }

    public String getDefinition() {
        switch (this) {
            case PKGCONTAINS: {
                return "The entry is a package that contains the related entry";
            }
            case PKGISCONTAINEDIN: {
                return "The entry is contained in the related entry";
            }
            case CONTAINSSBST: {
                return "The entry contains the related entry as a substance";
            }
            case COMBINESWITH: {
                return "The entry combines with the related entry";
            }
            case REQUIRES: {
                return "The entry requires the related entry for use";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PKGCONTAINS: {
                return "Package Contains";
            }
            case PKGISCONTAINEDIN: {
                return "Is contained in Package";
            }
            case CONTAINSSBST: {
                return "Contains Substance";
            }
            case COMBINESWITH: {
                return "Combines with";
            }
            case REQUIRES: {
                return "Requires";
            }
        }
        return "?";
    }
}

