/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogContentType {
    SINGLESUBMISSION,
    RESUBMISSION,
    FULLCATALOG,
    CATALOGUPDATE,
    CATALOGRESPONSE,
    NULL;


    public static CatalogContentType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("single-submission".equals(codeString)) {
            return SINGLESUBMISSION;
        }
        if ("resubmission".equals(codeString)) {
            return RESUBMISSION;
        }
        if ("full-catalog".equals(codeString)) {
            return FULLCATALOG;
        }
        if ("catalog-update".equals(codeString)) {
            return CATALOGUPDATE;
        }
        if ("catalog-response".equals(codeString)) {
            return CATALOGRESPONSE;
        }
        throw new FHIRException("Unknown CatalogContentType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SINGLESUBMISSION: {
                return "single-submission";
            }
            case RESUBMISSION: {
                return "resubmission";
            }
            case FULLCATALOG: {
                return "full-catalog";
            }
            case CATALOGUPDATE: {
                return "catalog-update";
            }
            case CATALOGRESPONSE: {
                return "catalog-response";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalog-content-type";
    }

    public String getDefinition() {
        switch (this) {
            case SINGLESUBMISSION: {
                return "This is a product submission";
            }
            case RESUBMISSION: {
                return "This is a resubmission of a previously submitted item";
            }
            case FULLCATALOG: {
                return "This is a full catalog transfer";
            }
            case CATALOGUPDATE: {
                return "This is a differential update";
            }
            case CATALOGRESPONSE: {
                return "This is a response to a request for catalog information";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SINGLESUBMISSION: {
                return "Submission";
            }
            case RESUBMISSION: {
                return "Resubmission";
            }
            case FULLCATALOG: {
                return "Full Catalog";
            }
            case CATALOGUPDATE: {
                return "Update";
            }
            case CATALOGRESPONSE: {
                return "Response";
            }
        }
        return "?";
    }
}

