/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum BenefitTerm {
    ANNUAL,
    DAY,
    LIFETIME,
    NULL;


    public static BenefitTerm fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("annual".equals(codeString)) {
            return ANNUAL;
        }
        if ("day".equals(codeString)) {
            return DAY;
        }
        if ("lifetime".equals(codeString)) {
            return LIFETIME;
        }
        throw new FHIRException("Unknown BenefitTerm code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ANNUAL: {
                return "annual";
            }
            case DAY: {
                return "day";
            }
            case LIFETIME: {
                return "lifetime";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/benefit-term";
    }

    public String getDefinition() {
        switch (this) {
            case ANNUAL: {
                return "Annual, renewing on the anniversary";
            }
            case DAY: {
                return "Per day";
            }
            case LIFETIME: {
                return "For the total term, lifetime, of the policy or coverage";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ANNUAL: {
                return "Annual";
            }
            case DAY: {
                return "Day";
            }
            case LIFETIME: {
                return "Lifetime";
            }
        }
        return "?";
    }
}

