/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Base64BinaryType;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SampledData;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.utils.StructureMapUtilities;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="StructureMap", profile="http://hl7.org/fhir/Profile/StructureMap")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "copyright", "structure", "import", "group"})
public class StructureMap
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the structure map", formalDefinition="A formal identifier that is used to identify this structure map when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="purpose", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this structure map is defined", formalDefinition="Explaination of why this structure map is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the structure map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the structure map.")
    protected MarkdownType copyright;
    @Child(name="structure", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Structure Definition used by this map", formalDefinition="A structure definition used by this map. The structure definition may describe instances that are converted, or the instances that are produced.")
    protected List<StructureMapStructureComponent> structure;
    @Child(name="import", type={UriType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other maps used by this map (canonical URLs)", formalDefinition="Other maps used by this map (canonical URLs).")
    protected List<UriType> import_;
    @Child(name="group", type={}, order=5, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Named sections for reader convenience", formalDefinition="Organizes the mapping into managable chunks for human review/ease of maintenance.")
    protected List<StructureMapGroupComponent> group;
    private static final long serialVersionUID = 952506557L;
    @SearchParamDefinition(name="date", path="StructureMap.date", description="The structure map publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="StructureMap.identifier", description="External identifier for the structure map", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="StructureMap.jurisdiction", description="Intended jurisdiction for the structure map", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="StructureMap.name", description="Computationally friendly name of the structure map", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="description", path="StructureMap.description", description="The description of the structure map", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="publisher", path="StructureMap.publisher", description="Name of the publisher of the structure map", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="title", path="StructureMap.title", description="The human-friendly name of the structure map", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="StructureMap.version", description="The business version of the structure map", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="StructureMap.url", description="The uri that identifies the structure map", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="StructureMap.status", description="The current status of the structure map", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public StructureMap() {
    }

    public StructureMap(UriType url, StringType name, Enumeration<Enumerations.PublicationStatus> status) {
        this.url = url;
        this.name = name;
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public StructureMap setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public StructureMap setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public StructureMap setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public StructureMap addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public StructureMap setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public StructureMap setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public StructureMap setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public StructureMap setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public StructureMap setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public StructureMap setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public StructureMap setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public StructureMap setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public StructureMap setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public StructureMap setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public StructureMap setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public StructureMap setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public StructureMap setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public StructureMap setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public StructureMap setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public StructureMap addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public StructureMap setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public StructureMap setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public StructureMap setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public StructureMap addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public StructureMap setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public StructureMap addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public StructureMap setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public StructureMap setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureMap.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public StructureMap setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public StructureMap setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<StructureMapStructureComponent> getStructure() {
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructureComponent>();
        }
        return this.structure;
    }

    public StructureMap setStructure(List<StructureMapStructureComponent> theStructure) {
        this.structure = theStructure;
        return this;
    }

    public boolean hasStructure() {
        if (this.structure == null) {
            return false;
        }
        for (StructureMapStructureComponent item : this.structure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureMapStructureComponent addStructure() {
        StructureMapStructureComponent t = new StructureMapStructureComponent();
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructureComponent>();
        }
        this.structure.add(t);
        return t;
    }

    public StructureMap addStructure(StructureMapStructureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructureComponent>();
        }
        this.structure.add(t);
        return this;
    }

    public StructureMapStructureComponent getStructureFirstRep() {
        if (this.getStructure().isEmpty()) {
            this.addStructure();
        }
        return this.getStructure().get(0);
    }

    public List<UriType> getImport() {
        if (this.import_ == null) {
            this.import_ = new ArrayList<UriType>();
        }
        return this.import_;
    }

    public StructureMap setImport(List<UriType> theImport) {
        this.import_ = theImport;
        return this;
    }

    public boolean hasImport() {
        if (this.import_ == null) {
            return false;
        }
        for (UriType item : this.import_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addImportElement() {
        UriType t = new UriType();
        if (this.import_ == null) {
            this.import_ = new ArrayList<UriType>();
        }
        this.import_.add(t);
        return t;
    }

    public StructureMap addImport(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.import_ == null) {
            this.import_ = new ArrayList<UriType>();
        }
        this.import_.add(t);
        return this;
    }

    public boolean hasImport(String value) {
        if (this.import_ == null) {
            return false;
        }
        for (UriType v : this.import_) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StructureMapGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroupComponent>();
        }
        return this.group;
    }

    public StructureMap setGroup(List<StructureMapGroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (StructureMapGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureMapGroupComponent addGroup() {
        StructureMapGroupComponent t = new StructureMapGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public StructureMap addGroup(StructureMapGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public StructureMapGroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this structure map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure map is (or will be) published. The URL SHOULD include the major version of the structure map. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this structure map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the structure map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the structure map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the structure map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the structure map.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this structure map. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this structure map is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the structure map was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the structure map changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the structure map.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the structure map from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate structure map instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the structure map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explaination of why this structure map is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the structure map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the structure map.", 0, 1, this.copyright));
        children.add(new Property("structure", "", "A structure definition used by this map. The structure definition may describe instances that are converted, or the instances that are produced.", 0, Integer.MAX_VALUE, this.structure));
        children.add(new Property("import", "uri", "Other maps used by this map (canonical URLs).", 0, Integer.MAX_VALUE, this.import_));
        children.add(new Property("group", "", "Organizes the mapping into managable chunks for human review/ease of maintenance.", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this structure map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure map is (or will be) published. The URL SHOULD include the major version of the structure map. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this structure map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the structure map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the structure map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the structure map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the structure map.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this structure map. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this structure map is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the structure map was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the structure map changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the structure map.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the structure map from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate structure map instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the structure map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this structure map is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the structure map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the structure map.", 0, 1, this.copyright);
            }
            case 144518515: {
                return new Property("structure", "", "A structure definition used by this map. The structure definition may describe instances that are converted, or the instances that are produced.", 0, Integer.MAX_VALUE, this.structure);
            }
            case -1184795739: {
                return new Property("import", "uri", "Other maps used by this map (canonical URLs).", 0, Integer.MAX_VALUE, this.import_);
            }
            case 98629247: {
                return new Property("group", "", "Organizes the mapping into managable chunks for human review/ease of maintenance.", 0, Integer.MAX_VALUE, this.group);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 144518515: {
                return this.structure == null ? new Base[]{} : this.structure.toArray(new Base[this.structure.size()]);
            }
            case -1184795739: {
                return this.import_ == null ? new Base[]{} : this.import_.toArray(new Base[this.import_.size()]);
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 144518515: {
                this.getStructure().add((StructureMapStructureComponent)((Object)value));
                return value;
            }
            case -1184795739: {
                this.getImport().add(this.castToUri(value));
                return value;
            }
            case 98629247: {
                this.getGroup().add((StructureMapGroupComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("structure")) {
            this.getStructure().add((StructureMapStructureComponent)((Object)value));
        } else if (name.equals("import")) {
            this.getImport().add(this.castToUri(value));
        } else if (name.equals("group")) {
            this.getGroup().add((StructureMapGroupComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 144518515: {
                return this.addStructure();
            }
            case -1184795739: {
                return this.addImportElement();
            }
            case 98629247: {
                return this.addGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 144518515: {
                return new String[0];
            }
            case -1184795739: {
                return new String[]{"uri"};
            }
            case 98629247: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.copyright");
        }
        if (name.equals("structure")) {
            return this.addStructure();
        }
        if (name.equals("import")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureMap.import");
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "StructureMap";
    }

    @Override
    public StructureMap copy() {
        StructureMap dst = new StructureMap();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        MarkdownType markdownType2 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.structure != null) {
            dst.structure = new ArrayList<StructureMapStructureComponent>();
            for (StructureMapStructureComponent structureMapStructureComponent : this.structure) {
                dst.structure.add(structureMapStructureComponent.copy());
            }
        }
        if (this.import_ != null) {
            dst.import_ = new ArrayList<UriType>();
            for (UriType uriType2 : this.import_) {
                dst.import_.add(uriType2.copy());
            }
        }
        if (this.group != null) {
            dst.group = new ArrayList<StructureMapGroupComponent>();
            for (StructureMapGroupComponent structureMapGroupComponent : this.group) {
                dst.group.add(structureMapGroupComponent.copy());
            }
        }
        return dst;
    }

    protected StructureMap typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof StructureMap)) {
            return false;
        }
        StructureMap o = (StructureMap)other_;
        return StructureMap.compareDeep(this.identifier, o.identifier, true) && StructureMap.compareDeep(this.purpose, o.purpose, true) && StructureMap.compareDeep(this.copyright, o.copyright, true) && StructureMap.compareDeep(this.structure, o.structure, true) && StructureMap.compareDeep(this.import_, o.import_, true) && StructureMap.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof StructureMap)) {
            return false;
        }
        StructureMap o = (StructureMap)other_;
        return StructureMap.compareValues(this.purpose, o.purpose, true) && StructureMap.compareValues(this.copyright, o.copyright, true) && StructureMap.compareValues(this.import_, o.import_, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.purpose, this.copyright, this.structure, this.import_, this.group});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.StructureMap;
    }

    @Override
    public String toString() {
        return StructureMapUtilities.render(this);
    }

    @Block
    public static class StructureMapGroupRuleDependentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of a rule or group to apply", formalDefinition="Name of a rule or group to apply.")
        protected IdType name;
        @Child(name="variable", type={StringType.class}, order=2, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Variable to pass to the rule or group", formalDefinition="Variable to pass to the rule or group.")
        protected List<StringType> variable;
        private static final long serialVersionUID = 1021661591L;

        public StructureMapGroupRuleDependentComponent() {
        }

        public StructureMapGroupRuleDependentComponent(IdType name) {
            this.name = name;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleDependentComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupRuleDependentComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupRuleDependentComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public List<StringType> getVariable() {
            if (this.variable == null) {
                this.variable = new ArrayList<StringType>();
            }
            return this.variable;
        }

        public StructureMapGroupRuleDependentComponent setVariable(List<StringType> theVariable) {
            this.variable = theVariable;
            return this;
        }

        public boolean hasVariable() {
            if (this.variable == null) {
                return false;
            }
            for (StringType item : this.variable) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addVariableElement() {
            StringType t = new StringType();
            if (this.variable == null) {
                this.variable = new ArrayList<StringType>();
            }
            this.variable.add(t);
            return t;
        }

        public StructureMapGroupRuleDependentComponent addVariable(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.variable == null) {
                this.variable = new ArrayList<StringType>();
            }
            this.variable.add(t);
            return this;
        }

        public boolean hasVariable(String value) {
            if (this.variable == null) {
                return false;
            }
            for (StringType v : this.variable) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(StructureMap.SP_NAME, "id", "Name of a rule or group to apply.", 0, 1, this.name));
            children.add(new Property("variable", "string", "Variable to pass to the rule or group.", 0, Integer.MAX_VALUE, this.variable));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(StructureMap.SP_NAME, "id", "Name of a rule or group to apply.", 0, 1, this.name);
                }
                case -1249586564: {
                    return new Property("variable", "string", "Variable to pass to the rule or group.", 0, Integer.MAX_VALUE, this.variable);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    return this.variable == null ? new Base[]{} : this.variable.toArray(new Base[this.variable.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    return value;
                }
                case -1249586564: {
                    this.getVariable().add(this.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("variable")) {
                this.getVariable().add(this.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1249586564: {
                    return this.addVariableElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"id"};
                }
                case -1249586564: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("variable")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.variable");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleDependentComponent copy() {
            StructureMapGroupRuleDependentComponent dst = new StructureMapGroupRuleDependentComponent();
            this.copyValues(dst);
            IdType idType = dst.name = this.name == null ? null : this.name.copy();
            if (this.variable != null) {
                dst.variable = new ArrayList<StringType>();
                for (StringType i : this.variable) {
                    dst.variable.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleDependentComponent)) {
                return false;
            }
            StructureMapGroupRuleDependentComponent o = (StructureMapGroupRuleDependentComponent)other_;
            return StructureMapGroupRuleDependentComponent.compareDeep(this.name, o.name, true) && StructureMapGroupRuleDependentComponent.compareDeep(this.variable, o.variable, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleDependentComponent)) {
                return false;
            }
            StructureMapGroupRuleDependentComponent o = (StructureMapGroupRuleDependentComponent)other_;
            return StructureMapGroupRuleDependentComponent.compareValues(this.name, o.name, true) && StructureMapGroupRuleDependentComponent.compareValues(this.variable, o.variable, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.variable});
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.dependent";
        }
    }

    @Block
    public static class StructureMapGroupRuleTargetParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={IdType.class, StringType.class, BooleanType.class, IntegerType.class, DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Parameter value - variable or literal", formalDefinition="Parameter value - variable or literal.")
        protected Type value;
        private static final long serialVersionUID = -732981989L;

        public StructureMapGroupRuleTargetParameterComponent() {
        }

        public StructureMapGroupRuleTargetParameterComponent(Type value) {
            this.value = value;
        }

        public Type getValue() {
            return this.value;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public StructureMapGroupRuleTargetParameterComponent setValue(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof IdType || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof DecimalType)) {
                throw new FHIRFormatError("Not the right type for StructureMap.group.rule.target.parameter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1410166417: {
                    return new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "id|string|boolean|integer|decimal", "Parameter value - variable or literal.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("value[x]")) {
                return super.setProperty(name, value);
            }
            this.value = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"id", "string", "boolean", "integer", "decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleTargetParameterComponent copy() {
            StructureMapGroupRuleTargetParameterComponent dst = new StructureMapGroupRuleTargetParameterComponent();
            this.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleTargetParameterComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetParameterComponent o = (StructureMapGroupRuleTargetParameterComponent)other_;
            return StructureMapGroupRuleTargetParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleTargetParameterComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetParameterComponent o = (StructureMapGroupRuleTargetParameterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value});
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.target.parameter";
        }

        public String toString() {
            return this.value == null ? "null!" : this.value.toString();
        }
    }

    @Block
    public static class StructureMapGroupRuleTargetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="context", type={IdType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type or variable this rule applies to", formalDefinition="Type or variable this rule applies to.")
        protected IdType context;
        @Child(name="contextType", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="type | variable", formalDefinition="How to interpret the context.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/map-context-type")
        protected Enumeration<StructureMapContextType> contextType;
        @Child(name="element", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Field to create in the context", formalDefinition="Field to create in the context.")
        protected StringType element;
        @Child(name="variable", type={IdType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Named context for field, if desired, and a field is specified", formalDefinition="Named context for field, if desired, and a field is specified.")
        protected IdType variable;
        @Child(name="listMode", type={CodeType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="first | share | last | collate", formalDefinition="If field is a list, how to manage the list.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/map-target-list-mode")
        protected List<Enumeration<StructureMapTargetListMode>> listMode;
        @Child(name="listRuleId", type={IdType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Internal rule reference for shared list items", formalDefinition="Internal rule reference for shared list items.")
        protected IdType listRuleId;
        @Child(name="transform", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="create | copy +", formalDefinition="How the data is copied / created.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/map-transform")
        protected Enumeration<StructureMapTransform> transform;
        @Child(name="parameter", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Parameters to the transform", formalDefinition="Parameters to the transform.")
        protected List<StructureMapGroupRuleTargetParameterComponent> parameter;
        private static final long serialVersionUID = -1441766429L;

        public IdType getContextElement() {
            if (this.context == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.context");
                }
                if (Configuration.doAutoCreate()) {
                    this.context = new IdType();
                }
            }
            return this.context;
        }

        public boolean hasContextElement() {
            return this.context != null && !this.context.isEmpty();
        }

        public boolean hasContext() {
            return this.context != null && !this.context.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setContextElement(IdType value) {
            this.context = value;
            return this;
        }

        public String getContext() {
            return this.context == null ? null : this.context.getValue();
        }

        public StructureMapGroupRuleTargetComponent setContext(String value) {
            if (Utilities.noString((String)value)) {
                this.context = null;
            } else {
                if (this.context == null) {
                    this.context = new IdType();
                }
                this.context.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapContextType> getContextTypeElement() {
            if (this.contextType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.contextType");
                }
                if (Configuration.doAutoCreate()) {
                    this.contextType = new Enumeration<StructureMapContextType>(new StructureMapContextTypeEnumFactory());
                }
            }
            return this.contextType;
        }

        public boolean hasContextTypeElement() {
            return this.contextType != null && !this.contextType.isEmpty();
        }

        public boolean hasContextType() {
            return this.contextType != null && !this.contextType.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setContextTypeElement(Enumeration<StructureMapContextType> value) {
            this.contextType = value;
            return this;
        }

        public StructureMapContextType getContextType() {
            return this.contextType == null ? null : (StructureMapContextType)((Object)this.contextType.getValue());
        }

        public StructureMapGroupRuleTargetComponent setContextType(StructureMapContextType value) {
            if (value == null) {
                this.contextType = null;
            } else {
                if (this.contextType == null) {
                    this.contextType = new Enumeration<StructureMapContextType>(new StructureMapContextTypeEnumFactory());
                }
                this.contextType.setValue((Object)value);
            }
            return this;
        }

        public StringType getElementElement() {
            if (this.element == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.element");
                }
                if (Configuration.doAutoCreate()) {
                    this.element = new StringType();
                }
            }
            return this.element;
        }

        public boolean hasElementElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public boolean hasElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setElementElement(StringType value) {
            this.element = value;
            return this;
        }

        public String getElement() {
            return this.element == null ? null : (String)this.element.getValue();
        }

        public StructureMapGroupRuleTargetComponent setElement(String value) {
            if (Utilities.noString((String)value)) {
                this.element = null;
            } else {
                if (this.element == null) {
                    this.element = new StringType();
                }
                this.element.setValue(value);
            }
            return this;
        }

        public IdType getVariableElement() {
            if (this.variable == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.variable");
                }
                if (Configuration.doAutoCreate()) {
                    this.variable = new IdType();
                }
            }
            return this.variable;
        }

        public boolean hasVariableElement() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public boolean hasVariable() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setVariableElement(IdType value) {
            this.variable = value;
            return this;
        }

        public String getVariable() {
            return this.variable == null ? null : this.variable.getValue();
        }

        public StructureMapGroupRuleTargetComponent setVariable(String value) {
            if (Utilities.noString((String)value)) {
                this.variable = null;
            } else {
                if (this.variable == null) {
                    this.variable = new IdType();
                }
                this.variable.setValue(value);
            }
            return this;
        }

        public List<Enumeration<StructureMapTargetListMode>> getListMode() {
            if (this.listMode == null) {
                this.listMode = new ArrayList<Enumeration<StructureMapTargetListMode>>();
            }
            return this.listMode;
        }

        public StructureMapGroupRuleTargetComponent setListMode(List<Enumeration<StructureMapTargetListMode>> theListMode) {
            this.listMode = theListMode;
            return this;
        }

        public boolean hasListMode() {
            if (this.listMode == null) {
                return false;
            }
            for (Enumeration<StructureMapTargetListMode> item : this.listMode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<StructureMapTargetListMode> addListModeElement() {
            Enumeration<StructureMapTargetListMode> t = new Enumeration<StructureMapTargetListMode>(new StructureMapTargetListModeEnumFactory());
            if (this.listMode == null) {
                this.listMode = new ArrayList<Enumeration<StructureMapTargetListMode>>();
            }
            this.listMode.add(t);
            return t;
        }

        public StructureMapGroupRuleTargetComponent addListMode(StructureMapTargetListMode value) {
            Enumeration<StructureMapTargetListMode> t = new Enumeration<StructureMapTargetListMode>(new StructureMapTargetListModeEnumFactory());
            t.setValue((Object)value);
            if (this.listMode == null) {
                this.listMode = new ArrayList<Enumeration<StructureMapTargetListMode>>();
            }
            this.listMode.add(t);
            return this;
        }

        public boolean hasListMode(StructureMapTargetListMode value) {
            if (this.listMode == null) {
                return false;
            }
            for (Enumeration<StructureMapTargetListMode> v : this.listMode) {
                if (!((StructureMapTargetListMode)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public IdType getListRuleIdElement() {
            if (this.listRuleId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.listRuleId");
                }
                if (Configuration.doAutoCreate()) {
                    this.listRuleId = new IdType();
                }
            }
            return this.listRuleId;
        }

        public boolean hasListRuleIdElement() {
            return this.listRuleId != null && !this.listRuleId.isEmpty();
        }

        public boolean hasListRuleId() {
            return this.listRuleId != null && !this.listRuleId.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setListRuleIdElement(IdType value) {
            this.listRuleId = value;
            return this;
        }

        public String getListRuleId() {
            return this.listRuleId == null ? null : this.listRuleId.getValue();
        }

        public StructureMapGroupRuleTargetComponent setListRuleId(String value) {
            if (Utilities.noString((String)value)) {
                this.listRuleId = null;
            } else {
                if (this.listRuleId == null) {
                    this.listRuleId = new IdType();
                }
                this.listRuleId.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapTransform> getTransformElement() {
            if (this.transform == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleTargetComponent.transform");
                }
                if (Configuration.doAutoCreate()) {
                    this.transform = new Enumeration<StructureMapTransform>(new StructureMapTransformEnumFactory());
                }
            }
            return this.transform;
        }

        public boolean hasTransformElement() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public boolean hasTransform() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public StructureMapGroupRuleTargetComponent setTransformElement(Enumeration<StructureMapTransform> value) {
            this.transform = value;
            return this;
        }

        public StructureMapTransform getTransform() {
            return this.transform == null ? null : (StructureMapTransform)((Object)this.transform.getValue());
        }

        public StructureMapGroupRuleTargetComponent setTransform(StructureMapTransform value) {
            if (value == null) {
                this.transform = null;
            } else {
                if (this.transform == null) {
                    this.transform = new Enumeration<StructureMapTransform>(new StructureMapTransformEnumFactory());
                }
                this.transform.setValue((Object)value);
            }
            return this;
        }

        public List<StructureMapGroupRuleTargetParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
            }
            return this.parameter;
        }

        public StructureMapGroupRuleTargetComponent setParameter(List<StructureMapGroupRuleTargetParameterComponent> theParameter) {
            this.parameter = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (StructureMapGroupRuleTargetParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleTargetParameterComponent addParameter() {
            StructureMapGroupRuleTargetParameterComponent t = new StructureMapGroupRuleTargetParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public StructureMapGroupRuleTargetComponent addParameter(StructureMapGroupRuleTargetParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        public StructureMapGroupRuleTargetParameterComponent getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                this.addParameter();
            }
            return this.getParameter().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("context", "id", "Type or variable this rule applies to.", 0, 1, this.context));
            children.add(new Property("contextType", "code", "How to interpret the context.", 0, 1, this.contextType));
            children.add(new Property("element", "string", "Field to create in the context.", 0, 1, this.element));
            children.add(new Property("variable", "id", "Named context for field, if desired, and a field is specified.", 0, 1, this.variable));
            children.add(new Property("listMode", "code", "If field is a list, how to manage the list.", 0, Integer.MAX_VALUE, this.listMode));
            children.add(new Property("listRuleId", "id", "Internal rule reference for shared list items.", 0, 1, this.listRuleId));
            children.add(new Property("transform", "code", "How the data is copied / created.", 0, 1, this.transform));
            children.add(new Property("parameter", "", "Parameters to the transform.", 0, Integer.MAX_VALUE, this.parameter));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 951530927: {
                    return new Property("context", "id", "Type or variable this rule applies to.", 0, 1, this.context);
                }
                case -102839927: {
                    return new Property("contextType", "code", "How to interpret the context.", 0, 1, this.contextType);
                }
                case -1662836996: {
                    return new Property("element", "string", "Field to create in the context.", 0, 1, this.element);
                }
                case -1249586564: {
                    return new Property("variable", "id", "Named context for field, if desired, and a field is specified.", 0, 1, this.variable);
                }
                case 1345445729: {
                    return new Property("listMode", "code", "If field is a list, how to manage the list.", 0, Integer.MAX_VALUE, this.listMode);
                }
                case 337117045: {
                    return new Property("listRuleId", "id", "Internal rule reference for shared list items.", 0, 1, this.listRuleId);
                }
                case 1052666732: {
                    return new Property("transform", "code", "How the data is copied / created.", 0, 1, this.transform);
                }
                case 1954460585: {
                    return new Property("parameter", "", "Parameters to the transform.", 0, Integer.MAX_VALUE, this.parameter);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    Base[] baseArray;
                    if (this.context == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.context;
                    }
                    return baseArray;
                }
                case -102839927: {
                    Base[] baseArray;
                    if (this.contextType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.contextType;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    Base[] baseArray;
                    if (this.element == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.element;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    Base[] baseArray;
                    if (this.variable == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.variable;
                    }
                    return baseArray;
                }
                case 1345445729: {
                    return this.listMode == null ? new Base[]{} : this.listMode.toArray(new Base[this.listMode.size()]);
                }
                case 337117045: {
                    Base[] baseArray;
                    if (this.listRuleId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.listRuleId;
                    }
                    return baseArray;
                }
                case 1052666732: {
                    Base[] baseArray;
                    if (this.transform == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.transform;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    this.context = this.castToId(value);
                    return value;
                }
                case -102839927: {
                    value = new StructureMapContextTypeEnumFactory().fromType(this.castToCode(value));
                    this.contextType = value;
                    return value;
                }
                case -1662836996: {
                    this.element = this.castToString(value);
                    return value;
                }
                case -1249586564: {
                    this.variable = this.castToId(value);
                    return value;
                }
                case 1345445729: {
                    value = new StructureMapTargetListModeEnumFactory().fromType(this.castToCode(value));
                    this.getListMode().add(value);
                    return value;
                }
                case 337117045: {
                    this.listRuleId = this.castToId(value);
                    return value;
                }
                case 1052666732: {
                    value = new StructureMapTransformEnumFactory().fromType(this.castToCode(value));
                    this.transform = value;
                    return value;
                }
                case 1954460585: {
                    this.getParameter().add((StructureMapGroupRuleTargetParameterComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("context")) {
                this.context = this.castToId(value);
            } else if (name.equals("contextType")) {
                value = new StructureMapContextTypeEnumFactory().fromType(this.castToCode(value));
                this.contextType = value;
            } else if (name.equals("element")) {
                this.element = this.castToString(value);
            } else if (name.equals("variable")) {
                this.variable = this.castToId(value);
            } else if (name.equals("listMode")) {
                value = new StructureMapTargetListModeEnumFactory().fromType(this.castToCode(value));
                this.getListMode().add(value);
            } else if (name.equals("listRuleId")) {
                this.listRuleId = this.castToId(value);
            } else if (name.equals("transform")) {
                value = new StructureMapTransformEnumFactory().fromType(this.castToCode(value));
                this.transform = value;
            } else if (name.equals("parameter")) {
                this.getParameter().add((StructureMapGroupRuleTargetParameterComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    return this.getContextElement();
                }
                case -102839927: {
                    return this.getContextTypeElement();
                }
                case -1662836996: {
                    return this.getElementElement();
                }
                case -1249586564: {
                    return this.getVariableElement();
                }
                case 1345445729: {
                    return this.addListModeElement();
                }
                case 337117045: {
                    return this.getListRuleIdElement();
                }
                case 1052666732: {
                    return this.getTransformElement();
                }
                case 1954460585: {
                    return this.addParameter();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    return new String[]{"id"};
                }
                case -102839927: {
                    return new String[]{"code"};
                }
                case -1662836996: {
                    return new String[]{"string"};
                }
                case -1249586564: {
                    return new String[]{"id"};
                }
                case 1345445729: {
                    return new String[]{"code"};
                }
                case 337117045: {
                    return new String[]{"id"};
                }
                case 1052666732: {
                    return new String[]{"code"};
                }
                case 1954460585: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("context")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.context");
            }
            if (name.equals("contextType")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.contextType");
            }
            if (name.equals("element")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.element");
            }
            if (name.equals("variable")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.variable");
            }
            if (name.equals("listMode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.listMode");
            }
            if (name.equals("listRuleId")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.listRuleId");
            }
            if (name.equals("transform")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.transform");
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleTargetComponent copy() {
            StructureMapGroupRuleTargetComponent dst = new StructureMapGroupRuleTargetComponent();
            this.copyValues(dst);
            dst.context = this.context == null ? null : this.context.copy();
            dst.contextType = this.contextType == null ? null : this.contextType.copy();
            dst.element = this.element == null ? null : this.element.copy();
            IdType idType = dst.variable = this.variable == null ? null : this.variable.copy();
            if (this.listMode != null) {
                dst.listMode = new ArrayList<Enumeration<StructureMapTargetListMode>>();
                for (Enumeration<StructureMapTargetListMode> enumeration : this.listMode) {
                    dst.listMode.add((Enumeration<StructureMapTargetListMode>)enumeration.copy());
                }
            }
            dst.listRuleId = this.listRuleId == null ? null : this.listRuleId.copy();
            Enumeration<StructureMapTransform> enumeration = dst.transform = this.transform == null ? null : this.transform.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<StructureMapGroupRuleTargetParameterComponent>();
                for (StructureMapGroupRuleTargetParameterComponent structureMapGroupRuleTargetParameterComponent : this.parameter) {
                    dst.parameter.add(structureMapGroupRuleTargetParameterComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleTargetComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetComponent o = (StructureMapGroupRuleTargetComponent)other_;
            return StructureMapGroupRuleTargetComponent.compareDeep(this.context, o.context, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.contextType, o.contextType, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.element, o.element, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.variable, o.variable, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.listMode, o.listMode, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.listRuleId, o.listRuleId, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.transform, o.transform, true) && StructureMapGroupRuleTargetComponent.compareDeep(this.parameter, o.parameter, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleTargetComponent)) {
                return false;
            }
            StructureMapGroupRuleTargetComponent o = (StructureMapGroupRuleTargetComponent)other_;
            return StructureMapGroupRuleTargetComponent.compareValues(this.context, o.context, true) && StructureMapGroupRuleTargetComponent.compareValues(this.contextType, o.contextType, true) && StructureMapGroupRuleTargetComponent.compareValues(this.element, o.element, true) && StructureMapGroupRuleTargetComponent.compareValues(this.variable, o.variable, true) && StructureMapGroupRuleTargetComponent.compareValues(this.listMode, o.listMode, true) && StructureMapGroupRuleTargetComponent.compareValues(this.listRuleId, o.listRuleId, true) && StructureMapGroupRuleTargetComponent.compareValues(this.transform, o.transform, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.context, this.contextType, this.element, this.variable, this.listMode, this.listRuleId, this.transform, this.parameter});
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.target";
        }

        public String toString() {
            return StructureMapUtilities.targetToString(this);
        }
    }

    @Block
    public static class StructureMapGroupRuleSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="context", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type or variable this rule applies to", formalDefinition="Type or variable this rule applies to.")
        protected IdType context;
        @Child(name="min", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specified minimum cardinality", formalDefinition="Specified minimum cardinality for the element. This is optional; if present, it acts an implicit check on the input content.")
        protected IntegerType min;
        @Child(name="max", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specified maximum cardinality (number or *)", formalDefinition="Specified maximum cardinality for the element - a number or a \"*\". This is optional; if present, it acts an implicit check on the input content (* just serves as documentation; it's the default value).")
        protected StringType max;
        @Child(name="type", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule only applies if source has this type", formalDefinition="Specified type for the element. This works as a condition on the mapping - use for polymorphic elements.")
        protected StringType type;
        @Child(name="defaultValue", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Default value if no value exists", formalDefinition="A value to use if there is no existing value in the source object.")
        protected Type defaultValue;
        @Child(name="element", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optional field for this source", formalDefinition="Optional field for this source.")
        protected StringType element;
        @Child(name="listMode", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="first | not_first | last | not_last | only_one", formalDefinition="How to handle the list mode for this element.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/map-source-list-mode")
        protected Enumeration<StructureMapSourceListMode> listMode;
        @Child(name="variable", type={IdType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Named context for field, if a field is specified", formalDefinition="Named context for field, if a field is specified.")
        protected IdType variable;
        @Child(name="condition", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath expression  - must be true or the rule does not apply", formalDefinition="FHIRPath expression  - must be true or the rule does not apply.")
        protected StringType condition;
        @Child(name="check", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath expression  - must be true or the mapping engine throws an error instead of completing", formalDefinition="FHIRPath expression  - must be true or the mapping engine throws an error instead of completing.")
        protected StringType check;
        private static final long serialVersionUID = 1893118862L;

        public StructureMapGroupRuleSourceComponent() {
        }

        public StructureMapGroupRuleSourceComponent(IdType context) {
            this.context = context;
        }

        public IdType getContextElement() {
            if (this.context == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.context");
                }
                if (Configuration.doAutoCreate()) {
                    this.context = new IdType();
                }
            }
            return this.context;
        }

        public boolean hasContextElement() {
            return this.context != null && !this.context.isEmpty();
        }

        public boolean hasContext() {
            return this.context != null && !this.context.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setContextElement(IdType value) {
            this.context = value;
            return this;
        }

        public String getContext() {
            return this.context == null ? null : this.context.getValue();
        }

        public StructureMapGroupRuleSourceComponent setContext(String value) {
            if (this.context == null) {
                this.context = new IdType();
            }
            this.context.setValue(value);
            return this;
        }

        public IntegerType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new IntegerType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setMinElement(IntegerType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public StructureMapGroupRuleSourceComponent setMin(int value) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public StructureMapGroupRuleSourceComponent setMax(String value) {
            if (Utilities.noString((String)value)) {
                this.max = null;
            } else {
                if (this.max == null) {
                    this.max = new StringType();
                }
                this.max.setValue(value);
            }
            return this;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public StructureMapGroupRuleSourceComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new StringType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public Type getDefaultValue() {
            return this.defaultValue;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null && !this.defaultValue.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setDefaultValue(Type value) {
            this.defaultValue = value;
            return this;
        }

        public StringType getElementElement() {
            if (this.element == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.element");
                }
                if (Configuration.doAutoCreate()) {
                    this.element = new StringType();
                }
            }
            return this.element;
        }

        public boolean hasElementElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public boolean hasElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setElementElement(StringType value) {
            this.element = value;
            return this;
        }

        public String getElement() {
            return this.element == null ? null : (String)this.element.getValue();
        }

        public StructureMapGroupRuleSourceComponent setElement(String value) {
            if (Utilities.noString((String)value)) {
                this.element = null;
            } else {
                if (this.element == null) {
                    this.element = new StringType();
                }
                this.element.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapSourceListMode> getListModeElement() {
            if (this.listMode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.listMode");
                }
                if (Configuration.doAutoCreate()) {
                    this.listMode = new Enumeration<StructureMapSourceListMode>(new StructureMapSourceListModeEnumFactory());
                }
            }
            return this.listMode;
        }

        public boolean hasListModeElement() {
            return this.listMode != null && !this.listMode.isEmpty();
        }

        public boolean hasListMode() {
            return this.listMode != null && !this.listMode.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setListModeElement(Enumeration<StructureMapSourceListMode> value) {
            this.listMode = value;
            return this;
        }

        public StructureMapSourceListMode getListMode() {
            return this.listMode == null ? null : (StructureMapSourceListMode)((Object)this.listMode.getValue());
        }

        public StructureMapGroupRuleSourceComponent setListMode(StructureMapSourceListMode value) {
            if (value == null) {
                this.listMode = null;
            } else {
                if (this.listMode == null) {
                    this.listMode = new Enumeration<StructureMapSourceListMode>(new StructureMapSourceListModeEnumFactory());
                }
                this.listMode.setValue((Object)value);
            }
            return this;
        }

        public IdType getVariableElement() {
            if (this.variable == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.variable");
                }
                if (Configuration.doAutoCreate()) {
                    this.variable = new IdType();
                }
            }
            return this.variable;
        }

        public boolean hasVariableElement() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public boolean hasVariable() {
            return this.variable != null && !this.variable.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setVariableElement(IdType value) {
            this.variable = value;
            return this;
        }

        public String getVariable() {
            return this.variable == null ? null : this.variable.getValue();
        }

        public StructureMapGroupRuleSourceComponent setVariable(String value) {
            if (Utilities.noString((String)value)) {
                this.variable = null;
            } else {
                if (this.variable == null) {
                    this.variable = new IdType();
                }
                this.variable.setValue(value);
            }
            return this;
        }

        public StringType getConditionElement() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new StringType();
                }
            }
            return this.condition;
        }

        public boolean hasConditionElement() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setConditionElement(StringType value) {
            this.condition = value;
            return this;
        }

        public String getCondition() {
            return this.condition == null ? null : (String)this.condition.getValue();
        }

        public StructureMapGroupRuleSourceComponent setCondition(String value) {
            if (Utilities.noString((String)value)) {
                this.condition = null;
            } else {
                if (this.condition == null) {
                    this.condition = new StringType();
                }
                this.condition.setValue(value);
            }
            return this;
        }

        public StringType getCheckElement() {
            if (this.check == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleSourceComponent.check");
                }
                if (Configuration.doAutoCreate()) {
                    this.check = new StringType();
                }
            }
            return this.check;
        }

        public boolean hasCheckElement() {
            return this.check != null && !this.check.isEmpty();
        }

        public boolean hasCheck() {
            return this.check != null && !this.check.isEmpty();
        }

        public StructureMapGroupRuleSourceComponent setCheckElement(StringType value) {
            this.check = value;
            return this;
        }

        public String getCheck() {
            return this.check == null ? null : (String)this.check.getValue();
        }

        public StructureMapGroupRuleSourceComponent setCheck(String value) {
            if (Utilities.noString((String)value)) {
                this.check = null;
            } else {
                if (this.check == null) {
                    this.check = new StringType();
                }
                this.check.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("context", "id", "Type or variable this rule applies to.", 0, 1, this.context));
            children.add(new Property("min", "integer", "Specified minimum cardinality for the element. This is optional; if present, it acts an implicit check on the input content.", 0, 1, this.min));
            children.add(new Property("max", "string", "Specified maximum cardinality for the element - a number or a \"*\". This is optional; if present, it acts an implicit check on the input content (* just serves as documentation; it's the default value).", 0, 1, this.max));
            children.add(new Property("type", "string", "Specified type for the element. This works as a condition on the mapping - use for polymorphic elements.", 0, 1, this.type));
            children.add(new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue));
            children.add(new Property("element", "string", "Optional field for this source.", 0, 1, this.element));
            children.add(new Property("listMode", "code", "How to handle the list mode for this element.", 0, 1, this.listMode));
            children.add(new Property("variable", "id", "Named context for field, if a field is specified.", 0, 1, this.variable));
            children.add(new Property("condition", "string", "FHIRPath expression  - must be true or the rule does not apply.", 0, 1, this.condition));
            children.add(new Property("check", "string", "FHIRPath expression  - must be true or the mapping engine throws an error instead of completing.", 0, 1, this.check));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 951530927: {
                    return new Property("context", "id", "Type or variable this rule applies to.", 0, 1, this.context);
                }
                case 108114: {
                    return new Property("min", "integer", "Specified minimum cardinality for the element. This is optional; if present, it acts an implicit check on the input content.", 0, 1, this.min);
                }
                case 107876: {
                    return new Property("max", "string", "Specified maximum cardinality for the element - a number or a \"*\". This is optional; if present, it acts an implicit check on the input content (* just serves as documentation; it's the default value).", 0, 1, this.max);
                }
                case 3575610: {
                    return new Property("type", "string", "Specified type for the element. This works as a condition on the mapping - use for polymorphic elements.", 0, 1, this.type);
                }
                case 587922128: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -659125328: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 1470297600: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 600437336: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 264593188: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 1044993469: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 1045010302: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 1220374379: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 2077989249: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -2059245333: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1801671663: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1801189522: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -325436225: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 587910138: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -737344154: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -320515103: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 1045494429: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 539117290: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 587916188: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 587916191: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 1045535627: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -611966428: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1851689217: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 2034820339: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -410434095: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -783616198: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -344740576: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -975393912: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1915078535: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -420255343: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1857379237: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1951495315: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1951489477: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1488914053: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -449641228: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case 509825768: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -302193638: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -754548089: {
                    return new Property("defaultValue[x]", "*", "A value to use if there is no existing value in the source object.", 0, 1, this.defaultValue);
                }
                case -1662836996: {
                    return new Property("element", "string", "Optional field for this source.", 0, 1, this.element);
                }
                case 1345445729: {
                    return new Property("listMode", "code", "How to handle the list mode for this element.", 0, 1, this.listMode);
                }
                case -1249586564: {
                    return new Property("variable", "id", "Named context for field, if a field is specified.", 0, 1, this.variable);
                }
                case -861311717: {
                    return new Property("condition", "string", "FHIRPath expression  - must be true or the rule does not apply.", 0, 1, this.condition);
                }
                case 94627080: {
                    return new Property("check", "string", "FHIRPath expression  - must be true or the mapping engine throws an error instead of completing.", 0, 1, this.check);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    Base[] baseArray;
                    if (this.context == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.context;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.max;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
                case -659125328: {
                    Base[] baseArray;
                    if (this.defaultValue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.defaultValue;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    Base[] baseArray;
                    if (this.element == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.element;
                    }
                    return baseArray;
                }
                case 1345445729: {
                    Base[] baseArray;
                    if (this.listMode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.listMode;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    Base[] baseArray;
                    if (this.variable == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.variable;
                    }
                    return baseArray;
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.condition;
                    }
                    return baseArray;
                }
                case 94627080: {
                    Base[] baseArray;
                    if (this.check == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.check;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    this.context = this.castToId(value);
                    return value;
                }
                case 108114: {
                    this.min = this.castToInteger(value);
                    return value;
                }
                case 107876: {
                    this.max = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToString(value);
                    return value;
                }
                case -659125328: {
                    this.defaultValue = this.castToType(value);
                    return value;
                }
                case -1662836996: {
                    this.element = this.castToString(value);
                    return value;
                }
                case 1345445729: {
                    value = new StructureMapSourceListModeEnumFactory().fromType(this.castToCode(value));
                    this.listMode = value;
                    return value;
                }
                case -1249586564: {
                    this.variable = this.castToId(value);
                    return value;
                }
                case -861311717: {
                    this.condition = this.castToString(value);
                    return value;
                }
                case 94627080: {
                    this.check = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("context")) {
                this.context = this.castToId(value);
            } else if (name.equals("min")) {
                this.min = this.castToInteger(value);
            } else if (name.equals("max")) {
                this.max = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToString(value);
            } else if (name.equals("defaultValue[x]")) {
                this.defaultValue = this.castToType(value);
            } else if (name.equals("element")) {
                this.element = this.castToString(value);
            } else if (name.equals("listMode")) {
                value = new StructureMapSourceListModeEnumFactory().fromType(this.castToCode(value));
                this.listMode = value;
            } else if (name.equals("variable")) {
                this.variable = this.castToId(value);
            } else if (name.equals("condition")) {
                this.condition = this.castToString(value);
            } else if (name.equals("check")) {
                this.check = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    return this.getContextElement();
                }
                case 108114: {
                    return this.getMinElement();
                }
                case 107876: {
                    return this.getMaxElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 587922128: {
                    return this.getDefaultValue();
                }
                case -659125328: {
                    return this.getDefaultValue();
                }
                case -1662836996: {
                    return this.getElementElement();
                }
                case 1345445729: {
                    return this.getListModeElement();
                }
                case -1249586564: {
                    return this.getVariableElement();
                }
                case -861311717: {
                    return this.getConditionElement();
                }
                case 94627080: {
                    return this.getCheckElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530927: {
                    return new String[]{"id"};
                }
                case 108114: {
                    return new String[]{"integer"};
                }
                case 107876: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"string"};
                }
                case -659125328: {
                    return new String[]{"*"};
                }
                case -1662836996: {
                    return new String[]{"string"};
                }
                case 1345445729: {
                    return new String[]{"code"};
                }
                case -1249586564: {
                    return new String[]{"id"};
                }
                case -861311717: {
                    return new String[]{"string"};
                }
                case 94627080: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("context")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.context");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.max");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.type");
            }
            if (name.equals("defaultValueBoolean")) {
                this.defaultValue = new BooleanType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueInteger")) {
                this.defaultValue = new IntegerType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueDecimal")) {
                this.defaultValue = new DecimalType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueBase64Binary")) {
                this.defaultValue = new Base64BinaryType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueInstant")) {
                this.defaultValue = new InstantType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueString")) {
                this.defaultValue = new StringType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueUri")) {
                this.defaultValue = new UriType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueDate")) {
                this.defaultValue = new DateType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueDateTime")) {
                this.defaultValue = new DateTimeType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueTime")) {
                this.defaultValue = new TimeType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueCode")) {
                this.defaultValue = new CodeType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueOid")) {
                this.defaultValue = new OidType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueId")) {
                this.defaultValue = new IdType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueUnsignedInt")) {
                this.defaultValue = new UnsignedIntType();
                return this.defaultValue;
            }
            if (name.equals("defaultValuePositiveInt")) {
                this.defaultValue = new PositiveIntType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueMarkdown")) {
                this.defaultValue = new MarkdownType();
                return this.defaultValue;
            }
            if (name.equals("defaultValueAnnotation")) {
                this.defaultValue = new Annotation();
                return this.defaultValue;
            }
            if (name.equals("defaultValueAttachment")) {
                this.defaultValue = new Attachment();
                return this.defaultValue;
            }
            if (name.equals("defaultValueIdentifier")) {
                this.defaultValue = new Identifier();
                return this.defaultValue;
            }
            if (name.equals("defaultValueCodeableConcept")) {
                this.defaultValue = new CodeableConcept();
                return this.defaultValue;
            }
            if (name.equals("defaultValueCoding")) {
                this.defaultValue = new Coding();
                return this.defaultValue;
            }
            if (name.equals("defaultValueQuantity")) {
                this.defaultValue = new Quantity();
                return this.defaultValue;
            }
            if (name.equals("defaultValueRange")) {
                this.defaultValue = new Range();
                return this.defaultValue;
            }
            if (name.equals("defaultValuePeriod")) {
                this.defaultValue = new Period();
                return this.defaultValue;
            }
            if (name.equals("defaultValueRatio")) {
                this.defaultValue = new Ratio();
                return this.defaultValue;
            }
            if (name.equals("defaultValueSampledData")) {
                this.defaultValue = new SampledData();
                return this.defaultValue;
            }
            if (name.equals("defaultValueSignature")) {
                this.defaultValue = new Signature();
                return this.defaultValue;
            }
            if (name.equals("defaultValueHumanName")) {
                this.defaultValue = new HumanName();
                return this.defaultValue;
            }
            if (name.equals("defaultValueAddress")) {
                this.defaultValue = new Address();
                return this.defaultValue;
            }
            if (name.equals("defaultValueContactPoint")) {
                this.defaultValue = new ContactPoint();
                return this.defaultValue;
            }
            if (name.equals("defaultValueTiming")) {
                this.defaultValue = new Timing();
                return this.defaultValue;
            }
            if (name.equals("defaultValueReference")) {
                this.defaultValue = new Reference();
                return this.defaultValue;
            }
            if (name.equals("defaultValueMeta")) {
                this.defaultValue = new Meta();
                return this.defaultValue;
            }
            if (name.equals("element")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.element");
            }
            if (name.equals("listMode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.listMode");
            }
            if (name.equals("variable")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.variable");
            }
            if (name.equals("condition")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.condition");
            }
            if (name.equals("check")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.check");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleSourceComponent copy() {
            StructureMapGroupRuleSourceComponent dst = new StructureMapGroupRuleSourceComponent();
            this.copyValues(dst);
            dst.context = this.context == null ? null : this.context.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.defaultValue = this.defaultValue == null ? null : this.defaultValue.copy();
            dst.element = this.element == null ? null : this.element.copy();
            dst.listMode = this.listMode == null ? null : this.listMode.copy();
            dst.variable = this.variable == null ? null : this.variable.copy();
            dst.condition = this.condition == null ? null : this.condition.copy();
            dst.check = this.check == null ? null : this.check.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleSourceComponent)) {
                return false;
            }
            StructureMapGroupRuleSourceComponent o = (StructureMapGroupRuleSourceComponent)other_;
            return StructureMapGroupRuleSourceComponent.compareDeep(this.context, o.context, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.min, o.min, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.max, o.max, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.type, o.type, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.defaultValue, o.defaultValue, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.element, o.element, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.listMode, o.listMode, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.variable, o.variable, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.condition, o.condition, true) && StructureMapGroupRuleSourceComponent.compareDeep(this.check, o.check, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleSourceComponent)) {
                return false;
            }
            StructureMapGroupRuleSourceComponent o = (StructureMapGroupRuleSourceComponent)other_;
            return StructureMapGroupRuleSourceComponent.compareValues(this.context, o.context, true) && StructureMapGroupRuleSourceComponent.compareValues(this.min, o.min, true) && StructureMapGroupRuleSourceComponent.compareValues(this.max, o.max, true) && StructureMapGroupRuleSourceComponent.compareValues(this.type, o.type, true) && StructureMapGroupRuleSourceComponent.compareValues(this.element, o.element, true) && StructureMapGroupRuleSourceComponent.compareValues(this.listMode, o.listMode, true) && StructureMapGroupRuleSourceComponent.compareValues(this.variable, o.variable, true) && StructureMapGroupRuleSourceComponent.compareValues(this.condition, o.condition, true) && StructureMapGroupRuleSourceComponent.compareValues(this.check, o.check, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.context, this.min, this.max, this.type, this.defaultValue, this.element, this.listMode, this.variable, this.condition, this.check});
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule.source";
        }

        public String toString() {
            return StructureMapUtilities.sourceToString(this);
        }
    }

    @Block
    public static class StructureMapGroupRuleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of the rule for internal references", formalDefinition="Name of the rule for internal references.")
        protected IdType name;
        @Child(name="source", type={}, order=2, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Source inputs to the mapping", formalDefinition="Source inputs to the mapping.")
        protected List<StructureMapGroupRuleSourceComponent> source;
        @Child(name="target", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Content to create because of this mapping rule", formalDefinition="Content to create because of this mapping rule.")
        protected List<StructureMapGroupRuleTargetComponent> target;
        @Child(name="rule", type={StructureMapGroupRuleComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Rules contained in this rule", formalDefinition="Rules contained in this rule.")
        protected List<StructureMapGroupRuleComponent> rule;
        @Child(name="dependent", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Which other rules to apply in the context of this rule", formalDefinition="Which other rules to apply in the context of this rule.")
        protected List<StructureMapGroupRuleDependentComponent> dependent;
        @Child(name="documentation", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation for this instance of data", formalDefinition="Documentation for this instance of data.")
        protected StringType documentation;
        private static final long serialVersionUID = 773925517L;

        public StructureMapGroupRuleComponent() {
        }

        public StructureMapGroupRuleComponent(IdType name) {
            this.name = name;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupRuleComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupRuleComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public List<StructureMapGroupRuleSourceComponent> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
            }
            return this.source;
        }

        public StructureMapGroupRuleComponent setSource(List<StructureMapGroupRuleSourceComponent> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (StructureMapGroupRuleSourceComponent item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleSourceComponent addSource() {
            StructureMapGroupRuleSourceComponent t = new StructureMapGroupRuleSourceComponent();
            if (this.source == null) {
                this.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
            }
            this.source.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addSource(StructureMapGroupRuleSourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
            }
            this.source.add(t);
            return this;
        }

        public StructureMapGroupRuleSourceComponent getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        public List<StructureMapGroupRuleTargetComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
            }
            return this.target;
        }

        public StructureMapGroupRuleComponent setTarget(List<StructureMapGroupRuleTargetComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (StructureMapGroupRuleTargetComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleTargetComponent addTarget() {
            StructureMapGroupRuleTargetComponent t = new StructureMapGroupRuleTargetComponent();
            if (this.target == null) {
                this.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
            }
            this.target.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addTarget(StructureMapGroupRuleTargetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
            }
            this.target.add(t);
            return this;
        }

        public StructureMapGroupRuleTargetComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        public List<StructureMapGroupRuleComponent> getRule() {
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            return this.rule;
        }

        public StructureMapGroupRuleComponent setRule(List<StructureMapGroupRuleComponent> theRule) {
            this.rule = theRule;
            return this;
        }

        public boolean hasRule() {
            if (this.rule == null) {
                return false;
            }
            for (StructureMapGroupRuleComponent item : this.rule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleComponent addRule() {
            StructureMapGroupRuleComponent t = new StructureMapGroupRuleComponent();
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addRule(StructureMapGroupRuleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return this;
        }

        public StructureMapGroupRuleComponent getRuleFirstRep() {
            if (this.getRule().isEmpty()) {
                this.addRule();
            }
            return this.getRule().get(0);
        }

        public List<StructureMapGroupRuleDependentComponent> getDependent() {
            if (this.dependent == null) {
                this.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
            }
            return this.dependent;
        }

        public StructureMapGroupRuleComponent setDependent(List<StructureMapGroupRuleDependentComponent> theDependent) {
            this.dependent = theDependent;
            return this;
        }

        public boolean hasDependent() {
            if (this.dependent == null) {
                return false;
            }
            for (StructureMapGroupRuleDependentComponent item : this.dependent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleDependentComponent addDependent() {
            StructureMapGroupRuleDependentComponent t = new StructureMapGroupRuleDependentComponent();
            if (this.dependent == null) {
                this.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
            }
            this.dependent.add(t);
            return t;
        }

        public StructureMapGroupRuleComponent addDependent(StructureMapGroupRuleDependentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependent == null) {
                this.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
            }
            this.dependent.add(t);
            return this;
        }

        public StructureMapGroupRuleDependentComponent getDependentFirstRep() {
            if (this.getDependent().isEmpty()) {
                this.addDependent();
            }
            return this.getDependent().get(0);
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupRuleComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapGroupRuleComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapGroupRuleComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(StructureMap.SP_NAME, "id", "Name of the rule for internal references.", 0, 1, this.name));
            children.add(new Property("source", "", "Source inputs to the mapping.", 0, Integer.MAX_VALUE, this.source));
            children.add(new Property("target", "", "Content to create because of this mapping rule.", 0, Integer.MAX_VALUE, this.target));
            children.add(new Property("rule", "@StructureMap.group.rule", "Rules contained in this rule.", 0, Integer.MAX_VALUE, this.rule));
            children.add(new Property("dependent", "", "Which other rules to apply in the context of this rule.", 0, Integer.MAX_VALUE, this.dependent));
            children.add(new Property("documentation", "string", "Documentation for this instance of data.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(StructureMap.SP_NAME, "id", "Name of the rule for internal references.", 0, 1, this.name);
                }
                case -896505829: {
                    return new Property("source", "", "Source inputs to the mapping.", 0, Integer.MAX_VALUE, this.source);
                }
                case -880905839: {
                    return new Property("target", "", "Content to create because of this mapping rule.", 0, Integer.MAX_VALUE, this.target);
                }
                case 3512060: {
                    return new Property("rule", "@StructureMap.group.rule", "Rules contained in this rule.", 0, Integer.MAX_VALUE, this.rule);
                }
                case -1109226753: {
                    return new Property("dependent", "", "Which other rules to apply in the context of this rule.", 0, Integer.MAX_VALUE, this.dependent);
                }
                case 1587405498: {
                    return new Property("documentation", "string", "Documentation for this instance of data.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
                case 3512060: {
                    return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
                }
                case -1109226753: {
                    return this.dependent == null ? new Base[]{} : this.dependent.toArray(new Base[this.dependent.size()]);
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add((StructureMapGroupRuleSourceComponent)value);
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((StructureMapGroupRuleTargetComponent)value);
                    return value;
                }
                case 3512060: {
                    this.getRule().add((StructureMapGroupRuleComponent)value);
                    return value;
                }
                case -1109226753: {
                    this.getDependent().add((StructureMapGroupRuleDependentComponent)value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("source")) {
                this.getSource().add((StructureMapGroupRuleSourceComponent)value);
            } else if (name.equals("target")) {
                this.getTarget().add((StructureMapGroupRuleTargetComponent)value);
            } else if (name.equals("rule")) {
                this.getRule().add((StructureMapGroupRuleComponent)value);
            } else if (name.equals("dependent")) {
                this.getDependent().add((StructureMapGroupRuleDependentComponent)value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -896505829: {
                    return this.addSource();
                }
                case -880905839: {
                    return this.addTarget();
                }
                case 3512060: {
                    return this.addRule();
                }
                case -1109226753: {
                    return this.addDependent();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"id"};
                }
                case -896505829: {
                    return new String[0];
                }
                case -880905839: {
                    return new String[0];
                }
                case 3512060: {
                    return new String[]{"@StructureMap.group.rule"};
                }
                case -1109226753: {
                    return new String[0];
                }
                case 1587405498: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            if (name.equals("target")) {
                return this.addTarget();
            }
            if (name.equals("rule")) {
                return this.addRule();
            }
            if (name.equals("dependent")) {
                return this.addDependent();
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupRuleComponent copy() {
            StructureMapGroupRuleComponent dst = new StructureMapGroupRuleComponent();
            this.copyValues(dst);
            IdType idType = dst.name = this.name == null ? null : this.name.copy();
            if (this.source != null) {
                dst.source = new ArrayList<StructureMapGroupRuleSourceComponent>();
                for (StructureMapGroupRuleSourceComponent structureMapGroupRuleSourceComponent : this.source) {
                    dst.source.add(structureMapGroupRuleSourceComponent.copy());
                }
            }
            if (this.target != null) {
                dst.target = new ArrayList<StructureMapGroupRuleTargetComponent>();
                for (StructureMapGroupRuleTargetComponent structureMapGroupRuleTargetComponent : this.target) {
                    dst.target.add(structureMapGroupRuleTargetComponent.copy());
                }
            }
            if (this.rule != null) {
                dst.rule = new ArrayList<StructureMapGroupRuleComponent>();
                for (StructureMapGroupRuleComponent structureMapGroupRuleComponent : this.rule) {
                    dst.rule.add(structureMapGroupRuleComponent.copy());
                }
            }
            if (this.dependent != null) {
                dst.dependent = new ArrayList<StructureMapGroupRuleDependentComponent>();
                for (StructureMapGroupRuleDependentComponent structureMapGroupRuleDependentComponent : this.dependent) {
                    dst.dependent.add(structureMapGroupRuleDependentComponent.copy());
                }
            }
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleComponent)) {
                return false;
            }
            StructureMapGroupRuleComponent o = (StructureMapGroupRuleComponent)other_;
            return StructureMapGroupRuleComponent.compareDeep(this.name, o.name, true) && StructureMapGroupRuleComponent.compareDeep(this.source, o.source, true) && StructureMapGroupRuleComponent.compareDeep(this.target, o.target, true) && StructureMapGroupRuleComponent.compareDeep(this.rule, o.rule, true) && StructureMapGroupRuleComponent.compareDeep(this.dependent, o.dependent, true) && StructureMapGroupRuleComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupRuleComponent)) {
                return false;
            }
            StructureMapGroupRuleComponent o = (StructureMapGroupRuleComponent)other_;
            return StructureMapGroupRuleComponent.compareValues(this.name, o.name, true) && StructureMapGroupRuleComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.source, this.target, this.rule, this.dependent, this.documentation});
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.rule";
        }

        public String toString() {
            return StructureMapUtilities.ruleToString(this);
        }
    }

    @Block
    public static class StructureMapGroupInputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name for this instance of data", formalDefinition="Name for this instance of data.")
        protected IdType name;
        @Child(name="type", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type for this instance of data", formalDefinition="Type for this instance of data.")
        protected StringType type;
        @Child(name="mode", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="source | target", formalDefinition="Mode for this instance of data.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/map-input-mode")
        protected Enumeration<StructureMapInputMode> mode;
        @Child(name="documentation", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation for this instance of data", formalDefinition="Documentation for this instance of data.")
        protected StringType documentation;
        private static final long serialVersionUID = -25050724L;

        public StructureMapGroupInputComponent() {
        }

        public StructureMapGroupInputComponent(IdType name, Enumeration<StructureMapInputMode> mode) {
            this.name = name;
            this.mode = mode;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupInputComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupInputComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StructureMapGroupInputComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public StructureMapGroupInputComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new StringType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapInputMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<StructureMapInputMode>(new StructureMapInputModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public StructureMapGroupInputComponent setModeElement(Enumeration<StructureMapInputMode> value) {
            this.mode = value;
            return this;
        }

        public StructureMapInputMode getMode() {
            return this.mode == null ? null : (StructureMapInputMode)((Object)this.mode.getValue());
        }

        public StructureMapGroupInputComponent setMode(StructureMapInputMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<StructureMapInputMode>(new StructureMapInputModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupInputComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapGroupInputComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapGroupInputComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(StructureMap.SP_NAME, "id", "Name for this instance of data.", 0, 1, this.name));
            children.add(new Property("type", "string", "Type for this instance of data.", 0, 1, this.type));
            children.add(new Property("mode", "code", "Mode for this instance of data.", 0, 1, this.mode));
            children.add(new Property("documentation", "string", "Documentation for this instance of data.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(StructureMap.SP_NAME, "id", "Name for this instance of data.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "string", "Type for this instance of data.", 0, 1, this.type);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "Mode for this instance of data.", 0, 1, this.mode);
                }
                case 1587405498: {
                    return new Property("documentation", "string", "Documentation for this instance of data.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.mode;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToString(value);
                    return value;
                }
                case 0x3339A3: {
                    value = new StructureMapInputModeEnumFactory().fromType(this.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("type")) {
                this.type = this.castToString(value);
            } else if (name.equals("mode")) {
                value = new StructureMapInputModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"id"};
                }
                case 3575610: {
                    return new String[]{"string"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.type");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupInputComponent copy() {
            StructureMapGroupInputComponent dst = new StructureMapGroupInputComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupInputComponent)) {
                return false;
            }
            StructureMapGroupInputComponent o = (StructureMapGroupInputComponent)other_;
            return StructureMapGroupInputComponent.compareDeep(this.name, o.name, true) && StructureMapGroupInputComponent.compareDeep(this.type, o.type, true) && StructureMapGroupInputComponent.compareDeep(this.mode, o.mode, true) && StructureMapGroupInputComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupInputComponent)) {
                return false;
            }
            StructureMapGroupInputComponent o = (StructureMapGroupInputComponent)other_;
            return StructureMapGroupInputComponent.compareValues(this.name, o.name, true) && StructureMapGroupInputComponent.compareValues(this.type, o.type, true) && StructureMapGroupInputComponent.compareValues(this.mode, o.mode, true) && StructureMapGroupInputComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.type, this.mode, this.documentation});
        }

        @Override
        public String fhirType() {
            return "StructureMap.group.input";
        }
    }

    @Block
    public static class StructureMapGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human-readable label", formalDefinition="A unique name for the group for the convenience of human readers.")
        protected IdType name;
        @Child(name="extends", type={IdType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Another group that this group adds rules to", formalDefinition="Another group that this group adds rules to.")
        protected IdType extends_;
        @Child(name="typeMode", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="none | types | type-and-types", formalDefinition="If this is the default rule set to apply for thie source type, or this combination of types.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/map-group-type-mode")
        protected Enumeration<StructureMapGroupTypeMode> typeMode;
        @Child(name="documentation", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional description/explaination for group", formalDefinition="Additional supporting documentation that explains the purpose of the group and the types of mappings within it.")
        protected StringType documentation;
        @Child(name="input", type={}, order=5, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Named instance provided when invoking the map", formalDefinition="A name assigned to an instance of data. The instance must be provided when the mapping is invoked.")
        protected List<StructureMapGroupInputComponent> input;
        @Child(name="rule", type={}, order=6, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Transform Rule from source to target", formalDefinition="Transform Rule from source to target.")
        protected List<StructureMapGroupRuleComponent> rule;
        private static final long serialVersionUID = -1474595081L;

        public StructureMapGroupComponent() {
        }

        public StructureMapGroupComponent(IdType name, Enumeration<StructureMapGroupTypeMode> typeMode) {
            this.name = name;
            this.typeMode = typeMode;
        }

        public IdType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new IdType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureMapGroupComponent setNameElement(IdType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : this.name.getValue();
        }

        public StructureMapGroupComponent setName(String value) {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
            return this;
        }

        public IdType getExtendsElement() {
            if (this.extends_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupComponent.extends_");
                }
                if (Configuration.doAutoCreate()) {
                    this.extends_ = new IdType();
                }
            }
            return this.extends_;
        }

        public boolean hasExtendsElement() {
            return this.extends_ != null && !this.extends_.isEmpty();
        }

        public boolean hasExtends() {
            return this.extends_ != null && !this.extends_.isEmpty();
        }

        public StructureMapGroupComponent setExtendsElement(IdType value) {
            this.extends_ = value;
            return this;
        }

        public String getExtends() {
            return this.extends_ == null ? null : this.extends_.getValue();
        }

        public StructureMapGroupComponent setExtends(String value) {
            if (Utilities.noString((String)value)) {
                this.extends_ = null;
            } else {
                if (this.extends_ == null) {
                    this.extends_ = new IdType();
                }
                this.extends_.setValue(value);
            }
            return this;
        }

        public Enumeration<StructureMapGroupTypeMode> getTypeModeElement() {
            if (this.typeMode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupComponent.typeMode");
                }
                if (Configuration.doAutoCreate()) {
                    this.typeMode = new Enumeration<StructureMapGroupTypeMode>(new StructureMapGroupTypeModeEnumFactory());
                }
            }
            return this.typeMode;
        }

        public boolean hasTypeModeElement() {
            return this.typeMode != null && !this.typeMode.isEmpty();
        }

        public boolean hasTypeMode() {
            return this.typeMode != null && !this.typeMode.isEmpty();
        }

        public StructureMapGroupComponent setTypeModeElement(Enumeration<StructureMapGroupTypeMode> value) {
            this.typeMode = value;
            return this;
        }

        public StructureMapGroupTypeMode getTypeMode() {
            return this.typeMode == null ? null : (StructureMapGroupTypeMode)((Object)this.typeMode.getValue());
        }

        public StructureMapGroupComponent setTypeMode(StructureMapGroupTypeMode value) {
            if (this.typeMode == null) {
                this.typeMode = new Enumeration<StructureMapGroupTypeMode>(new StructureMapGroupTypeModeEnumFactory());
            }
            this.typeMode.setValue((Object)value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapGroupComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapGroupComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapGroupComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<StructureMapGroupInputComponent> getInput() {
            if (this.input == null) {
                this.input = new ArrayList<StructureMapGroupInputComponent>();
            }
            return this.input;
        }

        public StructureMapGroupComponent setInput(List<StructureMapGroupInputComponent> theInput) {
            this.input = theInput;
            return this;
        }

        public boolean hasInput() {
            if (this.input == null) {
                return false;
            }
            for (StructureMapGroupInputComponent item : this.input) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupInputComponent addInput() {
            StructureMapGroupInputComponent t = new StructureMapGroupInputComponent();
            if (this.input == null) {
                this.input = new ArrayList<StructureMapGroupInputComponent>();
            }
            this.input.add(t);
            return t;
        }

        public StructureMapGroupComponent addInput(StructureMapGroupInputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.input == null) {
                this.input = new ArrayList<StructureMapGroupInputComponent>();
            }
            this.input.add(t);
            return this;
        }

        public StructureMapGroupInputComponent getInputFirstRep() {
            if (this.getInput().isEmpty()) {
                this.addInput();
            }
            return this.getInput().get(0);
        }

        public List<StructureMapGroupRuleComponent> getRule() {
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            return this.rule;
        }

        public StructureMapGroupComponent setRule(List<StructureMapGroupRuleComponent> theRule) {
            this.rule = theRule;
            return this;
        }

        public boolean hasRule() {
            if (this.rule == null) {
                return false;
            }
            for (StructureMapGroupRuleComponent item : this.rule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StructureMapGroupRuleComponent addRule() {
            StructureMapGroupRuleComponent t = new StructureMapGroupRuleComponent();
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return t;
        }

        public StructureMapGroupComponent addRule(StructureMapGroupRuleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.rule == null) {
                this.rule = new ArrayList<StructureMapGroupRuleComponent>();
            }
            this.rule.add(t);
            return this;
        }

        public StructureMapGroupRuleComponent getRuleFirstRep() {
            if (this.getRule().isEmpty()) {
                this.addRule();
            }
            return this.getRule().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(StructureMap.SP_NAME, "id", "A unique name for the group for the convenience of human readers.", 0, 1, this.name));
            children.add(new Property("extends", "id", "Another group that this group adds rules to.", 0, 1, this.extends_));
            children.add(new Property("typeMode", "code", "If this is the default rule set to apply for thie source type, or this combination of types.", 0, 1, this.typeMode));
            children.add(new Property("documentation", "string", "Additional supporting documentation that explains the purpose of the group and the types of mappings within it.", 0, 1, this.documentation));
            children.add(new Property("input", "", "A name assigned to an instance of data. The instance must be provided when the mapping is invoked.", 0, Integer.MAX_VALUE, this.input));
            children.add(new Property("rule", "", "Transform Rule from source to target.", 0, Integer.MAX_VALUE, this.rule));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(StructureMap.SP_NAME, "id", "A unique name for the group for the convenience of human readers.", 0, 1, this.name);
                }
                case -1305664359: {
                    return new Property("extends", "id", "Another group that this group adds rules to.", 0, 1, this.extends_);
                }
                case -676524035: {
                    return new Property("typeMode", "code", "If this is the default rule set to apply for thie source type, or this combination of types.", 0, 1, this.typeMode);
                }
                case 1587405498: {
                    return new Property("documentation", "string", "Additional supporting documentation that explains the purpose of the group and the types of mappings within it.", 0, 1, this.documentation);
                }
                case 100358090: {
                    return new Property("input", "", "A name assigned to an instance of data. The instance must be provided when the mapping is invoked.", 0, Integer.MAX_VALUE, this.input);
                }
                case 3512060: {
                    return new Property("rule", "", "Transform Rule from source to target.", 0, Integer.MAX_VALUE, this.rule);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1305664359: {
                    Base[] baseArray;
                    if (this.extends_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.extends_;
                    }
                    return baseArray;
                }
                case -676524035: {
                    Base[] baseArray;
                    if (this.typeMode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.typeMode;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 100358090: {
                    return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
                }
                case 3512060: {
                    return this.rule == null ? new Base[]{} : this.rule.toArray(new Base[this.rule.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToId(value);
                    return value;
                }
                case -1305664359: {
                    this.extends_ = this.castToId(value);
                    return value;
                }
                case -676524035: {
                    value = new StructureMapGroupTypeModeEnumFactory().fromType(this.castToCode(value));
                    this.typeMode = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    return value;
                }
                case 100358090: {
                    this.getInput().add((StructureMapGroupInputComponent)((Object)value));
                    return value;
                }
                case 3512060: {
                    this.getRule().add((StructureMapGroupRuleComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                this.name = this.castToId(value);
            } else if (name.equals("extends")) {
                this.extends_ = this.castToId(value);
            } else if (name.equals("typeMode")) {
                value = new StructureMapGroupTypeModeEnumFactory().fromType(this.castToCode(value));
                this.typeMode = value;
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals("input")) {
                this.getInput().add((StructureMapGroupInputComponent)((Object)value));
            } else if (name.equals("rule")) {
                this.getRule().add((StructureMapGroupRuleComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1305664359: {
                    return this.getExtendsElement();
                }
                case -676524035: {
                    return this.getTypeModeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case 100358090: {
                    return this.addInput();
                }
                case 3512060: {
                    return this.addRule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"id"};
                }
                case -1305664359: {
                    return new String[]{"id"};
                }
                case -676524035: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"string"};
                }
                case 100358090: {
                    return new String[0];
                }
                case 3512060: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.name");
            }
            if (name.equals("extends")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.extends");
            }
            if (name.equals("typeMode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.typeMode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            if (name.equals("input")) {
                return this.addInput();
            }
            if (name.equals("rule")) {
                return this.addRule();
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapGroupComponent copy() {
            StructureMapGroupComponent dst = new StructureMapGroupComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.extends_ = this.extends_ == null ? null : this.extends_.copy();
            dst.typeMode = this.typeMode == null ? null : this.typeMode.copy();
            StringType stringType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.input != null) {
                dst.input = new ArrayList<StructureMapGroupInputComponent>();
                for (StructureMapGroupInputComponent structureMapGroupInputComponent : this.input) {
                    dst.input.add(structureMapGroupInputComponent.copy());
                }
            }
            if (this.rule != null) {
                dst.rule = new ArrayList<StructureMapGroupRuleComponent>();
                for (StructureMapGroupRuleComponent structureMapGroupRuleComponent : this.rule) {
                    dst.rule.add(structureMapGroupRuleComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupComponent)) {
                return false;
            }
            StructureMapGroupComponent o = (StructureMapGroupComponent)other_;
            return StructureMapGroupComponent.compareDeep(this.name, o.name, true) && StructureMapGroupComponent.compareDeep(this.extends_, o.extends_, true) && StructureMapGroupComponent.compareDeep(this.typeMode, o.typeMode, true) && StructureMapGroupComponent.compareDeep(this.documentation, o.documentation, true) && StructureMapGroupComponent.compareDeep(this.input, o.input, true) && StructureMapGroupComponent.compareDeep(this.rule, o.rule, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapGroupComponent)) {
                return false;
            }
            StructureMapGroupComponent o = (StructureMapGroupComponent)other_;
            return StructureMapGroupComponent.compareValues(this.name, o.name, true) && StructureMapGroupComponent.compareValues(this.extends_, o.extends_, true) && StructureMapGroupComponent.compareValues(this.typeMode, o.typeMode, true) && StructureMapGroupComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.extends_, this.typeMode, this.documentation, this.input, this.rule});
        }

        @Override
        public String fhirType() {
            return "StructureMap.group";
        }

        public String toString() {
            return StructureMapUtilities.groupToString(this);
        }
    }

    @Block
    public static class StructureMapStructureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="url", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Canonical URL for structure definition", formalDefinition="The canonical URL that identifies the structure.")
        protected UriType url;
        @Child(name="mode", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="source | queried | target | produced", formalDefinition="How the referenced structure is used in this mapping.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/map-model-mode")
        protected Enumeration<StructureMapModelMode> mode;
        @Child(name="alias", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name for type in this map", formalDefinition="The name used for this type in the map.")
        protected StringType alias;
        @Child(name="documentation", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation on use of structure", formalDefinition="Documentation that describes how the structure is used in the mapping.")
        protected StringType documentation;
        private static final long serialVersionUID = -277986558L;

        public StructureMapStructureComponent() {
        }

        public StructureMapStructureComponent(UriType url, Enumeration<StructureMapModelMode> mode) {
            this.url = url;
            this.mode = mode;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapStructureComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public StructureMapStructureComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public StructureMapStructureComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public Enumeration<StructureMapModelMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapStructureComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<StructureMapModelMode>(new StructureMapModelModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public StructureMapStructureComponent setModeElement(Enumeration<StructureMapModelMode> value) {
            this.mode = value;
            return this;
        }

        public StructureMapModelMode getMode() {
            return this.mode == null ? null : (StructureMapModelMode)((Object)this.mode.getValue());
        }

        public StructureMapStructureComponent setMode(StructureMapModelMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<StructureMapModelMode>(new StructureMapModelModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public StringType getAliasElement() {
            if (this.alias == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapStructureComponent.alias");
                }
                if (Configuration.doAutoCreate()) {
                    this.alias = new StringType();
                }
            }
            return this.alias;
        }

        public boolean hasAliasElement() {
            return this.alias != null && !this.alias.isEmpty();
        }

        public boolean hasAlias() {
            return this.alias != null && !this.alias.isEmpty();
        }

        public StructureMapStructureComponent setAliasElement(StringType value) {
            this.alias = value;
            return this;
        }

        public String getAlias() {
            return this.alias == null ? null : (String)this.alias.getValue();
        }

        public StructureMapStructureComponent setAlias(String value) {
            if (Utilities.noString((String)value)) {
                this.alias = null;
            } else {
                if (this.alias == null) {
                    this.alias = new StringType();
                }
                this.alias.setValue(value);
            }
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureMapStructureComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public StructureMapStructureComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public StructureMapStructureComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(StructureMap.SP_URL, "uri", "The canonical URL that identifies the structure.", 0, 1, this.url));
            children.add(new Property("mode", "code", "How the referenced structure is used in this mapping.", 0, 1, this.mode));
            children.add(new Property("alias", "string", "The name used for this type in the map.", 0, 1, this.alias));
            children.add(new Property("documentation", "string", "Documentation that describes how the structure is used in the mapping.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116079: {
                    return new Property(StructureMap.SP_URL, "uri", "The canonical URL that identifies the structure.", 0, 1, this.url);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "How the referenced structure is used in this mapping.", 0, 1, this.mode);
                }
                case 92902992: {
                    return new Property("alias", "string", "The name used for this type in the map.", 0, 1, this.alias);
                }
                case 1587405498: {
                    return new Property("documentation", "string", "Documentation that describes how the structure is used in the mapping.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.url;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.mode;
                    }
                    return baseArray;
                }
                case 92902992: {
                    Base[] baseArray;
                    if (this.alias == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.alias;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116079: {
                    this.url = this.castToUri(value);
                    return value;
                }
                case 0x3339A3: {
                    value = new StructureMapModelModeEnumFactory().fromType(this.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 92902992: {
                    this.alias = this.castToString(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureMap.SP_URL)) {
                this.url = this.castToUri(value);
            } else if (name.equals("mode")) {
                value = new StructureMapModelModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
            } else if (name.equals("alias")) {
                this.alias = this.castToString(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116079: {
                    return this.getUrlElement();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 92902992: {
                    return this.getAliasElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116079: {
                    return new String[]{"uri"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 92902992: {
                    return new String[]{"string"};
                }
                case 1587405498: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureMap.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.url");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.mode");
            }
            if (name.equals("alias")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.alias");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureMap.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public StructureMapStructureComponent copy() {
            StructureMapStructureComponent dst = new StructureMapStructureComponent();
            this.copyValues(dst);
            dst.url = this.url == null ? null : this.url.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.alias = this.alias == null ? null : this.alias.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapStructureComponent)) {
                return false;
            }
            StructureMapStructureComponent o = (StructureMapStructureComponent)other_;
            return StructureMapStructureComponent.compareDeep(this.url, o.url, true) && StructureMapStructureComponent.compareDeep(this.mode, o.mode, true) && StructureMapStructureComponent.compareDeep(this.alias, o.alias, true) && StructureMapStructureComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureMapStructureComponent)) {
                return false;
            }
            StructureMapStructureComponent o = (StructureMapStructureComponent)other_;
            return StructureMapStructureComponent.compareValues(this.url, o.url, true) && StructureMapStructureComponent.compareValues(this.mode, o.mode, true) && StructureMapStructureComponent.compareValues(this.alias, o.alias, true) && StructureMapStructureComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.url, this.mode, this.alias, this.documentation});
        }

        @Override
        public String fhirType() {
            return "StructureMap.structure";
        }
    }

    public static class StructureMapTransformEnumFactory
    implements EnumFactory<StructureMapTransform> {
        @Override
        public StructureMapTransform fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return StructureMapTransform.CREATE;
            }
            if ("copy".equals(codeString)) {
                return StructureMapTransform.COPY;
            }
            if ("truncate".equals(codeString)) {
                return StructureMapTransform.TRUNCATE;
            }
            if ("escape".equals(codeString)) {
                return StructureMapTransform.ESCAPE;
            }
            if ("cast".equals(codeString)) {
                return StructureMapTransform.CAST;
            }
            if ("append".equals(codeString)) {
                return StructureMapTransform.APPEND;
            }
            if ("translate".equals(codeString)) {
                return StructureMapTransform.TRANSLATE;
            }
            if ("reference".equals(codeString)) {
                return StructureMapTransform.REFERENCE;
            }
            if ("dateOp".equals(codeString)) {
                return StructureMapTransform.DATEOP;
            }
            if ("uuid".equals(codeString)) {
                return StructureMapTransform.UUID;
            }
            if ("pointer".equals(codeString)) {
                return StructureMapTransform.POINTER;
            }
            if ("evaluate".equals(codeString)) {
                return StructureMapTransform.EVALUATE;
            }
            if ("cc".equals(codeString)) {
                return StructureMapTransform.CC;
            }
            if ("c".equals(codeString)) {
                return StructureMapTransform.C;
            }
            if ("qty".equals(codeString)) {
                return StructureMapTransform.QTY;
            }
            if ("id".equals(codeString)) {
                return StructureMapTransform.ID;
            }
            if ("cp".equals(codeString)) {
                return StructureMapTransform.CP;
            }
            throw new IllegalArgumentException("Unknown StructureMapTransform code '" + codeString + "'");
        }

        public Enumeration<StructureMapTransform> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureMapTransform>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.CREATE);
            }
            if ("copy".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.COPY);
            }
            if ("truncate".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.TRUNCATE);
            }
            if ("escape".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.ESCAPE);
            }
            if ("cast".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.CAST);
            }
            if ("append".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.APPEND);
            }
            if ("translate".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.TRANSLATE);
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.REFERENCE);
            }
            if ("dateOp".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.DATEOP);
            }
            if ("uuid".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.UUID);
            }
            if ("pointer".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.POINTER);
            }
            if ("evaluate".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.EVALUATE);
            }
            if ("cc".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.CC);
            }
            if ("c".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.C);
            }
            if ("qty".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.QTY);
            }
            if ("id".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.ID);
            }
            if ("cp".equals(codeString)) {
                return new Enumeration<StructureMapTransform>(this, StructureMapTransform.CP);
            }
            throw new FHIRException("Unknown StructureMapTransform code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapTransform code) {
            if (code == StructureMapTransform.CREATE) {
                return "create";
            }
            if (code == StructureMapTransform.COPY) {
                return "copy";
            }
            if (code == StructureMapTransform.TRUNCATE) {
                return "truncate";
            }
            if (code == StructureMapTransform.ESCAPE) {
                return "escape";
            }
            if (code == StructureMapTransform.CAST) {
                return "cast";
            }
            if (code == StructureMapTransform.APPEND) {
                return "append";
            }
            if (code == StructureMapTransform.TRANSLATE) {
                return "translate";
            }
            if (code == StructureMapTransform.REFERENCE) {
                return "reference";
            }
            if (code == StructureMapTransform.DATEOP) {
                return "dateOp";
            }
            if (code == StructureMapTransform.UUID) {
                return "uuid";
            }
            if (code == StructureMapTransform.POINTER) {
                return "pointer";
            }
            if (code == StructureMapTransform.EVALUATE) {
                return "evaluate";
            }
            if (code == StructureMapTransform.CC) {
                return "cc";
            }
            if (code == StructureMapTransform.C) {
                return "c";
            }
            if (code == StructureMapTransform.QTY) {
                return "qty";
            }
            if (code == StructureMapTransform.ID) {
                return "id";
            }
            if (code == StructureMapTransform.CP) {
                return "cp";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapTransform code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapTransform {
        CREATE,
        COPY,
        TRUNCATE,
        ESCAPE,
        CAST,
        APPEND,
        TRANSLATE,
        REFERENCE,
        DATEOP,
        UUID,
        POINTER,
        EVALUATE,
        CC,
        C,
        QTY,
        ID,
        CP,
        NULL;


        public static StructureMapTransform fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("copy".equals(codeString)) {
                return COPY;
            }
            if ("truncate".equals(codeString)) {
                return TRUNCATE;
            }
            if ("escape".equals(codeString)) {
                return ESCAPE;
            }
            if ("cast".equals(codeString)) {
                return CAST;
            }
            if ("append".equals(codeString)) {
                return APPEND;
            }
            if ("translate".equals(codeString)) {
                return TRANSLATE;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("dateOp".equals(codeString)) {
                return DATEOP;
            }
            if ("uuid".equals(codeString)) {
                return UUID;
            }
            if ("pointer".equals(codeString)) {
                return POINTER;
            }
            if ("evaluate".equals(codeString)) {
                return EVALUATE;
            }
            if ("cc".equals(codeString)) {
                return CC;
            }
            if ("c".equals(codeString)) {
                return C;
            }
            if ("qty".equals(codeString)) {
                return QTY;
            }
            if ("id".equals(codeString)) {
                return ID;
            }
            if ("cp".equals(codeString)) {
                return CP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureMapTransform code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case COPY: {
                    return "copy";
                }
                case TRUNCATE: {
                    return "truncate";
                }
                case ESCAPE: {
                    return "escape";
                }
                case CAST: {
                    return "cast";
                }
                case APPEND: {
                    return "append";
                }
                case TRANSLATE: {
                    return "translate";
                }
                case REFERENCE: {
                    return "reference";
                }
                case DATEOP: {
                    return "dateOp";
                }
                case UUID: {
                    return "uuid";
                }
                case POINTER: {
                    return "pointer";
                }
                case EVALUATE: {
                    return "evaluate";
                }
                case CC: {
                    return "cc";
                }
                case C: {
                    return "c";
                }
                case QTY: {
                    return "qty";
                }
                case ID: {
                    return "id";
                }
                case CP: {
                    return "cp";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case COPY: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case TRUNCATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case ESCAPE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case CAST: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case APPEND: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case TRANSLATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case REFERENCE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case DATEOP: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case UUID: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case POINTER: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case EVALUATE: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case CC: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case C: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case QTY: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case ID: {
                    return "http://hl7.org/fhir/map-transform";
                }
                case CP: {
                    return "http://hl7.org/fhir/map-transform";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "create(type : string) - type is passed through to the application on the standard API, and must be known by it";
                }
                case COPY: {
                    return "copy(source)";
                }
                case TRUNCATE: {
                    return "truncate(source, length) - source must be stringy type";
                }
                case ESCAPE: {
                    return "escape(source, fmt1, fmt2) - change source from one kind of escaping to another (plain, java, xml, json). note that this is for when the string itself is escaped";
                }
                case CAST: {
                    return "cast(source, type?) - case source from one type to another. target type can be left as implicit if there is one and only one target type known";
                }
                case APPEND: {
                    return "append(source...) - source is element or string";
                }
                case TRANSLATE: {
                    return "translate(source, uri_of_map) - use the translate operation";
                }
                case REFERENCE: {
                    return "reference(source : object) - return a string that references the provided tree properly";
                }
                case DATEOP: {
                    return "Perform a date operation. *Parameters to be documented*";
                }
                case UUID: {
                    return "Generate a random UUID (in lowercase). No Parameters";
                }
                case POINTER: {
                    return "Return the appropriate string to put in a reference that refers to the resource provided as a parameter";
                }
                case EVALUATE: {
                    return "Execute the supplied fluentpath expression and use the value returned by that";
                }
                case CC: {
                    return "Create a CodeableConcept. Parameters = (text) or (system. Code[, display])";
                }
                case C: {
                    return "Create a Coding. Parameters = (system. Code[, display])";
                }
                case QTY: {
                    return "Create a quantity. Parameters = (text) or (value, unit, [system, code]) where text is the natural representation e.g. [comparator]value[space]unit";
                }
                case ID: {
                    return "Create an identifier. Parameters = (system, value[, type]) where type is a code from the identifier type value set";
                }
                case CP: {
                    return "Create a contact details. Parameters = (value) or (system, value). If no system is provided, the system should be inferred from the content of the value";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case COPY: {
                    return "copy";
                }
                case TRUNCATE: {
                    return "truncate";
                }
                case ESCAPE: {
                    return "escape";
                }
                case CAST: {
                    return "cast";
                }
                case APPEND: {
                    return "append";
                }
                case TRANSLATE: {
                    return "translate";
                }
                case REFERENCE: {
                    return "reference";
                }
                case DATEOP: {
                    return "dateOp";
                }
                case UUID: {
                    return "uuid";
                }
                case POINTER: {
                    return "pointer";
                }
                case EVALUATE: {
                    return "evaluate";
                }
                case CC: {
                    return "cc";
                }
                case C: {
                    return "c";
                }
                case QTY: {
                    return "qty";
                }
                case ID: {
                    return "id";
                }
                case CP: {
                    return "cp";
                }
            }
            return "?";
        }
    }

    public static class StructureMapTargetListModeEnumFactory
    implements EnumFactory<StructureMapTargetListMode> {
        @Override
        public StructureMapTargetListMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("first".equals(codeString)) {
                return StructureMapTargetListMode.FIRST;
            }
            if ("share".equals(codeString)) {
                return StructureMapTargetListMode.SHARE;
            }
            if ("last".equals(codeString)) {
                return StructureMapTargetListMode.LAST;
            }
            if ("collate".equals(codeString)) {
                return StructureMapTargetListMode.COLLATE;
            }
            throw new IllegalArgumentException("Unknown StructureMapTargetListMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapTargetListMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureMapTargetListMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("first".equals(codeString)) {
                return new Enumeration<StructureMapTargetListMode>(this, StructureMapTargetListMode.FIRST);
            }
            if ("share".equals(codeString)) {
                return new Enumeration<StructureMapTargetListMode>(this, StructureMapTargetListMode.SHARE);
            }
            if ("last".equals(codeString)) {
                return new Enumeration<StructureMapTargetListMode>(this, StructureMapTargetListMode.LAST);
            }
            if ("collate".equals(codeString)) {
                return new Enumeration<StructureMapTargetListMode>(this, StructureMapTargetListMode.COLLATE);
            }
            throw new FHIRException("Unknown StructureMapTargetListMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapTargetListMode code) {
            if (code == StructureMapTargetListMode.FIRST) {
                return "first";
            }
            if (code == StructureMapTargetListMode.SHARE) {
                return "share";
            }
            if (code == StructureMapTargetListMode.LAST) {
                return "last";
            }
            if (code == StructureMapTargetListMode.COLLATE) {
                return "collate";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapTargetListMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapTargetListMode {
        FIRST,
        SHARE,
        LAST,
        COLLATE,
        NULL;


        public static StructureMapTargetListMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("first".equals(codeString)) {
                return FIRST;
            }
            if ("share".equals(codeString)) {
                return SHARE;
            }
            if ("last".equals(codeString)) {
                return LAST;
            }
            if ("collate".equals(codeString)) {
                return COLLATE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureMapTargetListMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FIRST: {
                    return "first";
                }
                case SHARE: {
                    return "share";
                }
                case LAST: {
                    return "last";
                }
                case COLLATE: {
                    return "collate";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FIRST: {
                    return "http://hl7.org/fhir/map-target-list-mode";
                }
                case SHARE: {
                    return "http://hl7.org/fhir/map-target-list-mode";
                }
                case LAST: {
                    return "http://hl7.org/fhir/map-target-list-mode";
                }
                case COLLATE: {
                    return "http://hl7.org/fhir/map-target-list-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FIRST: {
                    return "when the target list is being assembled, the items for this rule go first. If more that one rule defines a first item (for a given instance of mapping) then this is an error";
                }
                case SHARE: {
                    return "the target instance is shared with the target instances generated by another rule (up to the first common n items, then create new ones)";
                }
                case LAST: {
                    return "when the target list is being assembled, the items for this rule go last. If more that one rule defines a last item (for a given instance of mapping) then this is an error";
                }
                case COLLATE: {
                    return "re-use the first item in the list, and keep adding content to it";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FIRST: {
                    return "First";
                }
                case SHARE: {
                    return "Share";
                }
                case LAST: {
                    return "Last";
                }
                case COLLATE: {
                    return "Collate";
                }
            }
            return "?";
        }
    }

    public static class StructureMapContextTypeEnumFactory
    implements EnumFactory<StructureMapContextType> {
        @Override
        public StructureMapContextType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("type".equals(codeString)) {
                return StructureMapContextType.TYPE;
            }
            if ("variable".equals(codeString)) {
                return StructureMapContextType.VARIABLE;
            }
            throw new IllegalArgumentException("Unknown StructureMapContextType code '" + codeString + "'");
        }

        public Enumeration<StructureMapContextType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureMapContextType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("type".equals(codeString)) {
                return new Enumeration<StructureMapContextType>(this, StructureMapContextType.TYPE);
            }
            if ("variable".equals(codeString)) {
                return new Enumeration<StructureMapContextType>(this, StructureMapContextType.VARIABLE);
            }
            throw new FHIRException("Unknown StructureMapContextType code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapContextType code) {
            if (code == StructureMapContextType.TYPE) {
                return "type";
            }
            if (code == StructureMapContextType.VARIABLE) {
                return "variable";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapContextType code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapContextType {
        TYPE,
        VARIABLE,
        NULL;


        public static StructureMapContextType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("type".equals(codeString)) {
                return TYPE;
            }
            if ("variable".equals(codeString)) {
                return VARIABLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureMapContextType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TYPE: {
                    return "type";
                }
                case VARIABLE: {
                    return "variable";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TYPE: {
                    return "http://hl7.org/fhir/map-context-type";
                }
                case VARIABLE: {
                    return "http://hl7.org/fhir/map-context-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TYPE: {
                    return "The context specifies a type";
                }
                case VARIABLE: {
                    return "The context specifies a variable";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TYPE: {
                    return "Type";
                }
                case VARIABLE: {
                    return "Variable";
                }
            }
            return "?";
        }
    }

    public static class StructureMapSourceListModeEnumFactory
    implements EnumFactory<StructureMapSourceListMode> {
        @Override
        public StructureMapSourceListMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("first".equals(codeString)) {
                return StructureMapSourceListMode.FIRST;
            }
            if ("not_first".equals(codeString)) {
                return StructureMapSourceListMode.NOTFIRST;
            }
            if ("last".equals(codeString)) {
                return StructureMapSourceListMode.LAST;
            }
            if ("not_last".equals(codeString)) {
                return StructureMapSourceListMode.NOTLAST;
            }
            if ("only_one".equals(codeString)) {
                return StructureMapSourceListMode.ONLYONE;
            }
            throw new IllegalArgumentException("Unknown StructureMapSourceListMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapSourceListMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureMapSourceListMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("first".equals(codeString)) {
                return new Enumeration<StructureMapSourceListMode>(this, StructureMapSourceListMode.FIRST);
            }
            if ("not_first".equals(codeString)) {
                return new Enumeration<StructureMapSourceListMode>(this, StructureMapSourceListMode.NOTFIRST);
            }
            if ("last".equals(codeString)) {
                return new Enumeration<StructureMapSourceListMode>(this, StructureMapSourceListMode.LAST);
            }
            if ("not_last".equals(codeString)) {
                return new Enumeration<StructureMapSourceListMode>(this, StructureMapSourceListMode.NOTLAST);
            }
            if ("only_one".equals(codeString)) {
                return new Enumeration<StructureMapSourceListMode>(this, StructureMapSourceListMode.ONLYONE);
            }
            throw new FHIRException("Unknown StructureMapSourceListMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapSourceListMode code) {
            if (code == StructureMapSourceListMode.FIRST) {
                return "first";
            }
            if (code == StructureMapSourceListMode.NOTFIRST) {
                return "not_first";
            }
            if (code == StructureMapSourceListMode.LAST) {
                return "last";
            }
            if (code == StructureMapSourceListMode.NOTLAST) {
                return "not_last";
            }
            if (code == StructureMapSourceListMode.ONLYONE) {
                return "only_one";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapSourceListMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapSourceListMode {
        FIRST,
        NOTFIRST,
        LAST,
        NOTLAST,
        ONLYONE,
        NULL;


        public static StructureMapSourceListMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("first".equals(codeString)) {
                return FIRST;
            }
            if ("not_first".equals(codeString)) {
                return NOTFIRST;
            }
            if ("last".equals(codeString)) {
                return LAST;
            }
            if ("not_last".equals(codeString)) {
                return NOTLAST;
            }
            if ("only_one".equals(codeString)) {
                return ONLYONE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureMapSourceListMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FIRST: {
                    return "first";
                }
                case NOTFIRST: {
                    return "not_first";
                }
                case LAST: {
                    return "last";
                }
                case NOTLAST: {
                    return "not_last";
                }
                case ONLYONE: {
                    return "only_one";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FIRST: {
                    return "http://hl7.org/fhir/map-source-list-mode";
                }
                case NOTFIRST: {
                    return "http://hl7.org/fhir/map-source-list-mode";
                }
                case LAST: {
                    return "http://hl7.org/fhir/map-source-list-mode";
                }
                case NOTLAST: {
                    return "http://hl7.org/fhir/map-source-list-mode";
                }
                case ONLYONE: {
                    return "http://hl7.org/fhir/map-source-list-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FIRST: {
                    return "Only process this rule for the first in the list";
                }
                case NOTFIRST: {
                    return "Process this rule for all but the first";
                }
                case LAST: {
                    return "Only process this rule for the last in the list";
                }
                case NOTLAST: {
                    return "Process this rule for all but the last";
                }
                case ONLYONE: {
                    return "Only process this rule is there is only item";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FIRST: {
                    return "First";
                }
                case NOTFIRST: {
                    return "All but the first";
                }
                case LAST: {
                    return "Last";
                }
                case NOTLAST: {
                    return "All but the last";
                }
                case ONLYONE: {
                    return "Enforce only one";
                }
            }
            return "?";
        }
    }

    public static class StructureMapInputModeEnumFactory
    implements EnumFactory<StructureMapInputMode> {
        @Override
        public StructureMapInputMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("source".equals(codeString)) {
                return StructureMapInputMode.SOURCE;
            }
            if ("target".equals(codeString)) {
                return StructureMapInputMode.TARGET;
            }
            throw new IllegalArgumentException("Unknown StructureMapInputMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapInputMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureMapInputMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return new Enumeration<StructureMapInputMode>(this, StructureMapInputMode.SOURCE);
            }
            if ("target".equals(codeString)) {
                return new Enumeration<StructureMapInputMode>(this, StructureMapInputMode.TARGET);
            }
            throw new FHIRException("Unknown StructureMapInputMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapInputMode code) {
            if (code == StructureMapInputMode.SOURCE) {
                return "source";
            }
            if (code == StructureMapInputMode.TARGET) {
                return "target";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapInputMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapInputMode {
        SOURCE,
        TARGET,
        NULL;


        public static StructureMapInputMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return SOURCE;
            }
            if ("target".equals(codeString)) {
                return TARGET;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureMapInputMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SOURCE: {
                    return "source";
                }
                case TARGET: {
                    return "target";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SOURCE: {
                    return "http://hl7.org/fhir/map-input-mode";
                }
                case TARGET: {
                    return "http://hl7.org/fhir/map-input-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SOURCE: {
                    return "Names an input instance used a source for mapping";
                }
                case TARGET: {
                    return "Names an instance that is being populated";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SOURCE: {
                    return "Source Instance";
                }
                case TARGET: {
                    return "Target Instance";
                }
            }
            return "?";
        }
    }

    public static class StructureMapGroupTypeModeEnumFactory
    implements EnumFactory<StructureMapGroupTypeMode> {
        @Override
        public StructureMapGroupTypeMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("none".equals(codeString)) {
                return StructureMapGroupTypeMode.NONE;
            }
            if ("types".equals(codeString)) {
                return StructureMapGroupTypeMode.TYPES;
            }
            if ("type-and-types".equals(codeString)) {
                return StructureMapGroupTypeMode.TYPEANDTYPES;
            }
            throw new IllegalArgumentException("Unknown StructureMapGroupTypeMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapGroupTypeMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureMapGroupTypeMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("none".equals(codeString)) {
                return new Enumeration<StructureMapGroupTypeMode>(this, StructureMapGroupTypeMode.NONE);
            }
            if ("types".equals(codeString)) {
                return new Enumeration<StructureMapGroupTypeMode>(this, StructureMapGroupTypeMode.TYPES);
            }
            if ("type-and-types".equals(codeString)) {
                return new Enumeration<StructureMapGroupTypeMode>(this, StructureMapGroupTypeMode.TYPEANDTYPES);
            }
            throw new FHIRException("Unknown StructureMapGroupTypeMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapGroupTypeMode code) {
            if (code == StructureMapGroupTypeMode.NONE) {
                return "none";
            }
            if (code == StructureMapGroupTypeMode.TYPES) {
                return "types";
            }
            if (code == StructureMapGroupTypeMode.TYPEANDTYPES) {
                return "type-and-types";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapGroupTypeMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapGroupTypeMode {
        NONE,
        TYPES,
        TYPEANDTYPES,
        NULL;


        public static StructureMapGroupTypeMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("none".equals(codeString)) {
                return NONE;
            }
            if ("types".equals(codeString)) {
                return TYPES;
            }
            if ("type-and-types".equals(codeString)) {
                return TYPEANDTYPES;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureMapGroupTypeMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NONE: {
                    return "none";
                }
                case TYPES: {
                    return "types";
                }
                case TYPEANDTYPES: {
                    return "type-and-types";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NONE: {
                    return "http://hl7.org/fhir/map-group-type-mode";
                }
                case TYPES: {
                    return "http://hl7.org/fhir/map-group-type-mode";
                }
                case TYPEANDTYPES: {
                    return "http://hl7.org/fhir/map-group-type-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NONE: {
                    return "This group is not a default group for the types";
                }
                case TYPES: {
                    return "This group is a default mapping group for the specified types and for the primary source type";
                }
                case TYPEANDTYPES: {
                    return "This group is a default mapping group for the specified types";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NONE: {
                    return "Not a Default";
                }
                case TYPES: {
                    return "Default for Type Combination";
                }
                case TYPEANDTYPES: {
                    return "Default for type + combination";
                }
            }
            return "?";
        }
    }

    public static class StructureMapModelModeEnumFactory
    implements EnumFactory<StructureMapModelMode> {
        @Override
        public StructureMapModelMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("source".equals(codeString)) {
                return StructureMapModelMode.SOURCE;
            }
            if ("queried".equals(codeString)) {
                return StructureMapModelMode.QUERIED;
            }
            if ("target".equals(codeString)) {
                return StructureMapModelMode.TARGET;
            }
            if ("produced".equals(codeString)) {
                return StructureMapModelMode.PRODUCED;
            }
            throw new IllegalArgumentException("Unknown StructureMapModelMode code '" + codeString + "'");
        }

        public Enumeration<StructureMapModelMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureMapModelMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.SOURCE);
            }
            if ("queried".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.QUERIED);
            }
            if ("target".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.TARGET);
            }
            if ("produced".equals(codeString)) {
                return new Enumeration<StructureMapModelMode>(this, StructureMapModelMode.PRODUCED);
            }
            throw new FHIRException("Unknown StructureMapModelMode code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureMapModelMode code) {
            if (code == StructureMapModelMode.SOURCE) {
                return "source";
            }
            if (code == StructureMapModelMode.QUERIED) {
                return "queried";
            }
            if (code == StructureMapModelMode.TARGET) {
                return "target";
            }
            if (code == StructureMapModelMode.PRODUCED) {
                return "produced";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureMapModelMode code) {
            return code.getSystem();
        }
    }

    public static enum StructureMapModelMode {
        SOURCE,
        QUERIED,
        TARGET,
        PRODUCED,
        NULL;


        public static StructureMapModelMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("source".equals(codeString)) {
                return SOURCE;
            }
            if ("queried".equals(codeString)) {
                return QUERIED;
            }
            if ("target".equals(codeString)) {
                return TARGET;
            }
            if ("produced".equals(codeString)) {
                return PRODUCED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureMapModelMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SOURCE: {
                    return "source";
                }
                case QUERIED: {
                    return "queried";
                }
                case TARGET: {
                    return "target";
                }
                case PRODUCED: {
                    return "produced";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SOURCE: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
                case QUERIED: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
                case TARGET: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
                case PRODUCED: {
                    return "http://hl7.org/fhir/map-model-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SOURCE: {
                    return "This structure describes an instance passed to the mapping engine that is used a source of data";
                }
                case QUERIED: {
                    return "This structure describes an instance that the mapping engine may ask for that is used a source of data";
                }
                case TARGET: {
                    return "This structure describes an instance passed to the mapping engine that is used a target of data";
                }
                case PRODUCED: {
                    return "This structure describes an instance that the mapping engine may ask to create that is used a target of data";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SOURCE: {
                    return "Source Structure Definition";
                }
                case QUERIED: {
                    return "Queried Structure Definition";
                }
                case TARGET: {
                    return "Target Structure Definition";
                }
                case PRODUCED: {
                    return "Produced Structure Definition";
                }
            }
            return "?";
        }
    }
}

