/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="HealthcareService", profile="http://hl7.org/fhir/Profile/HealthcareService")
public class HealthcareService
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifiers for this item", formalDefinition="External identifiers for this item.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this healthcareservice is in active use", formalDefinition="Whether this healthcareservice record is in active use.")
    protected BooleanType active;
    @Child(name="providedBy", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that provides this service", formalDefinition="The organization that provides this healthcare service.")
    protected Reference providedBy;
    protected Organization providedByTarget;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Broad category of service being performed or delivered", formalDefinition="Identifies the broad category of service being performed or delivered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-category")
    protected CodeableConcept category;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of service that may be delivered or performed", formalDefinition="The specific type of service that may be delivered or performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableConcept> type;
    @Child(name="specialty", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specialties handled by the HealthcareService", formalDefinition="Collection of specialties handled by the service site. This is more of a medical term.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="location", type={Location.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Location(s) where service may be provided", formalDefinition="The location(s) where this healthcare service may be provided.")
    protected List<Reference> location;
    protected List<Location> locationTarget;
    @Child(name="name", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of service as presented to a consumer while searching", formalDefinition="Further description of the service as it would be presented to a consumer while searching.")
    protected StringType name;
    @Child(name="comment", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional description and/or any specific issues not covered elsewhere", formalDefinition="Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.")
    protected StringType comment;
    @Child(name="extraDetails", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Extra details about the service that can't be placed in the other fields", formalDefinition="Extra details about the service that can't be placed in the other fields.")
    protected StringType extraDetails;
    @Child(name="photo", type={Attachment.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Facilitates quick identification of the service", formalDefinition="If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.")
    protected Attachment photo;
    @Child(name="telecom", type={ContactPoint.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contacts related to the healthcare service", formalDefinition="List of contacts related to this specific healthcare service.")
    protected List<ContactPoint> telecom;
    @Child(name="coverageArea", type={Location.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Location(s) service is inteded for/available to", formalDefinition="The location(s) that this service is available to (not where the service is provided).")
    protected List<Reference> coverageArea;
    protected List<Location> coverageAreaTarget;
    @Child(name="serviceProvisionCode", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Conditions under which service is available/offered", formalDefinition="The code(s) that detail the conditions under which the healthcare service is available/offered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-provision-conditions")
    protected List<CodeableConcept> serviceProvisionCode;
    @Child(name="eligibility", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Specific eligibility requirements required to use the service", formalDefinition="Does this service have specific eligibility requirements that need to be met in order to use the service?")
    protected CodeableConcept eligibility;
    @Child(name="eligibilityNote", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the eligibility conditions for the service", formalDefinition="Describes the eligibility conditions for the service.")
    protected StringType eligibilityNote;
    @Child(name="programName", type={StringType.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Program Names that categorize the service", formalDefinition="Program Names that can be used to categorize the service.")
    protected List<StringType> programName;
    @Child(name="characteristic", type={CodeableConcept.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Collection of characteristics (attributes)", formalDefinition="Collection of characteristics (attributes).")
    protected List<CodeableConcept> characteristic;
    @Child(name="referralMethod", type={CodeableConcept.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Ways that the service accepts referrals", formalDefinition="Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-referral-method")
    protected List<CodeableConcept> referralMethod;
    @Child(name="appointmentRequired", type={BooleanType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="If an appointment is required for access to this service", formalDefinition="Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.")
    protected BooleanType appointmentRequired;
    @Child(name="availableTime", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Times the Service Site is available", formalDefinition="A collection of times that the Service Site is available.")
    protected List<HealthcareServiceAvailableTimeComponent> availableTime;
    @Child(name="notAvailable", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Not available during this time due to provided reason", formalDefinition="The HealthcareService is not available during this period of time due to the provided reason.")
    protected List<HealthcareServiceNotAvailableComponent> notAvailable;
    @Child(name="availabilityExceptions", type={StringType.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of availability exceptions", formalDefinition="A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.")
    protected StringType availabilityExceptions;
    @Child(name="endpoint", type={Endpoint.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to services operated for the location", formalDefinition="Technical endpoints providing access to services operated for the specific healthcare services defined at this resource.")
    protected List<Reference> endpoint;
    protected List<Endpoint> endpointTarget;
    private static final long serialVersionUID = -202805485L;
    @SearchParamDefinition(name="identifier", path="HealthcareService.identifier", description="External identifiers for this item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="endpoint", path="HealthcareService.endpoint", description="Technical endpoints providing access to services operated for the location", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("HealthcareService:endpoint").toLocked();
    @SearchParamDefinition(name="organization", path="HealthcareService.providedBy", description="The organization that provides this Healthcare Service", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("HealthcareService:organization").toLocked();
    @SearchParamDefinition(name="name", path="HealthcareService.name", description="A portion of the Healthcare service name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="programname", path="HealthcareService.programName", description="One of the Program Names serviced by this HealthcareService", type="string")
    public static final String SP_PROGRAMNAME = "programname";
    public static final StringClientParam PROGRAMNAME = new StringClientParam("programname");
    @SearchParamDefinition(name="active", path="HealthcareService.active", description="The Healthcare Service is currently marked as active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="location", path="HealthcareService.location", description="The location of the Healthcare Service", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("HealthcareService:location").toLocked();
    @SearchParamDefinition(name="category", path="HealthcareService.category", description="Service Category of the Healthcare Service", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="type", path="HealthcareService.type", description="The type of service provided by this healthcare service", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="characteristic", path="HealthcareService.characteristic", description="One of the HealthcareService's characteristics", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public HealthcareService setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public HealthcareService addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public HealthcareService setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public HealthcareService setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Reference getProvidedBy() {
        if (this.providedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.providedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.providedBy = new Reference();
            }
        }
        return this.providedBy;
    }

    public boolean hasProvidedBy() {
        return this.providedBy != null && !this.providedBy.isEmpty();
    }

    public HealthcareService setProvidedBy(Reference value) {
        this.providedBy = value;
        return this;
    }

    public Organization getProvidedByTarget() {
        if (this.providedByTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.providedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.providedByTarget = new Organization();
            }
        }
        return this.providedByTarget;
    }

    public HealthcareService setProvidedByTarget(Organization value) {
        this.providedByTarget = value;
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public HealthcareService setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public HealthcareService setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public HealthcareService addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public HealthcareService setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public HealthcareService addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public HealthcareService setLocation(List<Reference> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (Reference item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLocation() {
        Reference t = new Reference();
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return t;
    }

    public HealthcareService addLocation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return this;
    }

    public Reference getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    @Deprecated
    public List<Location> getLocationTarget() {
        if (this.locationTarget == null) {
            this.locationTarget = new ArrayList<Location>();
        }
        return this.locationTarget;
    }

    @Deprecated
    public Location addLocationTarget() {
        Location r = new Location();
        if (this.locationTarget == null) {
            this.locationTarget = new ArrayList<Location>();
        }
        this.locationTarget.add(r);
        return r;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public HealthcareService setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public HealthcareService setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public HealthcareService setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public HealthcareService setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public StringType getExtraDetailsElement() {
        if (this.extraDetails == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.extraDetails");
            }
            if (Configuration.doAutoCreate()) {
                this.extraDetails = new StringType();
            }
        }
        return this.extraDetails;
    }

    public boolean hasExtraDetailsElement() {
        return this.extraDetails != null && !this.extraDetails.isEmpty();
    }

    public boolean hasExtraDetails() {
        return this.extraDetails != null && !this.extraDetails.isEmpty();
    }

    public HealthcareService setExtraDetailsElement(StringType value) {
        this.extraDetails = value;
        return this;
    }

    public String getExtraDetails() {
        return this.extraDetails == null ? null : (String)this.extraDetails.getValue();
    }

    public HealthcareService setExtraDetails(String value) {
        if (Utilities.noString((String)value)) {
            this.extraDetails = null;
        } else {
            if (this.extraDetails == null) {
                this.extraDetails = new StringType();
            }
            this.extraDetails.setValue(value);
        }
        return this;
    }

    public Attachment getPhoto() {
        if (this.photo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.photo");
            }
            if (Configuration.doAutoCreate()) {
                this.photo = new Attachment();
            }
        }
        return this.photo;
    }

    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    public HealthcareService setPhoto(Attachment value) {
        this.photo = value;
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public HealthcareService setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public HealthcareService addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<Reference> getCoverageArea() {
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        return this.coverageArea;
    }

    public HealthcareService setCoverageArea(List<Reference> theCoverageArea) {
        this.coverageArea = theCoverageArea;
        return this;
    }

    public boolean hasCoverageArea() {
        if (this.coverageArea == null) {
            return false;
        }
        for (Reference item : this.coverageArea) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCoverageArea() {
        Reference t = new Reference();
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return t;
    }

    public HealthcareService addCoverageArea(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return this;
    }

    public Reference getCoverageAreaFirstRep() {
        if (this.getCoverageArea().isEmpty()) {
            this.addCoverageArea();
        }
        return this.getCoverageArea().get(0);
    }

    @Deprecated
    public List<Location> getCoverageAreaTarget() {
        if (this.coverageAreaTarget == null) {
            this.coverageAreaTarget = new ArrayList<Location>();
        }
        return this.coverageAreaTarget;
    }

    @Deprecated
    public Location addCoverageAreaTarget() {
        Location r = new Location();
        if (this.coverageAreaTarget == null) {
            this.coverageAreaTarget = new ArrayList<Location>();
        }
        this.coverageAreaTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getServiceProvisionCode() {
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        return this.serviceProvisionCode;
    }

    public HealthcareService setServiceProvisionCode(List<CodeableConcept> theServiceProvisionCode) {
        this.serviceProvisionCode = theServiceProvisionCode;
        return this;
    }

    public boolean hasServiceProvisionCode() {
        if (this.serviceProvisionCode == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceProvisionCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceProvisionCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        this.serviceProvisionCode.add(t);
        return t;
    }

    public HealthcareService addServiceProvisionCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        this.serviceProvisionCode.add(t);
        return this;
    }

    public CodeableConcept getServiceProvisionCodeFirstRep() {
        if (this.getServiceProvisionCode().isEmpty()) {
            this.addServiceProvisionCode();
        }
        return this.getServiceProvisionCode().get(0);
    }

    public CodeableConcept getEligibility() {
        if (this.eligibility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.eligibility");
            }
            if (Configuration.doAutoCreate()) {
                this.eligibility = new CodeableConcept();
            }
        }
        return this.eligibility;
    }

    public boolean hasEligibility() {
        return this.eligibility != null && !this.eligibility.isEmpty();
    }

    public HealthcareService setEligibility(CodeableConcept value) {
        this.eligibility = value;
        return this;
    }

    public StringType getEligibilityNoteElement() {
        if (this.eligibilityNote == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.eligibilityNote");
            }
            if (Configuration.doAutoCreate()) {
                this.eligibilityNote = new StringType();
            }
        }
        return this.eligibilityNote;
    }

    public boolean hasEligibilityNoteElement() {
        return this.eligibilityNote != null && !this.eligibilityNote.isEmpty();
    }

    public boolean hasEligibilityNote() {
        return this.eligibilityNote != null && !this.eligibilityNote.isEmpty();
    }

    public HealthcareService setEligibilityNoteElement(StringType value) {
        this.eligibilityNote = value;
        return this;
    }

    public String getEligibilityNote() {
        return this.eligibilityNote == null ? null : (String)this.eligibilityNote.getValue();
    }

    public HealthcareService setEligibilityNote(String value) {
        if (Utilities.noString((String)value)) {
            this.eligibilityNote = null;
        } else {
            if (this.eligibilityNote == null) {
                this.eligibilityNote = new StringType();
            }
            this.eligibilityNote.setValue(value);
        }
        return this;
    }

    public List<StringType> getProgramName() {
        if (this.programName == null) {
            this.programName = new ArrayList<StringType>();
        }
        return this.programName;
    }

    public HealthcareService setProgramName(List<StringType> theProgramName) {
        this.programName = theProgramName;
        return this;
    }

    public boolean hasProgramName() {
        if (this.programName == null) {
            return false;
        }
        for (StringType item : this.programName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addProgramNameElement() {
        StringType t = new StringType();
        if (this.programName == null) {
            this.programName = new ArrayList<StringType>();
        }
        this.programName.add(t);
        return t;
    }

    public HealthcareService addProgramName(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.programName == null) {
            this.programName = new ArrayList<StringType>();
        }
        this.programName.add(t);
        return this;
    }

    public boolean hasProgramName(String value) {
        if (this.programName == null) {
            return false;
        }
        for (StringType v : this.programName) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeableConcept> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        return this.characteristic;
    }

    public HealthcareService setCharacteristic(List<CodeableConcept> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return t;
    }

    public HealthcareService addCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return this;
    }

    public CodeableConcept getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<CodeableConcept> getReferralMethod() {
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        return this.referralMethod;
    }

    public HealthcareService setReferralMethod(List<CodeableConcept> theReferralMethod) {
        this.referralMethod = theReferralMethod;
        return this;
    }

    public boolean hasReferralMethod() {
        if (this.referralMethod == null) {
            return false;
        }
        for (CodeableConcept item : this.referralMethod) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReferralMethod() {
        CodeableConcept t = new CodeableConcept();
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        this.referralMethod.add(t);
        return t;
    }

    public HealthcareService addReferralMethod(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        this.referralMethod.add(t);
        return this;
    }

    public CodeableConcept getReferralMethodFirstRep() {
        if (this.getReferralMethod().isEmpty()) {
            this.addReferralMethod();
        }
        return this.getReferralMethod().get(0);
    }

    public BooleanType getAppointmentRequiredElement() {
        if (this.appointmentRequired == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.appointmentRequired");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentRequired = new BooleanType();
            }
        }
        return this.appointmentRequired;
    }

    public boolean hasAppointmentRequiredElement() {
        return this.appointmentRequired != null && !this.appointmentRequired.isEmpty();
    }

    public boolean hasAppointmentRequired() {
        return this.appointmentRequired != null && !this.appointmentRequired.isEmpty();
    }

    public HealthcareService setAppointmentRequiredElement(BooleanType value) {
        this.appointmentRequired = value;
        return this;
    }

    public boolean getAppointmentRequired() {
        return this.appointmentRequired == null || this.appointmentRequired.isEmpty() ? false : (Boolean)this.appointmentRequired.getValue();
    }

    public HealthcareService setAppointmentRequired(boolean value) {
        if (this.appointmentRequired == null) {
            this.appointmentRequired = new BooleanType();
        }
        this.appointmentRequired.setValue((Object)value);
        return this;
    }

    public List<HealthcareServiceAvailableTimeComponent> getAvailableTime() {
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
        }
        return this.availableTime;
    }

    public HealthcareService setAvailableTime(List<HealthcareServiceAvailableTimeComponent> theAvailableTime) {
        this.availableTime = theAvailableTime;
        return this;
    }

    public boolean hasAvailableTime() {
        if (this.availableTime == null) {
            return false;
        }
        for (HealthcareServiceAvailableTimeComponent item : this.availableTime) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HealthcareServiceAvailableTimeComponent addAvailableTime() {
        HealthcareServiceAvailableTimeComponent t = new HealthcareServiceAvailableTimeComponent();
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return t;
    }

    public HealthcareService addAvailableTime(HealthcareServiceAvailableTimeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return this;
    }

    public HealthcareServiceAvailableTimeComponent getAvailableTimeFirstRep() {
        if (this.getAvailableTime().isEmpty()) {
            this.addAvailableTime();
        }
        return this.getAvailableTime().get(0);
    }

    public List<HealthcareServiceNotAvailableComponent> getNotAvailable() {
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
        }
        return this.notAvailable;
    }

    public HealthcareService setNotAvailable(List<HealthcareServiceNotAvailableComponent> theNotAvailable) {
        this.notAvailable = theNotAvailable;
        return this;
    }

    public boolean hasNotAvailable() {
        if (this.notAvailable == null) {
            return false;
        }
        for (HealthcareServiceNotAvailableComponent item : this.notAvailable) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HealthcareServiceNotAvailableComponent addNotAvailable() {
        HealthcareServiceNotAvailableComponent t = new HealthcareServiceNotAvailableComponent();
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return t;
    }

    public HealthcareService addNotAvailable(HealthcareServiceNotAvailableComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return this;
    }

    public HealthcareServiceNotAvailableComponent getNotAvailableFirstRep() {
        if (this.getNotAvailable().isEmpty()) {
            this.addNotAvailable();
        }
        return this.getNotAvailable().get(0);
    }

    public StringType getAvailabilityExceptionsElement() {
        if (this.availabilityExceptions == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.availabilityExceptions");
            }
            if (Configuration.doAutoCreate()) {
                this.availabilityExceptions = new StringType();
            }
        }
        return this.availabilityExceptions;
    }

    public boolean hasAvailabilityExceptionsElement() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public boolean hasAvailabilityExceptions() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public HealthcareService setAvailabilityExceptionsElement(StringType value) {
        this.availabilityExceptions = value;
        return this;
    }

    public String getAvailabilityExceptions() {
        return this.availabilityExceptions == null ? null : (String)this.availabilityExceptions.getValue();
    }

    public HealthcareService setAvailabilityExceptions(String value) {
        if (Utilities.noString((String)value)) {
            this.availabilityExceptions = null;
        } else {
            if (this.availabilityExceptions == null) {
                this.availabilityExceptions = new StringType();
            }
            this.availabilityExceptions.setValue(value);
        }
        return this;
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public HealthcareService setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public HealthcareService addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Deprecated
    public List<Endpoint> getEndpointTarget() {
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        return this.endpointTarget;
    }

    @Deprecated
    public Endpoint addEndpointTarget() {
        Endpoint r = new Endpoint();
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        this.endpointTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "External identifiers for this item.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether this healthcareservice record is in active use.", 0, 1, this.active));
        children.add(new Property("providedBy", "Reference(Organization)", "The organization that provides this healthcare service.", 0, 1, this.providedBy));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Identifies the broad category of service being performed or delivered.", 0, 1, this.category));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The specific type of service that may be delivered or performed.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("specialty", "CodeableConcept", "Collection of specialties handled by the service site. This is more of a medical term.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The location(s) where this healthcare service may be provided.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property(SP_NAME, "string", "Further description of the service as it would be presented to a consumer while searching.", 0, 1, this.name));
        children.add(new Property("comment", "string", "Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.", 0, 1, this.comment));
        children.add(new Property("extraDetails", "string", "Extra details about the service that can't be placed in the other fields.", 0, 1, this.extraDetails));
        children.add(new Property("photo", "Attachment", "If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.", 0, 1, this.photo));
        children.add(new Property("telecom", "ContactPoint", "List of contacts related to this specific healthcare service.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property("coverageArea", "Reference(Location)", "The location(s) that this service is available to (not where the service is provided).", 0, Integer.MAX_VALUE, this.coverageArea));
        children.add(new Property("serviceProvisionCode", "CodeableConcept", "The code(s) that detail the conditions under which the healthcare service is available/offered.", 0, Integer.MAX_VALUE, this.serviceProvisionCode));
        children.add(new Property("eligibility", "CodeableConcept", "Does this service have specific eligibility requirements that need to be met in order to use the service?", 0, 1, this.eligibility));
        children.add(new Property("eligibilityNote", "string", "Describes the eligibility conditions for the service.", 0, 1, this.eligibilityNote));
        children.add(new Property("programName", "string", "Program Names that can be used to categorize the service.", 0, Integer.MAX_VALUE, this.programName));
        children.add(new Property(SP_CHARACTERISTIC, "CodeableConcept", "Collection of characteristics (attributes).", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property("referralMethod", "CodeableConcept", "Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.", 0, Integer.MAX_VALUE, this.referralMethod));
        children.add(new Property("appointmentRequired", "boolean", "Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.", 0, 1, this.appointmentRequired));
        children.add(new Property("availableTime", "", "A collection of times that the Service Site is available.", 0, Integer.MAX_VALUE, this.availableTime));
        children.add(new Property("notAvailable", "", "The HealthcareService is not available during this period of time due to the provided reason.", 0, Integer.MAX_VALUE, this.notAvailable));
        children.add(new Property("availabilityExceptions", "string", "A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.", 0, 1, this.availabilityExceptions));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the specific healthcare services defined at this resource.", 0, Integer.MAX_VALUE, this.endpoint));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "External identifiers for this item.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether this healthcareservice record is in active use.", 0, 1, this.active);
            }
            case 205136282: {
                return new Property("providedBy", "Reference(Organization)", "The organization that provides this healthcare service.", 0, 1, this.providedBy);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Identifies the broad category of service being performed or delivered.", 0, 1, this.category);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The specific type of service that may be delivered or performed.", 0, Integer.MAX_VALUE, this.type);
            }
            case -1694759682: {
                return new Property("specialty", "CodeableConcept", "Collection of specialties handled by the service site. This is more of a medical term.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The location(s) where this healthcare service may be provided.", 0, Integer.MAX_VALUE, this.location);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Further description of the service as it would be presented to a consumer while searching.", 0, 1, this.name);
            }
            case 950398559: {
                return new Property("comment", "string", "Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.", 0, 1, this.comment);
            }
            case -1469168622: {
                return new Property("extraDetails", "string", "Extra details about the service that can't be placed in the other fields.", 0, 1, this.extraDetails);
            }
            case 106642994: {
                return new Property("photo", "Attachment", "If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.", 0, 1, this.photo);
            }
            case -1429363305: {
                return new Property("telecom", "ContactPoint", "List of contacts related to this specific healthcare service.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case -1532328299: {
                return new Property("coverageArea", "Reference(Location)", "The location(s) that this service is available to (not where the service is provided).", 0, Integer.MAX_VALUE, this.coverageArea);
            }
            case 1504575405: {
                return new Property("serviceProvisionCode", "CodeableConcept", "The code(s) that detail the conditions under which the healthcare service is available/offered.", 0, Integer.MAX_VALUE, this.serviceProvisionCode);
            }
            case -930847859: {
                return new Property("eligibility", "CodeableConcept", "Does this service have specific eligibility requirements that need to be met in order to use the service?", 0, 1, this.eligibility);
            }
            case 1635973407: {
                return new Property("eligibilityNote", "string", "Describes the eligibility conditions for the service.", 0, 1, this.eligibilityNote);
            }
            case 1010379567: {
                return new Property("programName", "string", "Program Names that can be used to categorize the service.", 0, Integer.MAX_VALUE, this.programName);
            }
            case 366313883: {
                return new Property(SP_CHARACTERISTIC, "CodeableConcept", "Collection of characteristics (attributes).", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case -2092740898: {
                return new Property("referralMethod", "CodeableConcept", "Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.", 0, Integer.MAX_VALUE, this.referralMethod);
            }
            case 427220062: {
                return new Property("appointmentRequired", "boolean", "Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.", 0, 1, this.appointmentRequired);
            }
            case 1873069366: {
                return new Property("availableTime", "", "A collection of times that the Service Site is available.", 0, Integer.MAX_VALUE, this.availableTime);
            }
            case -629572298: {
                return new Property("notAvailable", "", "The HealthcareService is not available during this period of time due to the provided reason.", 0, Integer.MAX_VALUE, this.notAvailable);
            }
            case -1149143617: {
                return new Property("availabilityExceptions", "string", "A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.", 0, 1, this.availabilityExceptions);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the specific healthcare services defined at this resource.", 0, Integer.MAX_VALUE, this.endpoint);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 205136282: {
                Base[] baseArray;
                if (this.providedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.providedBy;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.comment;
                }
                return baseArray;
            }
            case -1469168622: {
                Base[] baseArray;
                if (this.extraDetails == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.extraDetails;
                }
                return baseArray;
            }
            case 106642994: {
                Base[] baseArray;
                if (this.photo == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.photo;
                }
                return baseArray;
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1532328299: {
                return this.coverageArea == null ? new Base[]{} : this.coverageArea.toArray(new Base[this.coverageArea.size()]);
            }
            case 1504575405: {
                return this.serviceProvisionCode == null ? new Base[]{} : this.serviceProvisionCode.toArray(new Base[this.serviceProvisionCode.size()]);
            }
            case -930847859: {
                Base[] baseArray;
                if (this.eligibility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.eligibility;
                }
                return baseArray;
            }
            case 1635973407: {
                Base[] baseArray;
                if (this.eligibilityNote == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.eligibilityNote;
                }
                return baseArray;
            }
            case 1010379567: {
                return this.programName == null ? new Base[]{} : this.programName.toArray(new Base[this.programName.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case -2092740898: {
                return this.referralMethod == null ? new Base[]{} : this.referralMethod.toArray(new Base[this.referralMethod.size()]);
            }
            case 427220062: {
                Base[] baseArray;
                if (this.appointmentRequired == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.appointmentRequired;
                }
                return baseArray;
            }
            case 1873069366: {
                return this.availableTime == null ? new Base[]{} : this.availableTime.toArray(new Base[this.availableTime.size()]);
            }
            case -629572298: {
                return this.notAvailable == null ? new Base[]{} : this.notAvailable.toArray(new Base[this.notAvailable.size()]);
            }
            case -1149143617: {
                Base[] baseArray;
                if (this.availabilityExceptions == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.availabilityExceptions;
                }
                return baseArray;
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case 205136282: {
                this.providedBy = this.castToReference(value);
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1901043637: {
                this.getLocation().add(this.castToReference(value));
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
            case -1469168622: {
                this.extraDetails = this.castToString(value);
                return value;
            }
            case 106642994: {
                this.photo = this.castToAttachment(value);
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                return value;
            }
            case -1532328299: {
                this.getCoverageArea().add(this.castToReference(value));
                return value;
            }
            case 1504575405: {
                this.getServiceProvisionCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -930847859: {
                this.eligibility = this.castToCodeableConcept(value);
                return value;
            }
            case 1635973407: {
                this.eligibilityNote = this.castToString(value);
                return value;
            }
            case 1010379567: {
                this.getProgramName().add(this.castToString(value));
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -2092740898: {
                this.getReferralMethod().add(this.castToCodeableConcept(value));
                return value;
            }
            case 427220062: {
                this.appointmentRequired = this.castToBoolean(value);
                return value;
            }
            case 1873069366: {
                this.getAvailableTime().add((HealthcareServiceAvailableTimeComponent)value);
                return value;
            }
            case -629572298: {
                this.getNotAvailable().add((HealthcareServiceNotAvailableComponent)value);
                return value;
            }
            case -1149143617: {
                this.availabilityExceptions = this.castToString(value);
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals("providedBy")) {
            this.providedBy = this.castToReference(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals("specialty")) {
            this.getSpecialty().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add(this.castToReference(value));
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals("extraDetails")) {
            this.extraDetails = this.castToString(value);
        } else if (name.equals("photo")) {
            this.photo = this.castToAttachment(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals("coverageArea")) {
            this.getCoverageArea().add(this.castToReference(value));
        } else if (name.equals("serviceProvisionCode")) {
            this.getServiceProvisionCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("eligibility")) {
            this.eligibility = this.castToCodeableConcept(value);
        } else if (name.equals("eligibilityNote")) {
            this.eligibilityNote = this.castToString(value);
        } else if (name.equals("programName")) {
            this.getProgramName().add(this.castToString(value));
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().add(this.castToCodeableConcept(value));
        } else if (name.equals("referralMethod")) {
            this.getReferralMethod().add(this.castToCodeableConcept(value));
        } else if (name.equals("appointmentRequired")) {
            this.appointmentRequired = this.castToBoolean(value);
        } else if (name.equals("availableTime")) {
            this.getAvailableTime().add((HealthcareServiceAvailableTimeComponent)value);
        } else if (name.equals("notAvailable")) {
            this.getNotAvailable().add((HealthcareServiceNotAvailableComponent)value);
        } else if (name.equals("availabilityExceptions")) {
            this.availabilityExceptions = this.castToString(value);
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 205136282: {
                return this.getProvidedBy();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 3575610: {
                return this.addType();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case -1469168622: {
                return this.getExtraDetailsElement();
            }
            case 106642994: {
                return this.getPhoto();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1532328299: {
                return this.addCoverageArea();
            }
            case 1504575405: {
                return this.addServiceProvisionCode();
            }
            case -930847859: {
                return this.getEligibility();
            }
            case 1635973407: {
                return this.getEligibilityNoteElement();
            }
            case 1010379567: {
                return this.addProgramNameElement();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case -2092740898: {
                return this.addReferralMethod();
            }
            case 427220062: {
                return this.getAppointmentRequiredElement();
            }
            case 1873069366: {
                return this.addAvailableTime();
            }
            case -629572298: {
                return this.addNotAvailable();
            }
            case -1149143617: {
                return this.getAvailabilityExceptionsElement();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 205136282: {
                return new String[]{"Reference"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
            case -1469168622: {
                return new String[]{"string"};
            }
            case 106642994: {
                return new String[]{"Attachment"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case -1532328299: {
                return new String[]{"Reference"};
            }
            case 1504575405: {
                return new String[]{"CodeableConcept"};
            }
            case -930847859: {
                return new String[]{"CodeableConcept"};
            }
            case 1635973407: {
                return new String[]{"string"};
            }
            case 1010379567: {
                return new String[]{"string"};
            }
            case 366313883: {
                return new String[]{"CodeableConcept"};
            }
            case -2092740898: {
                return new String[]{"CodeableConcept"};
            }
            case 427220062: {
                return new String[]{"boolean"};
            }
            case 1873069366: {
                return new String[0];
            }
            case -629572298: {
                return new String[0];
            }
            case -1149143617: {
                return new String[]{"string"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.active");
        }
        if (name.equals("providedBy")) {
            this.providedBy = new Reference();
            return this.providedBy;
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals("specialty")) {
            return this.addSpecialty();
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.name");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.comment");
        }
        if (name.equals("extraDetails")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.extraDetails");
        }
        if (name.equals("photo")) {
            this.photo = new Attachment();
            return this.photo;
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals("coverageArea")) {
            return this.addCoverageArea();
        }
        if (name.equals("serviceProvisionCode")) {
            return this.addServiceProvisionCode();
        }
        if (name.equals("eligibility")) {
            this.eligibility = new CodeableConcept();
            return this.eligibility;
        }
        if (name.equals("eligibilityNote")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.eligibilityNote");
        }
        if (name.equals("programName")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.programName");
        }
        if (name.equals(SP_CHARACTERISTIC)) {
            return this.addCharacteristic();
        }
        if (name.equals("referralMethod")) {
            return this.addReferralMethod();
        }
        if (name.equals("appointmentRequired")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.appointmentRequired");
        }
        if (name.equals("availableTime")) {
            return this.addAvailableTime();
        }
        if (name.equals("notAvailable")) {
            return this.addNotAvailable();
        }
        if (name.equals("availabilityExceptions")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.availabilityExceptions");
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "HealthcareService";
    }

    @Override
    public HealthcareService copy() {
        HealthcareService dst = new HealthcareService();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.providedBy = this.providedBy == null ? null : this.providedBy.copy();
        CodeableConcept codeableConcept = dst.category = this.category == null ? null : this.category.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.type) {
                dst.type.add(codeableConcept2.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.specialty) {
                dst.specialty.add(codeableConcept3.copy());
            }
        }
        if (this.location != null) {
            dst.location = new ArrayList<Reference>();
            for (Reference reference : this.location) {
                dst.location.add(reference.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.extraDetails = this.extraDetails == null ? null : this.extraDetails.copy();
        Attachment attachment = dst.photo = this.photo == null ? null : this.photo.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.coverageArea != null) {
            dst.coverageArea = new ArrayList<Reference>();
            for (Reference reference : this.coverageArea) {
                dst.coverageArea.add(reference.copy());
            }
        }
        if (this.serviceProvisionCode != null) {
            dst.serviceProvisionCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.serviceProvisionCode) {
                dst.serviceProvisionCode.add(codeableConcept4.copy());
            }
        }
        dst.eligibility = this.eligibility == null ? null : this.eligibility.copy();
        StringType stringType = dst.eligibilityNote = this.eligibilityNote == null ? null : this.eligibilityNote.copy();
        if (this.programName != null) {
            dst.programName = new ArrayList<StringType>();
            for (StringType stringType2 : this.programName) {
                dst.programName.add(stringType2.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept5 : this.characteristic) {
                dst.characteristic.add(codeableConcept5.copy());
            }
        }
        if (this.referralMethod != null) {
            dst.referralMethod = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept6 : this.referralMethod) {
                dst.referralMethod.add(codeableConcept6.copy());
            }
        }
        BooleanType booleanType = dst.appointmentRequired = this.appointmentRequired == null ? null : this.appointmentRequired.copy();
        if (this.availableTime != null) {
            dst.availableTime = new ArrayList<HealthcareServiceAvailableTimeComponent>();
            for (HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : this.availableTime) {
                dst.availableTime.add(healthcareServiceAvailableTimeComponent.copy());
            }
        }
        if (this.notAvailable != null) {
            dst.notAvailable = new ArrayList<HealthcareServiceNotAvailableComponent>();
            for (HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : this.notAvailable) {
                dst.notAvailable.add(healthcareServiceNotAvailableComponent.copy());
            }
        }
        StringType stringType3 = dst.availabilityExceptions = this.availabilityExceptions == null ? null : this.availabilityExceptions.copy();
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference : this.endpoint) {
                dst.endpoint.add(reference.copy());
            }
        }
        return dst;
    }

    protected HealthcareService typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof HealthcareService)) {
            return false;
        }
        HealthcareService o = (HealthcareService)other_;
        return HealthcareService.compareDeep(this.identifier, o.identifier, true) && HealthcareService.compareDeep(this.active, o.active, true) && HealthcareService.compareDeep(this.providedBy, o.providedBy, true) && HealthcareService.compareDeep(this.category, o.category, true) && HealthcareService.compareDeep(this.type, o.type, true) && HealthcareService.compareDeep(this.specialty, o.specialty, true) && HealthcareService.compareDeep(this.location, o.location, true) && HealthcareService.compareDeep(this.name, o.name, true) && HealthcareService.compareDeep(this.comment, o.comment, true) && HealthcareService.compareDeep(this.extraDetails, o.extraDetails, true) && HealthcareService.compareDeep(this.photo, o.photo, true) && HealthcareService.compareDeep(this.telecom, o.telecom, true) && HealthcareService.compareDeep(this.coverageArea, o.coverageArea, true) && HealthcareService.compareDeep(this.serviceProvisionCode, o.serviceProvisionCode, true) && HealthcareService.compareDeep(this.eligibility, o.eligibility, true) && HealthcareService.compareDeep(this.eligibilityNote, o.eligibilityNote, true) && HealthcareService.compareDeep(this.programName, o.programName, true) && HealthcareService.compareDeep(this.characteristic, o.characteristic, true) && HealthcareService.compareDeep(this.referralMethod, o.referralMethod, true) && HealthcareService.compareDeep(this.appointmentRequired, o.appointmentRequired, true) && HealthcareService.compareDeep(this.availableTime, o.availableTime, true) && HealthcareService.compareDeep(this.notAvailable, o.notAvailable, true) && HealthcareService.compareDeep(this.availabilityExceptions, o.availabilityExceptions, true) && HealthcareService.compareDeep(this.endpoint, o.endpoint, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof HealthcareService)) {
            return false;
        }
        HealthcareService o = (HealthcareService)other_;
        return HealthcareService.compareValues(this.active, o.active, true) && HealthcareService.compareValues(this.name, o.name, true) && HealthcareService.compareValues(this.comment, o.comment, true) && HealthcareService.compareValues(this.extraDetails, o.extraDetails, true) && HealthcareService.compareValues(this.eligibilityNote, o.eligibilityNote, true) && HealthcareService.compareValues(this.programName, o.programName, true) && HealthcareService.compareValues(this.appointmentRequired, o.appointmentRequired, true) && HealthcareService.compareValues(this.availabilityExceptions, o.availabilityExceptions, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.providedBy, this.category, this.type, this.specialty, this.location, this.name, this.comment, this.extraDetails, this.photo, this.telecom, this.coverageArea, this.serviceProvisionCode, this.eligibility, this.eligibilityNote, this.programName, this.characteristic, this.referralMethod, this.appointmentRequired, this.availableTime, this.notAvailable, this.availabilityExceptions, this.endpoint});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.HealthcareService;
    }

    @Block
    public static class HealthcareServiceNotAvailableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason presented to the user explaining why time not available", formalDefinition="The reason that can be presented to the user as to why this time is not available.")
        protected StringType description;
        @Child(name="during", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service not availablefrom this date", formalDefinition="Service is not available (seasonally or for a public holiday) from this date.")
        protected Period during;
        private static final long serialVersionUID = 310849929L;

        public HealthcareServiceNotAvailableComponent() {
        }

        public HealthcareServiceNotAvailableComponent(StringType description) {
            this.description = description;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceNotAvailableComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public HealthcareServiceNotAvailableComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public HealthcareServiceNotAvailableComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public Period getDuring() {
            if (this.during == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceNotAvailableComponent.during");
                }
                if (Configuration.doAutoCreate()) {
                    this.during = new Period();
                }
            }
            return this.during;
        }

        public boolean hasDuring() {
            return this.during != null && !this.during.isEmpty();
        }

        public HealthcareServiceNotAvailableComponent setDuring(Period value) {
            this.during = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "The reason that can be presented to the user as to why this time is not available.", 0, 1, this.description));
            children.add(new Property("during", "Period", "Service is not available (seasonally or for a public holiday) from this date.", 0, 1, this.during));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "The reason that can be presented to the user as to why this time is not available.", 0, 1, this.description);
                }
                case -1320499647: {
                    return new Property("during", "Period", "Service is not available (seasonally or for a public holiday) from this date.", 0, 1, this.during);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1320499647: {
                    Base[] baseArray;
                    if (this.during == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.during;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1320499647: {
                    this.during = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("during")) {
                this.during = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1320499647: {
                    return this.getDuring();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1320499647: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.description");
            }
            if (name.equals("during")) {
                this.during = new Period();
                return this.during;
            }
            return super.addChild(name);
        }

        @Override
        public HealthcareServiceNotAvailableComponent copy() {
            HealthcareServiceNotAvailableComponent dst = new HealthcareServiceNotAvailableComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.during = this.during == null ? null : this.during.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof HealthcareServiceNotAvailableComponent)) {
                return false;
            }
            HealthcareServiceNotAvailableComponent o = (HealthcareServiceNotAvailableComponent)other_;
            return HealthcareServiceNotAvailableComponent.compareDeep(this.description, o.description, true) && HealthcareServiceNotAvailableComponent.compareDeep(this.during, o.during, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof HealthcareServiceNotAvailableComponent)) {
                return false;
            }
            HealthcareServiceNotAvailableComponent o = (HealthcareServiceNotAvailableComponent)other_;
            return HealthcareServiceNotAvailableComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.during});
        }

        @Override
        public String fhirType() {
            return "HealthcareService.notAvailable";
        }
    }

    @Block
    public static class HealthcareServiceAvailableTimeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="daysOfWeek", type={CodeType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="mon | tue | wed | thu | fri | sat | sun", formalDefinition="Indicates which days of the week are available between the start and end Times.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/days-of-week")
        protected List<Enumeration<DaysOfWeek>> daysOfWeek;
        @Child(name="allDay", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Always available? e.g. 24 hour service", formalDefinition="Is this always available? (hence times are irrelevant) e.g. 24 hour service.")
        protected BooleanType allDay;
        @Child(name="availableStartTime", type={TimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Opening time of day (ignored if allDay = true)", formalDefinition="The opening time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableStartTime;
        @Child(name="availableEndTime", type={TimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Closing time of day (ignored if allDay = true)", formalDefinition="The closing time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableEndTime;
        private static final long serialVersionUID = -2139510127L;

        public List<Enumeration<DaysOfWeek>> getDaysOfWeek() {
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            return this.daysOfWeek;
        }

        public HealthcareServiceAvailableTimeComponent setDaysOfWeek(List<Enumeration<DaysOfWeek>> theDaysOfWeek) {
            this.daysOfWeek = theDaysOfWeek;
            return this;
        }

        public boolean hasDaysOfWeek() {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<DaysOfWeek> item : this.daysOfWeek) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<DaysOfWeek> addDaysOfWeekElement() {
            Enumeration<DaysOfWeek> t = new Enumeration<DaysOfWeek>(new DaysOfWeekEnumFactory());
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return t;
        }

        public HealthcareServiceAvailableTimeComponent addDaysOfWeek(DaysOfWeek value) {
            Enumeration<DaysOfWeek> t = new Enumeration<DaysOfWeek>(new DaysOfWeekEnumFactory());
            t.setValue((Object)value);
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return this;
        }

        public boolean hasDaysOfWeek(DaysOfWeek value) {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<DaysOfWeek> v : this.daysOfWeek) {
                if (!((DaysOfWeek)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public BooleanType getAllDayElement() {
            if (this.allDay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceAvailableTimeComponent.allDay");
                }
                if (Configuration.doAutoCreate()) {
                    this.allDay = new BooleanType();
                }
            }
            return this.allDay;
        }

        public boolean hasAllDayElement() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public boolean hasAllDay() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public HealthcareServiceAvailableTimeComponent setAllDayElement(BooleanType value) {
            this.allDay = value;
            return this;
        }

        public boolean getAllDay() {
            return this.allDay == null || this.allDay.isEmpty() ? false : (Boolean)this.allDay.getValue();
        }

        public HealthcareServiceAvailableTimeComponent setAllDay(boolean value) {
            if (this.allDay == null) {
                this.allDay = new BooleanType();
            }
            this.allDay.setValue((Object)value);
            return this;
        }

        public TimeType getAvailableStartTimeElement() {
            if (this.availableStartTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceAvailableTimeComponent.availableStartTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableStartTime = new TimeType();
                }
            }
            return this.availableStartTime;
        }

        public boolean hasAvailableStartTimeElement() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public boolean hasAvailableStartTime() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableStartTimeElement(TimeType value) {
            this.availableStartTime = value;
            return this;
        }

        public String getAvailableStartTime() {
            return this.availableStartTime == null ? null : (String)this.availableStartTime.getValue();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableStartTime(String value) {
            if (value == null) {
                this.availableStartTime = null;
            } else {
                if (this.availableStartTime == null) {
                    this.availableStartTime = new TimeType();
                }
                this.availableStartTime.setValue(value);
            }
            return this;
        }

        public TimeType getAvailableEndTimeElement() {
            if (this.availableEndTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceAvailableTimeComponent.availableEndTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableEndTime = new TimeType();
                }
            }
            return this.availableEndTime;
        }

        public boolean hasAvailableEndTimeElement() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public boolean hasAvailableEndTime() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableEndTimeElement(TimeType value) {
            this.availableEndTime = value;
            return this;
        }

        public String getAvailableEndTime() {
            return this.availableEndTime == null ? null : (String)this.availableEndTime.getValue();
        }

        public HealthcareServiceAvailableTimeComponent setAvailableEndTime(String value) {
            if (value == null) {
                this.availableEndTime = null;
            } else {
                if (this.availableEndTime == null) {
                    this.availableEndTime = new TimeType();
                }
                this.availableEndTime.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("daysOfWeek", "code", "Indicates which days of the week are available between the start and end Times.", 0, Integer.MAX_VALUE, this.daysOfWeek));
            children.add(new Property("allDay", "boolean", "Is this always available? (hence times are irrelevant) e.g. 24 hour service.", 0, 1, this.allDay));
            children.add(new Property("availableStartTime", "time", "The opening time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableStartTime));
            children.add(new Property("availableEndTime", "time", "The closing time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableEndTime));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 68050338: {
                    return new Property("daysOfWeek", "code", "Indicates which days of the week are available between the start and end Times.", 0, Integer.MAX_VALUE, this.daysOfWeek);
                }
                case -1414913477: {
                    return new Property("allDay", "boolean", "Is this always available? (hence times are irrelevant) e.g. 24 hour service.", 0, 1, this.allDay);
                }
                case -1039453818: {
                    return new Property("availableStartTime", "time", "The opening time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableStartTime);
                }
                case 101151551: {
                    return new Property("availableEndTime", "time", "The closing time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableEndTime);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return this.daysOfWeek == null ? new Base[]{} : this.daysOfWeek.toArray(new Base[this.daysOfWeek.size()]);
                }
                case -1414913477: {
                    Base[] baseArray;
                    if (this.allDay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.allDay;
                    }
                    return baseArray;
                }
                case -1039453818: {
                    Base[] baseArray;
                    if (this.availableStartTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.availableStartTime;
                    }
                    return baseArray;
                }
                case 101151551: {
                    Base[] baseArray;
                    if (this.availableEndTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.availableEndTime;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    value = new DaysOfWeekEnumFactory().fromType(this.castToCode(value));
                    this.getDaysOfWeek().add(value);
                    return value;
                }
                case -1414913477: {
                    this.allDay = this.castToBoolean(value);
                    return value;
                }
                case -1039453818: {
                    this.availableStartTime = this.castToTime(value);
                    return value;
                }
                case 101151551: {
                    this.availableEndTime = this.castToTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                value = new DaysOfWeekEnumFactory().fromType(this.castToCode(value));
                this.getDaysOfWeek().add(value);
            } else if (name.equals("allDay")) {
                this.allDay = this.castToBoolean(value);
            } else if (name.equals("availableStartTime")) {
                this.availableStartTime = this.castToTime(value);
            } else if (name.equals("availableEndTime")) {
                this.availableEndTime = this.castToTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return this.addDaysOfWeekElement();
                }
                case -1414913477: {
                    return this.getAllDayElement();
                }
                case -1039453818: {
                    return this.getAvailableStartTimeElement();
                }
                case 101151551: {
                    return this.getAvailableEndTimeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return new String[]{"code"};
                }
                case -1414913477: {
                    return new String[]{"boolean"};
                }
                case -1039453818: {
                    return new String[]{"time"};
                }
                case 101151551: {
                    return new String[]{"time"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.daysOfWeek");
            }
            if (name.equals("allDay")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.allDay");
            }
            if (name.equals("availableStartTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.availableStartTime");
            }
            if (name.equals("availableEndTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.availableEndTime");
            }
            return super.addChild(name);
        }

        @Override
        public HealthcareServiceAvailableTimeComponent copy() {
            HealthcareServiceAvailableTimeComponent dst = new HealthcareServiceAvailableTimeComponent();
            this.copyValues(dst);
            if (this.daysOfWeek != null) {
                dst.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
                for (Enumeration<DaysOfWeek> i : this.daysOfWeek) {
                    dst.daysOfWeek.add((Enumeration<DaysOfWeek>)i.copy());
                }
            }
            dst.allDay = this.allDay == null ? null : this.allDay.copy();
            dst.availableStartTime = this.availableStartTime == null ? null : this.availableStartTime.copy();
            dst.availableEndTime = this.availableEndTime == null ? null : this.availableEndTime.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof HealthcareServiceAvailableTimeComponent)) {
                return false;
            }
            HealthcareServiceAvailableTimeComponent o = (HealthcareServiceAvailableTimeComponent)other_;
            return HealthcareServiceAvailableTimeComponent.compareDeep(this.daysOfWeek, o.daysOfWeek, true) && HealthcareServiceAvailableTimeComponent.compareDeep(this.allDay, o.allDay, true) && HealthcareServiceAvailableTimeComponent.compareDeep(this.availableStartTime, o.availableStartTime, true) && HealthcareServiceAvailableTimeComponent.compareDeep(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof HealthcareServiceAvailableTimeComponent)) {
                return false;
            }
            HealthcareServiceAvailableTimeComponent o = (HealthcareServiceAvailableTimeComponent)other_;
            return HealthcareServiceAvailableTimeComponent.compareValues(this.daysOfWeek, o.daysOfWeek, true) && HealthcareServiceAvailableTimeComponent.compareValues(this.allDay, o.allDay, true) && HealthcareServiceAvailableTimeComponent.compareValues(this.availableStartTime, o.availableStartTime, true) && HealthcareServiceAvailableTimeComponent.compareValues(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.daysOfWeek, this.allDay, this.availableStartTime, this.availableEndTime});
        }

        @Override
        public String fhirType() {
            return "HealthcareService.availableTime";
        }
    }

    public static class DaysOfWeekEnumFactory
    implements EnumFactory<DaysOfWeek> {
        @Override
        public DaysOfWeek fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return DaysOfWeek.MON;
            }
            if ("tue".equals(codeString)) {
                return DaysOfWeek.TUE;
            }
            if ("wed".equals(codeString)) {
                return DaysOfWeek.WED;
            }
            if ("thu".equals(codeString)) {
                return DaysOfWeek.THU;
            }
            if ("fri".equals(codeString)) {
                return DaysOfWeek.FRI;
            }
            if ("sat".equals(codeString)) {
                return DaysOfWeek.SAT;
            }
            if ("sun".equals(codeString)) {
                return DaysOfWeek.SUN;
            }
            throw new IllegalArgumentException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        public Enumeration<DaysOfWeek> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DaysOfWeek>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.MON);
            }
            if ("tue".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.TUE);
            }
            if ("wed".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.WED);
            }
            if ("thu".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.THU);
            }
            if ("fri".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.FRI);
            }
            if ("sat".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.SAT);
            }
            if ("sun".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.SUN);
            }
            throw new FHIRException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        @Override
        public String toCode(DaysOfWeek code) {
            if (code == DaysOfWeek.MON) {
                return "mon";
            }
            if (code == DaysOfWeek.TUE) {
                return "tue";
            }
            if (code == DaysOfWeek.WED) {
                return "wed";
            }
            if (code == DaysOfWeek.THU) {
                return "thu";
            }
            if (code == DaysOfWeek.FRI) {
                return "fri";
            }
            if (code == DaysOfWeek.SAT) {
                return "sat";
            }
            if (code == DaysOfWeek.SUN) {
                return "sun";
            }
            return "?";
        }

        @Override
        public String toSystem(DaysOfWeek code) {
            return code.getSystem();
        }
    }

    public static enum DaysOfWeek {
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT,
        SUN,
        NULL;


        public static DaysOfWeek fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return MON;
            }
            if ("tue".equals(codeString)) {
                return TUE;
            }
            if ("wed".equals(codeString)) {
                return WED;
            }
            if ("thu".equals(codeString)) {
                return THU;
            }
            if ("fri".equals(codeString)) {
                return FRI;
            }
            if ("sat".equals(codeString)) {
                return SAT;
            }
            if ("sun".equals(codeString)) {
                return SUN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MON: {
                    return "mon";
                }
                case TUE: {
                    return "tue";
                }
                case WED: {
                    return "wed";
                }
                case THU: {
                    return "thu";
                }
                case FRI: {
                    return "fri";
                }
                case SAT: {
                    return "sat";
                }
                case SUN: {
                    return "sun";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MON: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case TUE: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case WED: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case THU: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case FRI: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SAT: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SUN: {
                    return "http://hl7.org/fhir/days-of-week";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }
    }
}

