/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.context;

import ca.uhn.fhir.parser.DataFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.dstu3.conformance.ProfileUtilities;
import org.hl7.fhir.dstu3.context.BaseWorkerContext;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.ParserType;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.NamingSystem;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpansionCache;
import org.hl7.fhir.dstu3.utils.INarrativeGenerator;
import org.hl7.fhir.dstu3.utils.IResourceValidator;
import org.hl7.fhir.dstu3.utils.NarrativeGenerator;
import org.hl7.fhir.dstu3.utils.client.FHIRToolingClient;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.OIDUtils;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SimpleWorkerContext
extends BaseWorkerContext
implements IWorkerContext,
ProfileUtilities.ProfileKnowledgeProvider {
    private Map<String, StructureDefinition> structures = new HashMap<String, StructureDefinition>();
    private List<NamingSystem> systems = new ArrayList<NamingSystem>();
    private Questionnaire questionnaire;
    private Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    private String version;
    private String revision;
    private String date;
    private IValidatorFactory validatorFactory;

    public static SimpleWorkerContext fromPack(String path) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path, null);
        return res;
    }

    public static SimpleWorkerContext fromPack(String path, boolean allowDuplicates) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.allowLoadingDuplicates = allowDuplicates;
        res.loadFromPack(path, null);
        return res;
    }

    public static SimpleWorkerContext fromPack(String path, IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path, loader);
        return res;
    }

    public static SimpleWorkerContext fromClassPath() throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(SimpleWorkerContext.class.getResourceAsStream("validation.json.zip"), null);
        return res;
    }

    public static SimpleWorkerContext fromClassPath(String name) throws IOException, FHIRException {
        InputStream s = SimpleWorkerContext.class.getResourceAsStream("/" + name);
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(s, null);
        return res;
    }

    public static SimpleWorkerContext fromDefinitions(Map<String, byte[]> source) throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        for (String name : source.keySet()) {
            res.loadDefinitionItem(name, new ByteArrayInputStream(source.get(name)), null);
        }
        return res;
    }

    private void loadDefinitionItem(String name, InputStream stream, IContextResourceLoader loader) throws IOException, FHIRException {
        if (name.endsWith(".xml")) {
            this.loadFromFile(stream, name, loader);
        } else if (name.endsWith(".json")) {
            this.loadFromFileJson(stream, name, loader);
        } else if (name.equals("version.info")) {
            this.readVersionInfo(stream);
        } else {
            this.loadBytes(name, stream);
        }
    }

    public String connectToTSServer(String url) throws URISyntaxException {
        this.txServer = new FHIRToolingClient(url);
        this.txServer.setTimeout(30000);
        return this.txServer.getCapabilitiesStatementQuick().getSoftware().getVersion();
    }

    public void loadFromFile(InputStream stream, String name, IContextResourceLoader loader) throws IOException, FHIRException {
        Resource f;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, false);
            } else {
                XmlParser xml = new XmlParser();
                f = xml.parse(stream);
            }
        }
        catch (DataFormatException e1) {
            throw new FHIRFormatError("Error parsing " + name + ":" + e1.getMessage(), (Throwable)e1);
        }
        catch (Exception e1) {
            throw new FHIRFormatError("Error parsing " + name + ":" + e1.getMessage(), (Throwable)e1);
        }
        if (f instanceof Bundle) {
            Resource bnd = f;
            for (Bundle.BundleEntryComponent e : ((Bundle)bnd).getEntry()) {
                if (e.getFullUrl() == null) {
                    this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.CONTEXT, "unidentified resource in " + name + " (no fullUrl)");
                }
                this.seeResource(e.getFullUrl(), e.getResource());
            }
        } else if (f instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)f;
            this.seeResource(m.getUrl(), m);
        }
    }

    private void loadFromFileJson(InputStream stream, String name, IContextResourceLoader loader) throws IOException, FHIRException {
        Bundle f;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, true);
            } else {
                JsonParser json = new JsonParser();
                f = (Bundle)json.parse(stream);
            }
        }
        catch (FHIRFormatError e1) {
            throw new FHIRFormatError(e1.getMessage(), (Throwable)e1);
        }
        for (Bundle.BundleEntryComponent e : f.getEntry()) {
            if (e.getFullUrl() == null) {
                this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.CONTEXT, "unidentified resource in " + name + " (no fullUrl)");
            }
            this.seeResource(e.getFullUrl(), e.getResource());
        }
    }

    public void seeResource(String url, Resource r) throws FHIRException {
        if (r instanceof StructureDefinition) {
            this.seeProfile(url, (StructureDefinition)r);
        } else if (r instanceof ValueSet) {
            this.seeValueSet(url, (ValueSet)r);
        } else if (r instanceof CodeSystem) {
            this.seeCodeSystem(url, (CodeSystem)r);
        } else if (r instanceof OperationDefinition) {
            this.seeOperationDefinition(url, (OperationDefinition)r);
        } else if (r instanceof ConceptMap) {
            this.maps.put(((ConceptMap)r).getUrl(), (ConceptMap)r);
        } else if (r instanceof StructureMap) {
            this.transforms.put(((StructureMap)r).getUrl(), (StructureMap)r);
        } else if (r instanceof NamingSystem) {
            this.systems.add((NamingSystem)r);
        }
    }

    private void seeOperationDefinition(String url, OperationDefinition r) {
        this.operations.put(r.getUrl(), r);
    }

    @Override
    public void seeValueSet(String url, ValueSet vs) throws DefinitionException {
        if (Utilities.noString((String)url)) {
            url = vs.getUrl();
        }
        if (this.valueSets.containsKey(vs.getUrl()) && !this.allowLoadingDuplicates) {
            throw new DefinitionException("Duplicate Profile " + vs.getUrl());
        }
        this.valueSets.put(vs.getId(), vs);
        this.valueSets.put(vs.getUrl(), vs);
        if (!vs.getUrl().equals(url)) {
            this.valueSets.put(url, vs);
        }
    }

    @Override
    public void seeProfile(String url, StructureDefinition p) throws FHIRException {
        if (Utilities.noString((String)url)) {
            url = p.getUrl();
        }
        if (!p.hasSnapshot() && p.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            if (!p.hasBaseDefinition()) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") has no base and no snapshot");
            }
            StructureDefinition sd = this.fetchResource(StructureDefinition.class, p.getBaseDefinition());
            if (sd == null) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") base " + p.getBaseDefinition() + " could not be resolved");
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ArrayList<String> errors = new ArrayList<String>();
            ProfileUtilities pu = new ProfileUtilities(this, msgs, this);
            pu.sortDifferential(sd, p, url, errors);
            for (String err : errors) {
                msgs.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.EXCEPTION, p.getUserString("path"), "Error sorting Differential: " + err, ValidationMessage.IssueSeverity.ERROR));
            }
            pu.generateSnapshot(sd, p, p.getUrl(), p.getName());
            for (ValidationMessage msg : msgs) {
                if (msg.getLevel() != ValidationMessage.IssueSeverity.ERROR && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot: " + msg.getMessage());
            }
            if (!p.hasSnapshot()) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot");
            }
            pu = null;
        }
        if (this.structures.containsKey(p.getUrl()) && !this.allowLoadingDuplicates) {
            throw new DefinitionException("Duplicate structures " + p.getUrl());
        }
        this.structures.put(p.getId(), p);
        this.structures.put(p.getUrl(), p);
        if (!p.getUrl().equals(url)) {
            this.structures.put(url, p);
        }
    }

    private void loadFromPack(String path, IContextResourceLoader loader) throws FileNotFoundException, IOException, FHIRException {
        this.loadFromStream((InputStream)new CSFileInputStream(path), loader);
    }

    public void loadFromFile(String file, IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadDefinitionItem(file, (InputStream)new CSFileInputStream(file), loader);
    }

    private void loadFromStream(InputStream stream, IContextResourceLoader loader) throws IOException, FHIRException {
        ZipEntry ze;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            this.loadDefinitionItem(ze.getName(), zip, loader);
            zip.closeEntry();
        }
        zip.close();
    }

    private void readVersionInfo(InputStream stream) throws IOException, DefinitionException {
        String[] vi;
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        this.binaries.put("version.info", bytes);
        for (String s : vi = new String(bytes).split("\\r?\\n")) {
            if (s.startsWith("version=")) {
                if (this.version == null) {
                    this.version = s.substring(8);
                } else if (!this.version.equals(s.substring(8))) {
                    throw new DefinitionException("Version mismatch. The context has version " + this.version + " loaded, and the new content being loaded is version " + s.substring(8));
                }
            }
            if (s.startsWith("revision=")) {
                this.revision = s.substring(9);
            }
            if (!s.startsWith("date=")) continue;
            this.date = s.substring(5);
        }
    }

    private void loadBytes(String name, InputStream stream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        this.binaries.put(name, bytes);
    }

    @Override
    public IParser getParser(ParserType type) {
        switch (type) {
            case JSON: {
                return this.newJsonParser();
            }
            case XML: {
                return this.newXmlParser();
            }
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser getParser(String type) {
        if (type.equalsIgnoreCase("JSON")) {
            return new JsonParser();
        }
        if (type.equalsIgnoreCase("XML")) {
            return new XmlParser();
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser newJsonParser() {
        return new JsonParser();
    }

    @Override
    public IParser newXmlParser() {
        return new XmlParser();
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResource(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
        return new NarrativeGenerator(prefix, basePath, this);
    }

    @Override
    public IResourceValidator newValidator() throws FHIRException {
        if (this.validatorFactory == null) {
            throw new Error("No validator configured");
        }
        return this.validatorFactory.makeValidator(this);
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        if (class_ == null) {
            return null;
        }
        if (class_ == Questionnaire.class) {
            return (T)this.questionnaire;
        }
        if (class_ == StructureDefinition.class && !uri.contains("/")) {
            uri = "http://hl7.org/fhir/StructureDefinition/" + uri;
        }
        if (uri.startsWith("http:") || uri.startsWith("urn:")) {
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (class_ == Resource.class) {
                if (this.structures.containsKey(uri)) {
                    return (T)this.structures.get(uri);
                }
                if (this.valueSets.containsKey(uri)) {
                    return (T)((Resource)this.valueSets.get(uri));
                }
                if (this.codeSystems.containsKey(uri)) {
                    return (T)((Resource)this.codeSystems.get(uri));
                }
                if (this.operations.containsKey(uri)) {
                    return (T)((Resource)this.operations.get(uri));
                }
                if (this.searchParameters.containsKey(uri)) {
                    return (T)((Resource)this.searchParameters.get(uri));
                }
                if (this.maps.containsKey(uri)) {
                    return (T)((Resource)this.maps.get(uri));
                }
                if (this.transforms.containsKey(uri)) {
                    return (T)((Resource)this.transforms.get(uri));
                }
                return null;
            }
            if (class_ == StructureDefinition.class) {
                if (this.structures.containsKey(uri)) {
                    return (T)this.structures.get(uri);
                }
                return null;
            }
            if (class_ == ValueSet.class) {
                if (this.valueSets.containsKey(uri)) {
                    return (T)((Resource)this.valueSets.get(uri));
                }
                return null;
            }
            if (class_ == CodeSystem.class) {
                if (this.codeSystems.containsKey(uri)) {
                    return (T)((Resource)this.codeSystems.get(uri));
                }
                return null;
            }
            if (class_ == OperationDefinition.class) {
                OperationDefinition od = (OperationDefinition)this.operations.get(uri);
                return (T)od;
            }
            if (class_ == SearchParameter.class) {
                SearchParameter od = (SearchParameter)this.searchParameters.get(uri);
                return (T)od;
            }
            if (class_ == ConceptMap.class) {
                if (this.maps.containsKey(uri)) {
                    return (T)((Resource)this.maps.get(uri));
                }
                return null;
            }
            if (class_ == StructureMap.class) {
                if (this.transforms.containsKey(uri)) {
                    return (T)((Resource)this.transforms.get(uri));
                }
                return null;
            }
        }
        throw new FHIRException("fetching " + class_.getName() + " not done yet for URI '" + uri + "'");
    }

    public int totalCount() {
        return this.valueSets.size() + this.maps.size() + this.structures.size() + this.transforms.size();
    }

    public void setCache(ValueSetExpansionCache cache) {
        this.expansionCache = cache;
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.structures.values()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> getTypeNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.structures.values()) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getAbbreviation(String name) {
        return "xxx";
    }

    @Override
    public boolean isDatatype(String typeSimple) {
        return false;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        try {
            sd = this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String corePath, String typeSimple) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, ElementDefinition.ElementDefinitionBindingComponent binding, String path) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    @Override
    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> result = new ArrayList<StructureDefinition>();
        HashSet<StructureDefinition> set = new HashSet<StructureDefinition>();
        for (StructureDefinition sd : this.structures.values()) {
            if (set.contains(sd)) continue;
            result.add(sd);
            set.add(sd);
        }
        return result;
    }

    @Override
    public List<MetadataResource> allConformanceResources() {
        ArrayList<MetadataResource> result = new ArrayList<MetadataResource>();
        result.addAll(this.structures.values());
        result.addAll(this.codeSystems.values());
        result.addAll(this.valueSets.values());
        result.addAll(this.maps.values());
        result.addAll(this.transforms.values());
        return result;
    }

    @Override
    public String oid2Uri(String oid) {
        String uri = OIDUtils.getUriForOid((String)oid);
        if (uri != null) {
            return uri;
        }
        for (NamingSystem ns : this.systems) {
            if (!this.hasOid(ns, oid) || (uri = this.getUri(ns)) == null) continue;
            return null;
        }
        return null;
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    public void loadFromFolder(String folder) throws FileNotFoundException, Exception {
        for (String n : new File(folder).list()) {
            if (n.endsWith(".json")) {
                this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new JsonParser());
                continue;
            }
            if (!n.endsWith(".xml")) continue;
            this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new XmlParser());
        }
    }

    private void loadFromFile(String filename, IParser p) throws FileNotFoundException, Exception {
        try {
            Resource r = p.parse(new FileInputStream(filename));
            if (r.getResourceType() == ResourceType.Bundle) {
                for (Bundle.BundleEntryComponent e : ((Bundle)r).getEntry()) {
                    this.seeResource(null, e.getResource());
                }
            } else {
                this.seeResource(null, r);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public Map<String, byte[]> getBinaries() {
        return this.binaries;
    }

    @Override
    public boolean prependLinks() {
        return false;
    }

    @Override
    public boolean hasCache() {
        return false;
    }

    @Override
    public String getVersion() {
        return this.version + "-" + this.revision;
    }

    public Map<String, StructureMap> getTransforms() {
        return this.transforms;
    }

    public List<StructureMap> findTransformsforSource(String url) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        for (StructureMap map : this.transforms.values()) {
            boolean match = false;
            boolean ok = true;
            for (StructureMap.StructureMapStructureComponent t : map.getStructure()) {
                if (t.getMode() != StructureMap.StructureMapModelMode.SOURCE) continue;
                match = match || t.getUrl().equals(url);
                ok = ok && t.getUrl().equals(url);
            }
            if (!match || !ok) continue;
            res.add(map);
        }
        return res;
    }

    public IValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(IValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public static interface IValidatorFactory {
        public IResourceValidator makeValidator(IWorkerContext var1) throws FHIRException;
    }

    public static interface IContextResourceLoader {
        public Bundle loadBundle(InputStream var1, boolean var2) throws FHIRException, IOException;
    }
}

