/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;

public class PKIHeader
extends ASN1Encodable {
    private DERInteger pvno;
    private GeneralName sender;
    private GeneralName recipient;
    private DERGeneralizedTime messageTime;
    private AlgorithmIdentifier protectionAlg;
    private ASN1OctetString senderKID;
    private ASN1OctetString recipKID;
    private ASN1OctetString transactionID;
    private ASN1OctetString senderNonce;
    private ASN1OctetString recipNonce;
    private PKIFreeText freeText;
    private ASN1Sequence generalInfo;

    private PKIHeader(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.pvno = DERInteger.getInstance(enumeration.nextElement());
        this.sender = GeneralName.getInstance(enumeration.nextElement());
        this.recipient = GeneralName.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.messageTime = DERGeneralizedTime.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 1: {
                    this.protectionAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 2: {
                    this.senderKID = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 3: {
                    this.recipKID = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 4: {
                    this.transactionID = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 5: {
                    this.senderNonce = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 6: {
                    this.recipNonce = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 7: {
                    this.freeText = PKIFreeText.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 8: {
                    this.generalInfo = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
                }
            }
        }
    }

    public static PKIHeader getInstance(Object object) {
        if (object instanceof PKIHeader) {
            return (PKIHeader)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PKIHeader((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public DERInteger getPvno() {
        return this.pvno;
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public GeneralName getRecipient() {
        return this.recipient;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.pvno);
        aSN1EncodableVector.add(this.sender);
        aSN1EncodableVector.add(this.recipient);
        this.addOptional(aSN1EncodableVector, 0, this.messageTime);
        this.addOptional(aSN1EncodableVector, 1, this.protectionAlg);
        this.addOptional(aSN1EncodableVector, 2, this.senderKID);
        this.addOptional(aSN1EncodableVector, 3, this.recipKID);
        this.addOptional(aSN1EncodableVector, 4, this.transactionID);
        this.addOptional(aSN1EncodableVector, 5, this.senderNonce);
        this.addOptional(aSN1EncodableVector, 6, this.recipNonce);
        this.addOptional(aSN1EncodableVector, 7, this.freeText);
        this.addOptional(aSN1EncodableVector, 8, this.generalInfo);
        return new DERSequence(aSN1EncodableVector);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n, aSN1Encodable));
        }
    }
}

