/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="AvgPool3DGrad", inputsClass=Inputs.class)
public final class AvgPool3dGrad<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "AvgPool3DGrad";
    private Output<T> output;

    public AvgPool3dGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> AvgPool3dGrad<T> create(Scope scope, Operand<TInt32> origInputShape, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "AvgPool3dGrad");
        opBuilder.addInput(origInputShape.asOutput());
        opBuilder.addInput(grad.asOutput());
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat == null) continue;
                opBuilder.setAttr("data_format", opts.dataFormat);
            }
        }
        return new AvgPool3dGrad<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=AvgPool3dGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<AvgPool3dGrad<T>> {
        public final Operand<TInt32> origInputShape;
        public final Operand<T> grad;
        public final long[] ksize;
        public final long[] strides;
        public final String padding;
        public final String dataFormat;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new AvgPool3dGrad(op), op, Arrays.asList("ksize", "strides", "padding", "data_format", "T"));
            int inputIndex = 0;
            this.origInputShape = op.input(inputIndex++);
            this.grad = op.input(inputIndex++);
            this.ksize = op.attributes().getAttrIntList("ksize");
            this.strides = op.attributes().getAttrIntList("strides");
            this.padding = op.attributes().getAttrString("padding");
            this.dataFormat = op.attributes().getAttrString("data_format");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private String dataFormat;

        private Options() {
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }
    }
}

