/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseMatrixSoftmax", inputsClass=Inputs.class)
public final class SparseMatrixSoftmax
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SparseMatrixSoftmax";
    private Output<? extends TType> softmax;

    public SparseMatrixSoftmax(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.softmax = operation.output(outputIdx++);
    }

    public static <T extends TNumber> SparseMatrixSoftmax create(Scope scope, Operand<? extends TType> logits, Class<T> type) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(logits.asOutput());
        opBuilder.setAttr("type", Operands.toDataType(type));
        return new SparseMatrixSoftmax(opBuilder.build());
    }

    public Output<? extends TType> softmax() {
        return this.softmax;
    }

    @Override
    public Output<TType> asOutput() {
        return this.softmax;
    }

    @OpInputsMetadata(outputsClass=SparseMatrixSoftmax.class)
    public static class Inputs
    extends RawOpInputs<SparseMatrixSoftmax> {
        public final Operand<? extends TType> logits;
        public final DataType type;

        public Inputs(GraphOperation op) {
            super(new SparseMatrixSoftmax(op), op, Arrays.asList("type"));
            int inputIndex = 0;
            this.logits = op.input(inputIndex++);
            this.type = op.attributes().getAttrType("type");
        }
    }
}

