/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.nn.AvgPool;
import org.tensorflow.op.nn.AvgPool3d;
import org.tensorflow.op.nn.AvgPool3dGrad;
import org.tensorflow.op.nn.AvgPoolGrad;
import org.tensorflow.op.nn.BatchNormWithGlobalNormalization;
import org.tensorflow.op.nn.BatchNormWithGlobalNormalizationGrad;
import org.tensorflow.op.nn.BiasAdd;
import org.tensorflow.op.nn.BiasAddGrad;
import org.tensorflow.op.nn.BlockLSTM;
import org.tensorflow.op.nn.BlockLSTMGrad;
import org.tensorflow.op.nn.CTCLossV2;
import org.tensorflow.op.nn.ComputeAccidentalHits;
import org.tensorflow.op.nn.Conv;
import org.tensorflow.op.nn.Conv2d;
import org.tensorflow.op.nn.Conv2dBackpropFilter;
import org.tensorflow.op.nn.Conv2dBackpropInput;
import org.tensorflow.op.nn.Conv3d;
import org.tensorflow.op.nn.Conv3dBackpropFilter;
import org.tensorflow.op.nn.Conv3dBackpropInput;
import org.tensorflow.op.nn.CtcBeamSearchDecoder;
import org.tensorflow.op.nn.CtcGreedyDecoder;
import org.tensorflow.op.nn.CtcLoss;
import org.tensorflow.op.nn.CudnnRNN;
import org.tensorflow.op.nn.CudnnRNNBackprop;
import org.tensorflow.op.nn.CudnnRNNCanonicalToParams;
import org.tensorflow.op.nn.CudnnRNNParamsToCanonical;
import org.tensorflow.op.nn.CudnnRnnParamsSize;
import org.tensorflow.op.nn.DataFormatDimMap;
import org.tensorflow.op.nn.DataFormatVecPermute;
import org.tensorflow.op.nn.DepthToSpace;
import org.tensorflow.op.nn.DepthwiseConv2dNative;
import org.tensorflow.op.nn.DepthwiseConv2dNativeBackpropFilter;
import org.tensorflow.op.nn.DepthwiseConv2dNativeBackpropInput;
import org.tensorflow.op.nn.Dilation2d;
import org.tensorflow.op.nn.Dilation2dBackpropFilter;
import org.tensorflow.op.nn.Dilation2dBackpropInput;
import org.tensorflow.op.nn.Elu;
import org.tensorflow.op.nn.EluGrad;
import org.tensorflow.op.nn.FixedUnigramCandidateSampler;
import org.tensorflow.op.nn.FractionalAvgPool;
import org.tensorflow.op.nn.FractionalAvgPoolGrad;
import org.tensorflow.op.nn.FractionalMaxPool;
import org.tensorflow.op.nn.FractionalMaxPoolGrad;
import org.tensorflow.op.nn.FusedBatchNorm;
import org.tensorflow.op.nn.FusedBatchNormGrad;
import org.tensorflow.op.nn.FusedPadConv2d;
import org.tensorflow.op.nn.FusedResizeAndPadConv2d;
import org.tensorflow.op.nn.GRUBlockCell;
import org.tensorflow.op.nn.GRUBlockCellGrad;
import org.tensorflow.op.nn.InTopK;
import org.tensorflow.op.nn.InvGrad;
import org.tensorflow.op.nn.IsotonicRegression;
import org.tensorflow.op.nn.L2Loss;
import org.tensorflow.op.nn.LSTMBlockCell;
import org.tensorflow.op.nn.LSTMBlockCellGrad;
import org.tensorflow.op.nn.LeakyRelu;
import org.tensorflow.op.nn.LearnedUnigramCandidateSampler;
import org.tensorflow.op.nn.LocalResponseNormalization;
import org.tensorflow.op.nn.LocalResponseNormalizationGrad;
import org.tensorflow.op.nn.LogSoftmax;
import org.tensorflow.op.nn.MaxPool;
import org.tensorflow.op.nn.MaxPool3d;
import org.tensorflow.op.nn.MaxPool3dGrad;
import org.tensorflow.op.nn.MaxPool3dGradGrad;
import org.tensorflow.op.nn.MaxPoolGrad;
import org.tensorflow.op.nn.MaxPoolGradGrad;
import org.tensorflow.op.nn.MaxPoolGradGradWithArgmax;
import org.tensorflow.op.nn.MaxPoolGradWithArgmax;
import org.tensorflow.op.nn.MaxPoolWithArgmax;
import org.tensorflow.op.nn.NthElement;
import org.tensorflow.op.nn.QuantizedAvgPool;
import org.tensorflow.op.nn.QuantizedBatchNormWithGlobalNormalization;
import org.tensorflow.op.nn.QuantizedBiasAdd;
import org.tensorflow.op.nn.QuantizedConv2DAndRelu;
import org.tensorflow.op.nn.QuantizedConv2DAndReluAndRequantize;
import org.tensorflow.op.nn.QuantizedConv2DAndRequantize;
import org.tensorflow.op.nn.QuantizedConv2DPerChannel;
import org.tensorflow.op.nn.QuantizedConv2DWithBias;
import org.tensorflow.op.nn.QuantizedConv2DWithBiasAndRelu;
import org.tensorflow.op.nn.QuantizedConv2DWithBiasAndReluAndRequantize;
import org.tensorflow.op.nn.QuantizedConv2DWithBiasAndRequantize;
import org.tensorflow.op.nn.QuantizedConv2DWithBiasSignedSumAndReluAndRequantize;
import org.tensorflow.op.nn.QuantizedConv2DWithBiasSumAndRelu;
import org.tensorflow.op.nn.QuantizedConv2DWithBiasSumAndReluAndRequantize;
import org.tensorflow.op.nn.QuantizedConv2d;
import org.tensorflow.op.nn.QuantizedDepthwiseConv2D;
import org.tensorflow.op.nn.QuantizedDepthwiseConv2DWithBias;
import org.tensorflow.op.nn.QuantizedDepthwiseConv2DWithBiasAndRelu;
import org.tensorflow.op.nn.QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize;
import org.tensorflow.op.nn.QuantizedInstanceNorm;
import org.tensorflow.op.nn.QuantizedMaxPool;
import org.tensorflow.op.nn.QuantizedRelu;
import org.tensorflow.op.nn.QuantizedRelu6;
import org.tensorflow.op.nn.QuantizedReluX;
import org.tensorflow.op.nn.Relu;
import org.tensorflow.op.nn.Relu6;
import org.tensorflow.op.nn.Relu6Grad;
import org.tensorflow.op.nn.ReluGrad;
import org.tensorflow.op.nn.Selu;
import org.tensorflow.op.nn.SeluGrad;
import org.tensorflow.op.nn.Softmax;
import org.tensorflow.op.nn.SoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.nn.Softsign;
import org.tensorflow.op.nn.SoftsignGrad;
import org.tensorflow.op.nn.SpaceToBatch;
import org.tensorflow.op.nn.SpaceToDepth;
import org.tensorflow.op.nn.SparseSoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.nn.TopK;
import org.tensorflow.op.nn.UniformQuantizedConvolution;
import org.tensorflow.op.nn.UniformQuantizedConvolutionHybrid;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class NnOps {
    private final Scope scope;
    private final Ops ops;

    NnOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <T extends TNumber> AvgPool<T> avgPool(Operand<T> value, List<Long> ksize, List<Long> strides, String padding, AvgPool.Options ... options) {
        return AvgPool.create(this.scope, value, ksize, strides, padding, options);
    }

    public <T extends TNumber> AvgPool3d<T> avgPool3d(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, AvgPool3d.Options ... options) {
        return AvgPool3d.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends TNumber> AvgPool3dGrad<T> avgPool3dGrad(Operand<TInt32> origInputShape, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, AvgPool3dGrad.Options ... options) {
        return AvgPool3dGrad.create(this.scope, origInputShape, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> AvgPoolGrad<T> avgPoolGrad(Operand<TInt32> origInputShape, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, AvgPoolGrad.Options ... options) {
        return AvgPoolGrad.create(this.scope, origInputShape, grad, ksize, strides, padding, options);
    }

    public <T extends TType> BatchNormWithGlobalNormalization<T> batchNormWithGlobalNormalization(Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> beta, Operand<T> gamma, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return BatchNormWithGlobalNormalization.create(this.scope, t, m, v, beta, gamma, varianceEpsilon, scaleAfterNormalization);
    }

    public <T extends TType> BatchNormWithGlobalNormalizationGrad<T> batchNormWithGlobalNormalizationGrad(Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> gamma, Operand<T> backprop, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return BatchNormWithGlobalNormalizationGrad.create(this.scope, t, m, v, gamma, backprop, varianceEpsilon, scaleAfterNormalization);
    }

    public <T extends TType> BiasAdd<T> biasAdd(Operand<T> value, Operand<T> bias, BiasAdd.Options ... options) {
        return BiasAdd.create(this.scope, value, bias, options);
    }

    public <T extends TType> BiasAddGrad<T> biasAddGrad(Operand<T> outBackprop, BiasAddGrad.Options ... options) {
        return BiasAddGrad.create(this.scope, outBackprop, options);
    }

    public <T extends TNumber> BlockLSTM<T> blockLSTM(Operand<TInt64> seqLenMax, Operand<T> x, Operand<T> csPrev, Operand<T> hPrev, Operand<T> w, Operand<T> wci, Operand<T> wcf, Operand<T> wco, Operand<T> b, BlockLSTM.Options ... options) {
        return BlockLSTM.create(this.scope, seqLenMax, x, csPrev, hPrev, w, wci, wcf, wco, b, options);
    }

    public <T extends TNumber> BlockLSTMGrad<T> blockLSTMGrad(Operand<TInt64> seqLenMax, Operand<T> x, Operand<T> csPrev, Operand<T> hPrev, Operand<T> w, Operand<T> wci, Operand<T> wcf, Operand<T> wco, Operand<T> b, Operand<T> i, Operand<T> cs, Operand<T> f, Operand<T> o, Operand<T> ci, Operand<T> co, Operand<T> h, Operand<T> csGrad, Operand<T> hGrad, Boolean usePeephole) {
        return BlockLSTMGrad.create(this.scope, seqLenMax, x, csPrev, hPrev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, h, csGrad, hGrad, usePeephole);
    }

    public CTCLossV2 cTCLossV2(Operand<TFloat32> inputs, Operand<TInt64> labelsIndices, Operand<TInt32> labelsValues, Operand<TInt32> sequenceLength, CTCLossV2.Options ... options) {
        return CTCLossV2.create(this.scope, inputs, labelsIndices, labelsValues, sequenceLength, options);
    }

    public ComputeAccidentalHits computeAccidentalHits(Operand<TInt64> trueClasses, Operand<TInt64> sampledCandidates, Long numTrue, ComputeAccidentalHits.Options ... options) {
        return ComputeAccidentalHits.create(this.scope, trueClasses, sampledCandidates, numTrue, options);
    }

    public <T extends TNumber> Conv<T> conv(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Conv.Options ... options) {
        return Conv.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends TNumber> Conv2d<T> conv2d(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Conv2d.Options ... options) {
        return Conv2d.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends TNumber> Conv2dBackpropFilter<T> conv2dBackpropFilter(Operand<T> input, Operand<TInt32> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Conv2dBackpropFilter.Options ... options) {
        return Conv2dBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> Conv2dBackpropInput<T> conv2dBackpropInput(Operand<TInt32> inputSizes, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding, Conv2dBackpropInput.Options ... options) {
        return Conv2dBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> Conv3d<T> conv3d(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Conv3d.Options ... options) {
        return Conv3d.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends TNumber> Conv3dBackpropFilter<T> conv3dBackpropFilter(Operand<T> input, Operand<TInt32> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Conv3dBackpropFilter.Options ... options) {
        return Conv3dBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <U extends TNumber> Conv3dBackpropInput<U> conv3dBackpropInput(Operand<? extends TNumber> inputSizes, Operand<U> filter, Operand<U> outBackprop, List<Long> strides, String padding, Conv3dBackpropInput.Options ... options) {
        return Conv3dBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> CtcBeamSearchDecoder<T> ctcBeamSearchDecoder(Operand<T> inputs, Operand<TInt32> sequenceLength, Long beamWidth, Long topPaths, CtcBeamSearchDecoder.Options ... options) {
        return CtcBeamSearchDecoder.create(this.scope, inputs, sequenceLength, beamWidth, topPaths, options);
    }

    public <T extends TNumber> CtcGreedyDecoder<T> ctcGreedyDecoder(Operand<T> inputs, Operand<TInt32> sequenceLength, CtcGreedyDecoder.Options ... options) {
        return CtcGreedyDecoder.create(this.scope, inputs, sequenceLength, options);
    }

    public <T extends TNumber> CtcLoss<T> ctcLoss(Operand<T> inputs, Operand<TInt64> labelsIndices, Operand<TInt32> labelsValues, Operand<TInt32> sequenceLength, CtcLoss.Options ... options) {
        return CtcLoss.create(this.scope, inputs, labelsIndices, labelsValues, sequenceLength, options);
    }

    public <T extends TNumber> CudnnRNN<T> cudnnRNN(Operand<T> input, Operand<T> inputH, Operand<T> inputC, Operand<T> params, Operand<TInt32> sequenceLengths, CudnnRNN.Options ... options) {
        return CudnnRNN.create(this.scope, input, inputH, inputC, params, sequenceLengths, options);
    }

    public <T extends TNumber> CudnnRNNBackprop<T> cudnnRNNBackprop(Operand<T> input, Operand<T> inputH, Operand<T> inputC, Operand<T> params, Operand<TInt32> sequenceLengths, Operand<T> output, Operand<T> outputH, Operand<T> outputC, Operand<T> outputBackprop, Operand<T> outputHBackprop, Operand<T> outputCBackprop, Operand<T> reserveSpace, Operand<? extends TType> hostReserved, CudnnRNNBackprop.Options ... options) {
        return CudnnRNNBackprop.create(this.scope, input, inputH, inputC, params, sequenceLengths, output, outputH, outputC, outputBackprop, outputHBackprop, outputCBackprop, reserveSpace, hostReserved, options);
    }

    public <T extends TNumber> CudnnRNNCanonicalToParams<T> cudnnRNNCanonicalToParams(Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, Iterable<Operand<T>> weights, Iterable<Operand<T>> biases, CudnnRNNCanonicalToParams.Options ... options) {
        return CudnnRNNCanonicalToParams.create(this.scope, numLayers, numUnits, inputSize, weights, biases, options);
    }

    public <T extends TNumber> CudnnRNNParamsToCanonical<T> cudnnRNNParamsToCanonical(Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, Operand<T> params, Long numParamsWeights, Long numParamsBiases, CudnnRNNParamsToCanonical.Options ... options) {
        return CudnnRNNParamsToCanonical.create(this.scope, numLayers, numUnits, inputSize, params, numParamsWeights, numParamsBiases, options);
    }

    public <T extends TNumber, U extends TNumber> CudnnRnnParamsSize<T> cudnnRnnParamsSize(Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, Class<U> T, Class<T> S, CudnnRnnParamsSize.Options ... options) {
        return CudnnRnnParamsSize.create(this.scope, numLayers, numUnits, inputSize, T, S, options);
    }

    public <T extends TNumber> DataFormatDimMap<T> dataFormatDimMap(Operand<T> x, DataFormatDimMap.Options ... options) {
        return DataFormatDimMap.create(this.scope, x, options);
    }

    public <T extends TNumber> DataFormatVecPermute<T> dataFormatVecPermute(Operand<T> x, DataFormatVecPermute.Options ... options) {
        return DataFormatVecPermute.create(this.scope, x, options);
    }

    public <T extends TType> DepthToSpace<T> depthToSpace(Operand<T> input, Long blockSize, DepthToSpace.Options ... options) {
        return DepthToSpace.create(this.scope, input, blockSize, options);
    }

    public <T extends TNumber> DepthwiseConv2dNative<T> depthwiseConv2dNative(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, DepthwiseConv2dNative.Options ... options) {
        return DepthwiseConv2dNative.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends TNumber> DepthwiseConv2dNativeBackpropFilter<T> depthwiseConv2dNativeBackpropFilter(Operand<T> input, Operand<TInt32> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, DepthwiseConv2dNativeBackpropFilter.Options ... options) {
        return DepthwiseConv2dNativeBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> DepthwiseConv2dNativeBackpropInput<T> depthwiseConv2dNativeBackpropInput(Operand<TInt32> inputSizes, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding, DepthwiseConv2dNativeBackpropInput.Options ... options) {
        return DepthwiseConv2dNativeBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> Dilation2d<T> dilation2d(Operand<T> input, Operand<T> filter, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2d.create(this.scope, input, filter, strides, rates, padding);
    }

    public <T extends TNumber> Dilation2dBackpropFilter<T> dilation2dBackpropFilter(Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2dBackpropFilter.create(this.scope, input, filter, outBackprop, strides, rates, padding);
    }

    public <T extends TNumber> Dilation2dBackpropInput<T> dilation2dBackpropInput(Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2dBackpropInput.create(this.scope, input, filter, outBackprop, strides, rates, padding);
    }

    public <T extends TNumber> Elu<T> elu(Operand<T> features) {
        return Elu.create(this.scope, features);
    }

    public <T extends TNumber> EluGrad<T> eluGrad(Operand<T> gradients, Operand<T> outputs) {
        return EluGrad.create(this.scope, gradients, outputs);
    }

    public FixedUnigramCandidateSampler fixedUnigramCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, FixedUnigramCandidateSampler.Options ... options) {
        return FixedUnigramCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <T extends TNumber> FractionalAvgPool<T> fractionalAvgPool(Operand<T> value, List<Float> poolingRatio, FractionalAvgPool.Options ... options) {
        return FractionalAvgPool.create(this.scope, value, poolingRatio, options);
    }

    public <T extends TNumber> FractionalAvgPoolGrad<T> fractionalAvgPoolGrad(Operand<TInt64> origInputTensorShape, Operand<T> outBackprop, Operand<TInt64> rowPoolingSequence, Operand<TInt64> colPoolingSequence, FractionalAvgPoolGrad.Options ... options) {
        return FractionalAvgPoolGrad.create(this.scope, origInputTensorShape, outBackprop, rowPoolingSequence, colPoolingSequence, options);
    }

    public <T extends TNumber> FractionalMaxPool<T> fractionalMaxPool(Operand<T> value, List<Float> poolingRatio, FractionalMaxPool.Options ... options) {
        return FractionalMaxPool.create(this.scope, value, poolingRatio, options);
    }

    public <T extends TNumber> FractionalMaxPoolGrad<T> fractionalMaxPoolGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> outBackprop, Operand<TInt64> rowPoolingSequence, Operand<TInt64> colPoolingSequence, FractionalMaxPoolGrad.Options ... options) {
        return FractionalMaxPoolGrad.create(this.scope, origInput, origOutput, outBackprop, rowPoolingSequence, colPoolingSequence, options);
    }

    public <T extends TNumber, U extends TNumber> FusedBatchNorm<T, U> fusedBatchNorm(Operand<T> x, Operand<U> scale, Operand<U> offset, Operand<U> mean, Operand<U> variance, FusedBatchNorm.Options ... options) {
        return FusedBatchNorm.create(this.scope, x, scale, offset, mean, variance, options);
    }

    public <T extends TNumber, U extends TNumber> FusedBatchNormGrad<T, U> fusedBatchNormGrad(Operand<T> yBackprop, Operand<T> x, Operand<TFloat32> scale, Operand<U> reserveSpace1, Operand<U> reserveSpace2, Operand<U> reserveSpace3, FusedBatchNormGrad.Options ... options) {
        return FusedBatchNormGrad.create(this.scope, yBackprop, x, scale, reserveSpace1, reserveSpace2, reserveSpace3, options);
    }

    public <T extends TNumber> FusedPadConv2d<T> fusedPadConv2d(Operand<T> input, Operand<TInt32> paddings, Operand<T> filter, String mode, List<Long> strides, String padding) {
        return FusedPadConv2d.create(this.scope, input, paddings, filter, mode, strides, padding);
    }

    public <T extends TNumber> FusedResizeAndPadConv2d<T> fusedResizeAndPadConv2d(Operand<T> input, Operand<TInt32> sizeOutput, Operand<TInt32> paddings, Operand<T> filter, String mode, List<Long> strides, String padding, FusedResizeAndPadConv2d.Options ... options) {
        return FusedResizeAndPadConv2d.create(this.scope, input, sizeOutput, paddings, filter, mode, strides, padding, options);
    }

    public <T extends TNumber> GRUBlockCell<T> gRUBlockCell(Operand<T> x, Operand<T> hPrev, Operand<T> wRu, Operand<T> wC, Operand<T> bRu, Operand<T> bC) {
        return GRUBlockCell.create(this.scope, x, hPrev, wRu, wC, bRu, bC);
    }

    public <T extends TNumber> GRUBlockCellGrad<T> gRUBlockCellGrad(Operand<T> x, Operand<T> hPrev, Operand<T> wRu, Operand<T> wC, Operand<T> bRu, Operand<T> bC, Operand<T> r, Operand<T> u, Operand<T> c, Operand<T> dH) {
        return GRUBlockCellGrad.create(this.scope, x, hPrev, wRu, wC, bRu, bC, r, u, c, dH);
    }

    public <T extends TNumber> InTopK inTopK(Operand<TFloat32> predictions, Operand<T> targets, Operand<T> k) {
        return InTopK.create(this.scope, predictions, targets, k);
    }

    public <T extends TType> InvGrad<T> invGrad(Operand<T> y, Operand<T> dy) {
        return InvGrad.create(this.scope, y, dy);
    }

    public IsotonicRegression<TFloat32> isotonicRegression(Operand<? extends TNumber> input) {
        return IsotonicRegression.create(this.scope, input);
    }

    public <U extends TNumber> IsotonicRegression<U> isotonicRegression(Operand<? extends TNumber> input, Class<U> outputDtype) {
        return IsotonicRegression.create(this.scope, input, outputDtype);
    }

    public <T extends TNumber> L2Loss<T> l2Loss(Operand<T> t) {
        return L2Loss.create(this.scope, t);
    }

    public <T extends TNumber> LSTMBlockCell<T> lSTMBlockCell(Operand<T> x, Operand<T> csPrev, Operand<T> hPrev, Operand<T> w, Operand<T> wci, Operand<T> wcf, Operand<T> wco, Operand<T> b, LSTMBlockCell.Options ... options) {
        return LSTMBlockCell.create(this.scope, x, csPrev, hPrev, w, wci, wcf, wco, b, options);
    }

    public <T extends TNumber> LSTMBlockCellGrad<T> lSTMBlockCellGrad(Operand<T> x, Operand<T> csPrev, Operand<T> hPrev, Operand<T> w, Operand<T> wci, Operand<T> wcf, Operand<T> wco, Operand<T> b, Operand<T> i, Operand<T> cs, Operand<T> f, Operand<T> o, Operand<T> ci, Operand<T> co, Operand<T> csGrad, Operand<T> hGrad, Boolean usePeephole) {
        return LSTMBlockCellGrad.create(this.scope, x, csPrev, hPrev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, csGrad, hGrad, usePeephole);
    }

    public <T extends TNumber> LeakyRelu<T> leakyRelu(Operand<T> features, LeakyRelu.Options ... options) {
        return LeakyRelu.create(this.scope, features, options);
    }

    public LearnedUnigramCandidateSampler learnedUnigramCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, LearnedUnigramCandidateSampler.Options ... options) {
        return LearnedUnigramCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <T extends TNumber> LocalResponseNormalization<T> localResponseNormalization(Operand<T> input, LocalResponseNormalization.Options ... options) {
        return LocalResponseNormalization.create(this.scope, input, options);
    }

    public <T extends TNumber> LocalResponseNormalizationGrad<T> localResponseNormalizationGrad(Operand<T> inputGrads, Operand<T> inputImage, Operand<T> outputImage, LocalResponseNormalizationGrad.Options ... options) {
        return LocalResponseNormalizationGrad.create(this.scope, inputGrads, inputImage, outputImage, options);
    }

    public <T extends TNumber> LogSoftmax<T> logSoftmax(Operand<T> logits) {
        return LogSoftmax.create(this.scope, logits);
    }

    public <T extends TNumber> MaxPool<T> maxPool(Operand<T> input, Operand<TInt32> ksize, Operand<TInt32> strides, String padding, MaxPool.Options ... options) {
        return MaxPool.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPool3d<T> maxPool3d(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, MaxPool3d.Options ... options) {
        return MaxPool3d.create(this.scope, input, ksize, strides, padding, options);
    }

    public <U extends TNumber, T extends TNumber> MaxPool3dGrad<U> maxPool3dGrad(Operand<T> origInput, Operand<T> origOutput, Operand<U> grad, List<Long> ksize, List<Long> strides, String padding, MaxPool3dGrad.Options ... options) {
        return MaxPool3dGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPool3dGradGrad<T> maxPool3dGradGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, MaxPool3dGradGrad.Options ... options) {
        return MaxPool3dGradGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolGrad<T> maxPoolGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, Operand<TInt32> ksize, Operand<TInt32> strides, String padding, MaxPoolGrad.Options ... options) {
        return MaxPoolGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolGradGrad<T> maxPoolGradGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, Operand<TInt32> ksize, Operand<TInt32> strides, String padding, MaxPoolGradGrad.Options ... options) {
        return MaxPoolGradGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolGradGradWithArgmax<T> maxPoolGradGradWithArgmax(Operand<T> input, Operand<T> grad, Operand<? extends TNumber> argmax, List<Long> ksize, List<Long> strides, String padding, MaxPoolGradGradWithArgmax.Options ... options) {
        return MaxPoolGradGradWithArgmax.create(this.scope, input, grad, argmax, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolGradWithArgmax<T> maxPoolGradWithArgmax(Operand<T> input, Operand<T> grad, Operand<? extends TNumber> argmax, List<Long> ksize, List<Long> strides, String padding, MaxPoolGradWithArgmax.Options ... options) {
        return MaxPoolGradWithArgmax.create(this.scope, input, grad, argmax, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolWithArgmax<T, TInt64> maxPoolWithArgmax(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, MaxPoolWithArgmax.Options[] options) {
        return MaxPoolWithArgmax.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends TNumber, U extends TNumber> MaxPoolWithArgmax<T, U> maxPoolWithArgmax(Operand<T> input, List<Long> ksize, List<Long> strides, Class<U> Targmax, String padding, MaxPoolWithArgmax.Options ... options) {
        return MaxPoolWithArgmax.create(this.scope, input, ksize, strides, Targmax, padding, options);
    }

    public <T extends TNumber> NthElement<T> nthElement(Operand<T> input, Operand<TInt32> n, NthElement.Options ... options) {
        return NthElement.create(this.scope, input, n, options);
    }

    public <T extends TNumber> QuantizedAvgPool<T> quantizedAvgPool(Operand<T> input, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        return QuantizedAvgPool.create(this.scope, input, minInput, maxInput, ksize, strides, padding);
    }

    public <U extends TNumber, T extends TNumber> QuantizedBatchNormWithGlobalNormalization<U> quantizedBatchNormWithGlobalNormalization(Operand<T> t, Operand<TFloat32> tMin, Operand<TFloat32> tMax, Operand<T> m, Operand<TFloat32> mMin, Operand<TFloat32> mMax, Operand<T> v, Operand<TFloat32> vMin, Operand<TFloat32> vMax, Operand<T> beta, Operand<TFloat32> betaMin, Operand<TFloat32> betaMax, Operand<T> gamma, Operand<TFloat32> gammaMin, Operand<TFloat32> gammaMax, Class<U> outType, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return QuantizedBatchNormWithGlobalNormalization.create(this.scope, t, tMin, tMax, m, mMin, mMax, v, vMin, vMax, beta, betaMin, betaMax, gamma, gammaMin, gammaMax, outType, varianceEpsilon, scaleAfterNormalization);
    }

    public <V extends TNumber> QuantizedBiasAdd<V> quantizedBiasAdd(Operand<? extends TNumber> input, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minBias, Operand<TFloat32> maxBias, Class<V> outType) {
        return QuantizedBiasAdd.create(this.scope, input, bias, minInput, maxInput, minBias, maxBias, outType);
    }

    public <V extends TNumber> QuantizedConv2DAndRelu<V> quantizedConv2DAndRelu(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedConv2DAndRelu.Options ... options) {
        return QuantizedConv2DAndRelu.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedConv2DAndReluAndRequantize<V> quantizedConv2DAndReluAndRequantize(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Class<V> outType, List<Long> strides, String padding, QuantizedConv2DAndReluAndRequantize.Options ... options) {
        return QuantizedConv2DAndReluAndRequantize.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, minFreezedOutput, maxFreezedOutput, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedConv2DAndRequantize<V> quantizedConv2DAndRequantize(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Class<V> outType, List<Long> strides, String padding, QuantizedConv2DAndRequantize.Options ... options) {
        return QuantizedConv2DAndRequantize.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, minFreezedOutput, maxFreezedOutput, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedConv2DPerChannel<V> quantizedConv2DPerChannel(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedConv2DPerChannel.Options ... options) {
        return QuantizedConv2DPerChannel.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedConv2DWithBias<V> quantizedConv2DWithBias(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedConv2DWithBias.Options ... options) {
        return QuantizedConv2DWithBias.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedConv2DWithBiasAndRelu<V> quantizedConv2DWithBiasAndRelu(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedConv2DWithBiasAndRelu.Options ... options) {
        return QuantizedConv2DWithBiasAndRelu.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <W extends TNumber> QuantizedConv2DWithBiasAndReluAndRequantize<W> quantizedConv2DWithBiasAndReluAndRequantize(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Class<W> outType, List<Long> strides, String padding, QuantizedConv2DWithBiasAndReluAndRequantize.Options ... options) {
        return QuantizedConv2DWithBiasAndReluAndRequantize.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, minFreezedOutput, maxFreezedOutput, outType, strides, padding, options);
    }

    public <W extends TNumber> QuantizedConv2DWithBiasAndRequantize<W> quantizedConv2DWithBiasAndRequantize(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Class<W> outType, List<Long> strides, String padding, QuantizedConv2DWithBiasAndRequantize.Options ... options) {
        return QuantizedConv2DWithBiasAndRequantize.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, minFreezedOutput, maxFreezedOutput, outType, strides, padding, options);
    }

    public <X extends TNumber> QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<X> quantizedConv2DWithBiasSignedSumAndReluAndRequantize(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Operand<? extends TNumber> summand, Operand<TFloat32> minSummand, Operand<TFloat32> maxSummand, Class<X> outType, List<Long> strides, String padding, QuantizedConv2DWithBiasSignedSumAndReluAndRequantize.Options ... options) {
        return QuantizedConv2DWithBiasSignedSumAndReluAndRequantize.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, minFreezedOutput, maxFreezedOutput, summand, minSummand, maxSummand, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedConv2DWithBiasSumAndRelu<V> quantizedConv2DWithBiasSumAndRelu(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> summand, Class<V> outType, List<Long> strides, String padding, QuantizedConv2DWithBiasSumAndRelu.Options ... options) {
        return QuantizedConv2DWithBiasSumAndRelu.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, summand, outType, strides, padding, options);
    }

    public <X extends TNumber> QuantizedConv2DWithBiasSumAndReluAndRequantize<X> quantizedConv2DWithBiasSumAndReluAndRequantize(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Operand<? extends TNumber> summand, Operand<TFloat32> minSummand, Operand<TFloat32> maxSummand, Class<X> outType, List<Long> strides, String padding, QuantizedConv2DWithBiasSumAndReluAndRequantize.Options ... options) {
        return QuantizedConv2DWithBiasSumAndReluAndRequantize.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, minFreezedOutput, maxFreezedOutput, summand, minSummand, maxSummand, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedConv2d<V> quantizedConv2d(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedConv2d.Options ... options) {
        return QuantizedConv2d.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedDepthwiseConv2D<V> quantizedDepthwiseConv2D(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedDepthwiseConv2D.Options ... options) {
        return QuantizedDepthwiseConv2D.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedDepthwiseConv2DWithBias<V> quantizedDepthwiseConv2DWithBias(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedDepthwiseConv2DWithBias.Options ... options) {
        return QuantizedDepthwiseConv2DWithBias.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <V extends TNumber> QuantizedDepthwiseConv2DWithBiasAndRelu<V> quantizedDepthwiseConv2DWithBiasAndRelu(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedDepthwiseConv2DWithBiasAndRelu.Options ... options) {
        return QuantizedDepthwiseConv2DWithBiasAndRelu.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <W extends TNumber> QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize<W> quantizedDepthwiseConv2DWithBiasAndReluAndRequantize(Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Class<W> outType, List<Long> strides, String padding, QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize.Options ... options) {
        return QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize.create(this.scope, input, filter, bias, minInput, maxInput, minFilter, maxFilter, minFreezedOutput, maxFreezedOutput, outType, strides, padding, options);
    }

    public <T extends TNumber> QuantizedInstanceNorm<T> quantizedInstanceNorm(Operand<T> x, Operand<TFloat32> xMin, Operand<TFloat32> xMax, QuantizedInstanceNorm.Options ... options) {
        return QuantizedInstanceNorm.create(this.scope, x, xMin, xMax, options);
    }

    public <T extends TNumber> QuantizedMaxPool<T> quantizedMaxPool(Operand<T> input, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        return QuantizedMaxPool.create(this.scope, input, minInput, maxInput, ksize, strides, padding);
    }

    public <U extends TNumber> QuantizedRelu<U> quantizedRelu(Operand<? extends TNumber> features, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, Class<U> outType) {
        return QuantizedRelu.create(this.scope, features, minFeatures, maxFeatures, outType);
    }

    public <U extends TNumber> QuantizedRelu6<U> quantizedRelu6(Operand<? extends TNumber> features, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, Class<U> outType) {
        return QuantizedRelu6.create(this.scope, features, minFeatures, maxFeatures, outType);
    }

    public <U extends TNumber> QuantizedReluX<U> quantizedReluX(Operand<? extends TNumber> features, Operand<TFloat32> maxValue, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, Class<U> outType) {
        return QuantizedReluX.create(this.scope, features, maxValue, minFeatures, maxFeatures, outType);
    }

    public <T extends TNumber> Relu<T> relu(Operand<T> features) {
        return Relu.create(this.scope, features);
    }

    public <T extends TNumber> Relu6<T> relu6(Operand<T> features) {
        return Relu6.create(this.scope, features);
    }

    public <T extends TNumber> Relu6Grad<T> relu6Grad(Operand<T> gradients, Operand<T> features) {
        return Relu6Grad.create(this.scope, gradients, features);
    }

    public <T extends TNumber> ReluGrad<T> reluGrad(Operand<T> gradients, Operand<T> features) {
        return ReluGrad.create(this.scope, gradients, features);
    }

    public <T extends TNumber> Selu<T> selu(Operand<T> features) {
        return Selu.create(this.scope, features);
    }

    public <T extends TNumber> SeluGrad<T> seluGrad(Operand<T> gradients, Operand<T> outputs) {
        return SeluGrad.create(this.scope, gradients, outputs);
    }

    public <T extends TNumber> Softmax<T> softmax(Operand<T> logits) {
        return Softmax.create(this.scope, logits);
    }

    public <T extends TNumber> SoftmaxCrossEntropyWithLogits<T> softmaxCrossEntropyWithLogits(Operand<T> features, Operand<T> labels) {
        return SoftmaxCrossEntropyWithLogits.create(this.scope, features, labels);
    }

    public <T extends TNumber> Softsign<T> softsign(Operand<T> features) {
        return Softsign.create(this.scope, features);
    }

    public <T extends TNumber> SoftsignGrad<T> softsignGrad(Operand<T> gradients, Operand<T> features) {
        return SoftsignGrad.create(this.scope, gradients, features);
    }

    public <T extends TType> SpaceToBatch<T> spaceToBatch(Operand<T> input, Operand<? extends TNumber> paddings, Long blockSize) {
        return SpaceToBatch.create(this.scope, input, paddings, blockSize);
    }

    public <T extends TType> SpaceToDepth<T> spaceToDepth(Operand<T> input, Long blockSize, SpaceToDepth.Options ... options) {
        return SpaceToDepth.create(this.scope, input, blockSize, options);
    }

    public <T extends TNumber> SparseSoftmaxCrossEntropyWithLogits<T> sparseSoftmaxCrossEntropyWithLogits(Operand<T> features, Operand<? extends TNumber> labels) {
        return SparseSoftmaxCrossEntropyWithLogits.create(this.scope, features, labels);
    }

    public <T extends TNumber> TopK<T, TInt32> topK(Operand<T> input, Operand<? extends TNumber> k, TopK.Options[] options) {
        return TopK.create(this.scope, input, k, options);
    }

    public <T extends TNumber, V extends TNumber> TopK<T, V> topK(Operand<T> input, Operand<? extends TNumber> k, Class<V> indexType, TopK.Options ... options) {
        return TopK.create(this.scope, input, k, indexType, options);
    }

    public <U extends TNumber, T extends TNumber> UniformQuantizedConvolution<U> uniformQuantizedConvolution(Operand<T> lhs, Operand<T> rhs, Operand<TFloat32> lhsScales, Operand<TInt32> lhsZeroPoints, Operand<TFloat32> rhsScales, Operand<TInt32> rhsZeroPoints, Operand<TFloat32> outputScales, Operand<TInt32> outputZeroPoints, Class<U> Tout, String padding, Long lhsQuantizationMinVal, Long lhsQuantizationMaxVal, Long rhsQuantizationMinVal, Long rhsQuantizationMaxVal, Long outputQuantizationMinVal, Long outputQuantizationMaxVal, UniformQuantizedConvolution.Options ... options) {
        return UniformQuantizedConvolution.create(this.scope, lhs, rhs, lhsScales, lhsZeroPoints, rhsScales, rhsZeroPoints, outputScales, outputZeroPoints, Tout, padding, lhsQuantizationMinVal, lhsQuantizationMaxVal, rhsQuantizationMinVal, rhsQuantizationMaxVal, outputQuantizationMinVal, outputQuantizationMaxVal, options);
    }

    public <V extends TNumber> UniformQuantizedConvolutionHybrid<V> uniformQuantizedConvolutionHybrid(Operand<? extends TNumber> lhs, Operand<? extends TNumber> rhs, Operand<TFloat32> rhsScales, Operand<TInt32> rhsZeroPoints, Class<V> Tout, String padding, Long rhsQuantizationMinVal, Long rhsQuantizationMaxVal, UniformQuantizedConvolutionHybrid.Options ... options) {
        return UniformQuantizedConvolutionHybrid.create(this.scope, lhs, rhs, rhsScales, rhsZeroPoints, Tout, padding, rhsQuantizationMinVal, rhsQuantizationMaxVal, options);
    }

    public final Ops ops() {
        return this.ops;
    }
}

