/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaReduceWindow", inputsClass=Inputs.class)
public final class ReduceWindow<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaReduceWindow";
    private Output<T> output;

    public ReduceWindow(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TNumber> ReduceWindow<T> create(Scope scope, Operand<T> input, Operand<T> initValue, Operand<U> windowDimensions, Operand<U> windowStrides, Operand<U> baseDilations, Operand<U> windowDilations, Operand<U> padding, ConcreteFunction computation) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ReduceWindow");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(initValue.asOutput());
        opBuilder.addInput(windowDimensions.asOutput());
        opBuilder.addInput(windowStrides.asOutput());
        opBuilder.addInput(baseDilations.asOutput());
        opBuilder.addInput(windowDilations.asOutput());
        opBuilder.addInput(padding.asOutput());
        opBuilder.setAttr("computation", computation);
        return new ReduceWindow<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ReduceWindow.class)
    public static class Inputs<T extends TType, U extends TNumber>
    extends RawOpInputs<ReduceWindow<T>> {
        public final Operand<T> input;
        public final Operand<T> initValue;
        public final Operand<U> windowDimensions;
        public final Operand<U> windowStrides;
        public final Operand<U> baseDilations;
        public final Operand<U> windowDilations;
        public final Operand<U> padding;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new ReduceWindow(op), op, Arrays.asList("T", "Tindices"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.initValue = op.input(inputIndex++);
            this.windowDimensions = op.input(inputIndex++);
            this.windowStrides = op.input(inputIndex++);
            this.baseDilations = op.input(inputIndex++);
            this.windowDilations = op.input(inputIndex++);
            this.padding = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

